/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.maptrades;

import com.telepathicgrunt.repurposedstructures.misc.maptrades.MerchantMapUpdating;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.jetbrains.annotations.Nullable;

public class StructureSpecificMaps {

    public static class TreasureMapForEmeralds
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final ResourceKey<Structure> destination;
        private final TagKey<Structure> destinationTag;
        private final String displayName;
        private final Holder.Reference<MapDecorationType> destinationType;
        private final int maxUses;
        private final int villagerXp;
        private final int spawnRegionSearchRadius;

        public TreasureMapForEmeralds(int emeraldCost, String csf, String displayName, Holder.Reference<MapDecorationType> mapIcon, int maxUse, int xp, int spawnRegionSearchRadius) {
            this.emeraldCost = emeraldCost;
            if (csf.startsWith("#")) {
                this.destination = null;
                this.destinationTag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.tryParse((String)csf.replaceFirst("#", "")));
            } else {
                this.destination = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.tryParse((String)csf));
                this.destinationTag = null;
            }
            this.displayName = displayName;
            this.destinationType = mapIcon;
            this.maxUses = maxUse;
            this.villagerXp = xp;
            this.spawnRegionSearchRadius = spawnRegionSearchRadius;
        }

        @Nullable
        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            Level level = entity.level();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)level;
            return this.getOffer(serverlevel, entity);
        }

        private HolderSet<Structure> getHolderSet(ServerLevel level) {
            Registry registry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            return HolderSet.direct((Holder[])new Holder[]{registry.getOrThrow(this.destination)});
        }

        private boolean mapValid(ServerLevel level) {
            HolderSet holderSet;
            if (this.destinationTag == null) {
                holderSet = this.getHolderSet(level);
            } else {
                Optional optionalHolders = level.registryAccess().lookupOrThrow(Registries.STRUCTURE).get(this.destinationTag);
                if (optionalHolders.isEmpty()) {
                    return false;
                }
                holderSet = (HolderSet)optionalHolders.get();
            }
            boolean isValidSpawning = true;
            for (Holder structureHolder : holderSet) {
                if (level.getChunkSource().getGeneratorState().getPlacementsForStructure(structureHolder).isEmpty()) {
                    isValidSpawning = false;
                    break;
                }
                if (!level.getChunkSource().getGenerator().getBiomeSource().possibleBiomes().stream().noneMatch(e -> ((Structure)structureHolder.value()).biomes().contains(e))) continue;
                isValidSpawning = false;
                break;
            }
            return isValidSpawning;
        }

        private MerchantOffer getOffer(ServerLevel level, Entity entity) {
            if (!this.mapValid(level)) {
                return null;
            }
            if (this.destinationTag == null) {
                HolderSet<Structure> holderSet = this.getHolderSet(level);
                return MerchantMapUpdating.updateMapAsync(entity, this.emeraldCost, this.displayName, this.destinationType, this.maxUses, this.villagerXp, holderSet, this.spawnRegionSearchRadius);
            }
            return MerchantMapUpdating.updateMapAsync(entity, this.emeraldCost, this.displayName, this.destinationType, this.maxUses, this.villagerXp, this.destinationTag, this.spawnRegionSearchRadius);
        }
    }
}

