/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.client.gui.screens.armorstand;

import fuzs.armorstatues.init.ModRegistry;
import fuzs.armorstatues.network.client.data.CommandDataSyncHandler;
import fuzs.statuemenus.api.v1.client.gui.screens.ArmorStandPositionScreen;
import fuzs.statuemenus.api.v1.client.gui.screens.ArmorStandWidgetsScreen;
import fuzs.statuemenus.api.v1.helper.ScaleAttributeHelper;
import fuzs.statuemenus.api.v1.network.client.data.DataSyncHandler;
import fuzs.statuemenus.api.v1.world.inventory.ArmorStandHolder;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandScreenType;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public class CommandsCompatiblePositionScreen
extends ArmorStandPositionScreen {
    protected static final ArmorStandWidgetsScreen.ArmorStandWidgetFactory<CommandsCompatiblePositionScreen> SCALE_WIDGET_FACTORY = (screen, armorStand) -> {
        CommandsCompatiblePositionScreen commandsCompatiblePositionScreen = screen;
        Objects.requireNonNull(commandsCompatiblePositionScreen);
        return commandsCompatiblePositionScreen.new CommandsScaleWidget((Component)Component.translatable((String)"statuemenus.screen.position.scale"), () -> ((ArmorStand)armorStand).getScale(), arg_0 -> ((DataSyncHandler)screen.dataSyncHandler).sendScale(arg_0));
    };

    public CommandsCompatiblePositionScreen(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
    }

    protected List<ArmorStandWidgetsScreen.ArmorStandWidget> buildWidgets(ArmorStand armorStand) {
        return CommandsCompatiblePositionScreen.buildWidgets((ArmorStandWidgetsScreen)this, (ArmorStand)armorStand, List.of(SCALE_WIDGET_FACTORY, ROTATION_WIDGET_FACTORY, POSITION_INCREMENT_WIDGET_FACTORY, POSITION_X_WIDGET_FACTORY, POSITION_Y_WIDGET_FACTORY, POSITION_Z_WIDGET_FACTORY));
    }

    public ArmorStandScreenType getScreenType() {
        return ModRegistry.POSITION_SCREEN_TYPE;
    }

    protected class CommandsScaleWidget
    extends ArmorStandPositionScreen.ScaleWidget {
        @Nullable
        private Boolean hasModifier;

        public CommandsScaleWidget(Component title, DoubleSupplier currentValue, Consumer<Float> newValue) {
            super((ArmorStandPositionScreen)CommandsCompatiblePositionScreen.this, title, currentValue, newValue);
        }

        protected void setNewValue(double newValue) {
            DataSyncHandler dataSyncHandler = CommandsCompatiblePositionScreen.this.dataSyncHandler;
            if (dataSyncHandler instanceof CommandDataSyncHandler) {
                CommandDataSyncHandler commandDataSyncHandler = (CommandDataSyncHandler)dataSyncHandler;
                commandDataSyncHandler.sendScale(this.hasModifier == null || this.hasModifier != false, CommandsScaleWidget.getScaledValue((double)newValue), true);
            } else {
                super.setNewValue(newValue);
            }
            this.hasModifier = null;
        }

        protected void applyClientValue(double newValue) {
            if (this.hasModifier == null) {
                this.hasModifier = CommandsCompatiblePositionScreen.this.getHolder().getArmorStand().getAttributes().hasModifier(Attributes.SCALE, ScaleAttributeHelper.SCALE_BONUS_ID);
            }
            super.applyClientValue(newValue);
        }
    }
}

