/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.matyrobbrt.registrationutils.specialised;

import com.cursee.matyrobbrt.registrationutils.RegistrationProvider;
import com.cursee.matyrobbrt.registrationutils.RegistryObject;
import com.cursee.matyrobbrt.registrationutils.specialised.ItemRegistryObject;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public interface ItemRegistrationProvider
extends RegistrationProvider<Item> {
    public static ItemRegistrationProvider get(String modId) {
        return RegistrationProvider.Factory.INSTANCE.item(modId);
    }

    public <I extends Item> ItemRegistryObject<I> register(String var1, Supplier<? extends I> var2);

    default public ItemRegistryObject<Item> register(String name) {
        return this.register(name, new Item.Properties(), Item::new);
    }

    default public <I extends Item> ItemRegistryObject<I> register(String name, Item.Properties properties, Function<Item.Properties, ? extends I> func) {
        return this.register(name, () -> (Item)func.apply(properties));
    }

    default public <B extends Block> ItemRegistryObject<BlockItem> registerBlockItem(RegistryObject<Block, B> block) {
        return this.registerBlockItem(block, new Item.Properties());
    }

    default public <B extends Block> ItemRegistryObject<BlockItem> registerBlockItem(RegistryObject<Block, B> block, Item.Properties properties) {
        return this.registerBlockItem(block, properties, BlockItem::new);
    }

    default public <B extends Block, I extends BlockItem> ItemRegistryObject<I> registerBlockItem(RegistryObject<Block, B> block, Item.Properties properties, BiFunction<B, Item.Properties, ? extends I> func) {
        return this.register(block.getId().getPath(), () -> (BlockItem)func.apply((Block)block.get(), properties));
    }
}

