/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.matyrobbrt.registrationutils.neoforge;

import com.cursee.matyrobbrt.registrationutils.EntityDataSerializerHelper;
import com.cursee.matyrobbrt.registrationutils.RegistrationProvider;
import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@ApiStatus.Internal
@AutoService(value={EntityDataSerializerHelper.class})
public class NeoForgeEntityDataSerializerHelper
implements EntityDataSerializerHelper {
    private final Map<String, RegistrationProvider<EntityDataSerializer<?>>> byModId = new ConcurrentHashMap();

    @Override
    public <T> EntityDataSerializer<T> register(ResourceLocation key, EntityDataSerializer<T> serializer) {
        this.getProvider(key.getNamespace()).register(key.getPath(), () -> serializer);
        return serializer;
    }

    private RegistrationProvider<EntityDataSerializer<?>> getProvider(String modId) {
        return this.byModId.computeIfAbsent(modId, theId -> RegistrationProvider.get(NeoForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, theId));
    }
}

