/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableAnimationController;
import fuzs.visualworkbench.world.level.block.entity.WorkbenchVisualsProvider;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class CraftingTableBlockEntityRenderer<T extends BlockEntity & WorkbenchVisualsProvider>
implements BlockEntityRenderer<T> {
    private final ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
    private final ItemRenderer itemRenderer;
    public final ItemModelResolver itemModelResolver;

    public CraftingTableBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, Vec3 cameraPosition) {
        Level level = blockEntity.getLevel();
        if (level != null) {
            int packedLightAbove = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockEntity.getBlockPos().above());
            for (int i = 0; i < ((Container)blockEntity).getContainerSize(); ++i) {
                ItemStack itemStack = ((Container)blockEntity).getItem(i);
                if (itemStack.isEmpty()) continue;
                this.renderIngredientItem(blockEntity, level, partialTick, poseStack, multiBufferSource, packedLightAbove, packedOverlay, i, itemStack);
            }
            ItemStack itemStack = ((WorkbenchVisualsProvider)blockEntity).getCraftingResult();
            if (!itemStack.isEmpty()) {
                this.renderResultItem(itemStack, level, (float)((WorkbenchVisualsProvider)blockEntity).getAnimationController().renderState().ticks + partialTick, poseStack, multiBufferSource, packedLightAbove, packedOverlay);
            }
        }
    }

    private void renderIngredientItem(T blockEntity, Level level, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, int i, ItemStack itemStack) {
        this.itemModelResolver.updateForTopItem(this.itemStackRenderState, itemStack, ItemDisplayContext.GROUND, level, null, 0);
        poseStack.pushPose();
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).flatRendering) {
            this.setupFlatRenderer(((WorkbenchVisualsProvider)blockEntity).getAnimationController().renderState(), CraftingTableBlockEntityRenderer.isGui3d(this.itemStackRenderState), partialTick, poseStack, i);
        } else {
            this.setupFloatingRenderer(((WorkbenchVisualsProvider)blockEntity).getAnimationController().renderState(), CraftingTableBlockEntityRenderer.isGui3d(this.itemStackRenderState), partialTick, poseStack, i);
        }
        this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, multiBufferSource, blockEntity.getLevel(), (int)blockEntity.getBlockPos().asLong() + i);
        poseStack.popPose();
    }

    private void setupFloatingRenderer(CraftingTableAnimationController.RenderState renderState, boolean isBlockItem, float partialTick, PoseStack poseStack, int index) {
        float shift = (float)Math.abs(((double)((float)renderState.ticks + partialTick) * 50.0 + (double)((long)index * 1000L)) % 5000.0 - 2500.0) / 200000.0f;
        poseStack.translate(0.5, (double)shift, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)renderState.currentAngle, (float)renderState.nextAngle)));
        poseStack.translate((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, 1.09375, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        float scale = isBlockItem ? 0.24f : 0.18f;
        poseStack.scale(scale, scale, scale);
    }

    private void setupFlatRenderer(CraftingTableAnimationController.RenderState renderState, boolean isBlockItem, float partialTick, PoseStack poseStack, int index) {
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)renderState.currentAngle, (float)renderState.nextAngle)));
        poseStack.translate((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, isBlockItem ? 1.0625 : 1.005, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        float scale = isBlockItem ? 0.25f : 0.175f;
        poseStack.scale(scale, scale, scale);
    }

    private void renderResultItem(ItemStack itemStack, Level level, float time, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).renderResult) {
            return;
        }
        this.itemModelResolver.updateForTopItem(this.itemStackRenderState, itemStack, ItemDisplayContext.GROUND, level, null, 0);
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.15f, 0.5f);
        float hoverOffset = Mth.sin((float)(time / 10.0f)) * 0.04f + 0.1f;
        AABB aABB = this.itemStackRenderState.getModelBoundingBox();
        float modelYScale = -((float)aABB.minY) + 0.0625f;
        poseStack.translate(0.0, (double)(hoverOffset + modelYScale), 0.0);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotation(time / 20.0f));
        if (!CraftingTableBlockEntityRenderer.isGui3d(this.itemStackRenderState)) {
            poseStack.scale(0.75f, 0.75f, 0.75f);
        }
        this.itemStackRenderState.render(poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.popPose();
    }

    static boolean isGui3d(ItemStackRenderState renderState) {
        return renderState.getModelBoundingBox().getZsize() > 0.0625;
    }
}

