/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableAnimationController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class ClientCraftingTableAnimationController
implements CraftingTableAnimationController {
    private final CraftingTableAnimationController.RenderState renderState = new CraftingTableAnimationController.RenderState();
    private final Vec3 position;
    private int sector;
    private boolean animating;
    private float animationAngleStart;
    private float animationAngleEnd;
    private double startTicks;
    private double playerAngle;

    public ClientCraftingTableAnimationController(BlockPos blockPos) {
        this.position = blockPos.getCenter();
    }

    @Override
    public void tick(Level level) {
        ++this.renderState.ticks;
        this.setPlayerAngle(level);
        this.setCurrentSector(this.renderState);
        this.updateAnimationAngles(this.renderState);
    }

    @Override
    public CraftingTableAnimationController.RenderState renderState() {
        return this.renderState;
    }

    private void setPlayerAngle(Level level) {
        Player player = this.getPlayer(level, ((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).rotateIngredients);
        if (player != null) {
            double d0 = player.getX() - this.position.x();
            double d1 = player.getZ() - this.position.z();
            this.playerAngle = (Math.atan2(-d0, -d1) + 3.9269908169872414) % (Math.PI * 2);
        }
    }

    @Nullable
    private Player getPlayer(Level level, ClientConfig.RotateIngredients rotateIngredients) {
        if (rotateIngredients != ClientConfig.RotateIngredients.NEVER) {
            return level.getNearestPlayer(this.position.x(), this.position.y(), this.position.z(), 3.0, entity -> {
                if (!EntitySelector.NO_SPECTATORS.test(entity)) {
                    return false;
                }
                if (rotateIngredients == ClientConfig.RotateIngredients.CLOSEST_PLAYER) {
                    return true;
                }
                Minecraft minecraft = Minecraft.getInstance();
                if (entity == minecraft.player) {
                    return minecraft.screen instanceof CraftingScreen;
                }
                return false;
            });
        }
        return null;
    }

    private void setCurrentSector(CraftingTableAnimationController.RenderState renderState) {
        int sector = (int)(this.playerAngle * 2.0 / Math.PI);
        if (this.sector != sector) {
            this.animating = true;
            this.animationAngleStart = renderState.currentAngle;
            float delta1 = (float)sector * 90.0f - renderState.currentAngle;
            float abs1 = Math.abs(delta1);
            float delta2 = delta1 + 360.0f;
            float shift = Math.abs(delta2);
            float delta3 = delta1 - 360.0f;
            float abs3 = Math.abs(delta3);
            this.animationAngleEnd = abs3 < abs1 && abs3 < shift ? delta3 + renderState.currentAngle : (shift < abs1 && shift < abs3 ? delta2 + renderState.currentAngle : delta1 + renderState.currentAngle);
            this.startTicks = renderState.ticks;
            this.sector = sector;
        }
    }

    private void updateAnimationAngles(CraftingTableAnimationController.RenderState renderState) {
        if (this.animating) {
            if ((double)renderState.ticks >= this.startTicks + 20.0) {
                this.animating = false;
                renderState.currentAngle = renderState.nextAngle = (this.animationAngleEnd + 360.0f) % 360.0f;
            } else {
                renderState.currentAngle = (ClientCraftingTableAnimationController.calcEaseOutQuad((double)renderState.ticks - this.startTicks, this.animationAngleStart, this.animationAngleEnd - this.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                renderState.nextAngle = (ClientCraftingTableAnimationController.calcEaseOutQuad(Math.min((double)(renderState.ticks + 1) - this.startTicks, 20.0), this.animationAngleStart, this.animationAngleEnd - this.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                if (renderState.currentAngle != 0.0f || renderState.nextAngle != 0.0f) {
                    if (renderState.currentAngle == 0.0f && renderState.nextAngle >= 180.0f) {
                        renderState.currentAngle = 360.0f;
                    }
                    if (renderState.nextAngle == 0.0f && renderState.currentAngle >= 180.0f) {
                        renderState.nextAngle = 360.0f;
                    }
                }
            }
        }
    }

    private static float calcEaseOutQuad(double t, float b, float c, double d) {
        float z = (float)t / (float)d;
        return -c * z * (z - 2.0f) + b;
    }
}

