/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockStateResolverContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderTypesContext;
import fuzs.puzzleslib.api.client.renderer.v1.model.ModelLoadingHelper;
import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.client.handler.BlockStateTranslator;
import fuzs.visualworkbench.client.renderer.blockentity.CraftingTableBlockEntityRenderer;
import fuzs.visualworkbench.handler.BlockConversionHandler;
import fuzs.visualworkbench.init.ModRegistry;
import java.util.Map;
import java.util.concurrent.Executor;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class VisualWorkbenchClient
implements ClientModConstructor {
    public void onRegisterBlockStateResolver(BlockStateResolverContext context) {
        BlockConversionHandler.getBlockConversions().forEach((oldBlock, newBlock) -> context.registerBlockStateResolver(newBlock, (resourceManager, executor) -> ModelLoadingHelper.loadBlockState((ResourceManager)resourceManager, (Block)oldBlock, (Executor)executor), (loadedModels, blockStateConsumer) -> {
            Map<BlockState, BlockState> blockStates = BlockStateTranslator.INSTANCE.convertAllBlockStates((Block)newBlock, (Block)oldBlock);
            for (BlockState blockState : newBlock.getStateDefinition().getPossibleStates()) {
                BlockStateModel.UnbakedRoot model = (BlockStateModel.UnbakedRoot)loadedModels.models().get(blockStates.get(blockState));
                if (model != null) {
                    blockStateConsumer.accept(blockState, model);
                    continue;
                }
                VisualWorkbench.LOGGER.warn("Missing model for variant: '{}'", (Object)blockState);
                blockStateConsumer.accept(blockState, ModelLoadingHelper.missingModel());
            }
        }));
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((MenuType)ModRegistry.CRAFTING_MENU_TYPE.value(), CraftingScreen::new);
    }

    public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
        context.registerBlockEntityRenderer((BlockEntityType)ModRegistry.CRAFTING_TABLE_BLOCK_ENTITY_TYPE.value(), CraftingTableBlockEntityRenderer::new);
    }

    public void onRegisterBlockRenderTypes(RenderTypesContext<Block> context) {
        for (Map.Entry entry : BlockConversionHandler.getBlockConversions().entrySet()) {
            context.registerChunkRenderType((Object)((Block)entry.getValue()), context.getChunkRenderType((Object)((Block)entry.getKey())));
        }
    }
}

