/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingManager;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupChatManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class RenderEvents {
    private static final ResourceLocation MICROPHONE_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/microphone.png");
    private static final ResourceLocation WHISPER_MICROPHONE_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/microphone_whisper.png");
    private static final ResourceLocation MICROPHONE_OFF_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/microphone_off.png");
    private static final ResourceLocation SPEAKER_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker.png");
    private static final ResourceLocation WHISPER_SPEAKER_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker_whisper.png");
    private static final ResourceLocation SPEAKER_OFF_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker_off.png");
    private static final ResourceLocation DISCONNECT_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/disconnected.png");
    private static final ResourceLocation GROUP_ICON = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/group.png");
    private final Minecraft minecraft = Minecraft.getInstance();

    public RenderEvents() {
        ClientCompatibilityManager.INSTANCE.onRenderNamePlate(this::onRenderName);
        ClientCompatibilityManager.INSTANCE.onRenderHUD(this::onRenderHUD);
    }

    private void onRenderHUD(GuiGraphics guiGraphics, float tickDelta) {
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        if (manager.isDisconnected() && this.isStartup()) {
            return;
        }
        if (manager.isDisconnected()) {
            this.renderIcon(guiGraphics, DISCONNECT_ICON);
        } else if (manager.isDisabled()) {
            this.renderIcon(guiGraphics, SPEAKER_OFF_ICON);
        } else if (manager.isMuted() && VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE)) {
            this.renderIcon(guiGraphics, MICROPHONE_OFF_ICON);
        } else if (client != null && client.getMicThread() != null) {
            if (client.getMicThread().isWhispering()) {
                this.renderIcon(guiGraphics, WHISPER_MICROPHONE_ICON);
            } else if (client.getMicThread().isTalking()) {
                this.renderIcon(guiGraphics, MICROPHONE_ICON);
            }
        }
        if (manager.getGroupID() != null && VoicechatClient.CLIENT_CONFIG.showGroupHUD.get().booleanValue()) {
            GroupChatManager.renderIcons(guiGraphics);
        }
    }

    private boolean isStartup() {
        ClientVoicechat client = ClientManager.getClient();
        return client != null && System.currentTimeMillis() - client.getStartTime() < 5000L;
    }

    private void renderIcon(GuiGraphics guiGraphics, ResourceLocation texture) {
        guiGraphics.pose().pushMatrix();
        int posX = VoicechatClient.CLIENT_CONFIG.hudIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.hudIconPosY.get();
        if (posX < 0) {
            guiGraphics.pose().translate((float)this.minecraft.getWindow().getGuiScaledWidth(), 0.0f);
        }
        if (posY < 0) {
            guiGraphics.pose().translate(0.0f, (float)this.minecraft.getWindow().getGuiScaledHeight());
        }
        guiGraphics.pose().translate((float)posX, (float)posY);
        float scale = VoicechatClient.CLIENT_CONFIG.hudIconScale.get().floatValue();
        guiGraphics.pose().scale(scale, scale);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, posX < 0 ? -16 : 0, posY < 0 ? -16 : 0, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.pose().popMatrix();
    }

    private void onRenderName(EntityRenderState renderState, Component component, PoseStack stack, MultiBufferSource vertexConsumers, int light) {
        if (component == null) {
            return;
        }
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        if (!(renderState instanceof PlayerRenderState)) {
            return;
        }
        PlayerRenderState playerRenderState = (PlayerRenderState)renderState;
        Entity entity = this.minecraft.level.getEntity(playerRenderState.id);
        if (entity == null) {
            return;
        }
        if (this.minecraft.player.equals((Object)entity)) {
            return;
        }
        if (!this.minecraft.options.hideGui) {
            ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
            ClientVoicechat client = ClientManager.getClient();
            UUID entityId = entity.getUUID();
            UUID groupId = manager.getGroup(entityId);
            if (client != null && client.getTalkCache().isWhispering(entityId)) {
                this.renderPlayerIcon(renderState, component, WHISPER_SPEAKER_ICON, stack, vertexConsumers, light);
            } else if (client != null && client.getTalkCache().isTalking(entityId)) {
                this.renderPlayerIcon(renderState, component, SPEAKER_ICON, stack, vertexConsumers, light);
            } else if (manager.isPlayerDisconnected(entityId)) {
                this.renderPlayerIcon(renderState, component, DISCONNECT_ICON, stack, vertexConsumers, light);
            } else if (groupId != null && !groupId.equals(manager.getGroupID())) {
                this.renderPlayerIcon(renderState, component, GROUP_ICON, stack, vertexConsumers, light);
            } else if (manager.isPlayerDisabled(entityId)) {
                this.renderPlayerIcon(renderState, component, SPEAKER_OFF_ICON, stack, vertexConsumers, light);
            }
        }
    }

    private void renderPlayerIcon(EntityRenderState renderState, Component component, ResourceLocation texture, PoseStack poseStack, MultiBufferSource buffer, int light) {
        if (renderState.nameTagAttachment == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(renderState.nameTagAttachment.x, renderState.nameTagAttachment.y + 0.5, renderState.nameTagAttachment.z);
        poseStack.mulPose((Quaternionfc)this.minecraft.getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        poseStack.translate(0.0, -1.0, 0.0);
        float offset = this.minecraft.font.width((FormattedText)component) / 2 + 2;
        VertexConsumer builder = buffer.getBuffer(RenderType.text((ResourceLocation)texture));
        int alpha = 32;
        if (renderState.isDiscrete) {
            RenderEvents.vertex(builder, poseStack, offset, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builder, poseStack, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builder, poseStack, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
            RenderEvents.vertex(builder, poseStack, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        } else {
            RenderEvents.vertex(builder, poseStack, offset, 10.0f, 0.0f, 0.0f, 1.0f, light);
            RenderEvents.vertex(builder, poseStack, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, light);
            RenderEvents.vertex(builder, poseStack, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, light);
            RenderEvents.vertex(builder, poseStack, offset, 0.0f, 0.0f, 0.0f, 0.0f, light);
            VertexConsumer builderSeeThrough = buffer.getBuffer(RenderType.textSeeThrough((ResourceLocation)texture));
            RenderEvents.vertex(builderSeeThrough, poseStack, offset, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, poseStack, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, poseStack, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, poseStack, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        }
        poseStack.popPose();
    }

    private boolean shouldShowIcons() {
        if (OnboardingManager.isOnboarding()) {
            return false;
        }
        if (ClientManager.getClient() != null && ClientManager.getClient().getConnection() != null && ClientManager.getClient().getConnection().isInitialized()) {
            return true;
        }
        return this.minecraft.getSingleplayerServer() == null || this.minecraft.getSingleplayerServer().isPublished();
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int light) {
        RenderEvents.vertex(builder, matrixStack, x, y, z, u, v, 255, light);
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int alpha, int light) {
        PoseStack.Pose entry = matrixStack.last();
        builder.addVertex(entry.pose(), x, y, z).setColor(255, 255, 255, alpha).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(entry, 0.0f, 0.0f, -1.0f);
    }
}

