/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class VoiceActivationSlider
extends DebouncedSlider
implements MicTestButton.MicListener {
    private static final ResourceLocation SLIDER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider");
    private static final ResourceLocation HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_highlighted");
    private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle_highlighted");
    private static final ResourceLocation VOICE_ACTIVATION_SLIDER = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/gui/voice_activation_slider.png");
    private static final Component NO_ACTIVATION = Component.translatable((String)"message.voicechat.voice_activation.disabled").withStyle(ChatFormatting.RED);
    private double micValue;

    public VoiceActivationSlider(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty(), Utils.dbToPerc(VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.get().floatValue()));
        this.updateMessage();
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getSlider(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int micWidth = (int)((double)(this.width - 2) * this.micValue);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, VOICE_ACTIVATION_SLIDER, this.getX() + 1, this.getY() + 1, 0.0f, 0.0f, micWidth, 18, 256, 256);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getHandle(), this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY(), 8, 20);
        this.renderScrollingString(guiGraphics, minecraft.font, 2, -1);
    }

    private ResourceLocation getSlider() {
        return this.isFocused() && !this.isHovered && !this.isFocused() ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    private ResourceLocation getHandle() {
        return !this.isHovered && !this.isFocused() ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    protected void updateMessage() {
        long db = Math.round(Utils.percToDb(this.value));
        MutableComponent component = Component.translatable((String)"message.voicechat.voice_activation", (Object[])new Object[]{db});
        if (db >= -10L) {
            component.withStyle(ChatFormatting.RED);
        }
        this.setMessage((Component)component);
    }

    @Nullable
    public Component getHoverText() {
        if (this.value >= 1.0) {
            return NO_ACTIVATION;
        }
        return null;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.set(Utils.percToDb(this.value)).save();
    }

    @Override
    public void onMicValue(double percentage) {
        this.micValue = percentage;
    }
}

