/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.gui.volume.AdjustVolumeList;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AdjustVolumesScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/gui/gui_volumes.png");
    protected static final Component TITLE = Component.translatable((String)"gui.voicechat.adjust_volume.title");
    protected static final Component SEARCH_HINT = Component.translatable((String)"message.voicechat.search_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    protected static final Component EMPTY_SEARCH = Component.translatable((String)"message.voicechat.search_empty").withStyle(ChatFormatting.GRAY);
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 8;
    protected static final int SEARCH_HEIGHT = 16;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected AdjustVolumeList volumeList;
    protected EditBox searchBox;
    protected String lastSearch = "";
    protected int units;

    public AdjustVolumesScreen() {
        super(TITLE, 236, 0);
    }

    public void tick() {
        super.tick();
    }

    @Override
    protected void init() {
        super.init();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = Mth.ceil((float)3.1111112f);
        this.units = Math.max(minUnits, (this.height - 16 - 8 - this.guiTop * 2 - 16) / 18);
        this.ySize = 16 + this.units * 18 + 8;
        if (this.volumeList != null) {
            this.volumeList.setRectangle(this.width, this.units * 18 - 16, 0, this.guiTop + 16 + 16);
        } else {
            this.volumeList = new AdjustVolumeList(this.width, this.units * 18 - 16, this.guiTop + 16 + 16, 36, this);
        }
        String string = this.searchBox != null ? this.searchBox.getValue() : "";
        this.searchBox = new EditBox(this.font, this.guiLeft + 28, this.guiTop + 16 + 6, 196, 16, SEARCH_HINT);
        this.searchBox.setMaxLength(16);
        this.searchBox.setBordered(false);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(-1);
        this.searchBox.setValue(string);
        this.searchBox.setResponder(this::checkSearchStringUpdate);
        this.addWidget((GuiEventListener)this.searchBox);
        this.addWidget((GuiEventListener)this.volumeList);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, 16, 256, 256);
        for (int i = 0; i < this.units; ++i) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * i, 0.0f, 16.0f, this.xSize, 18, 256, 256);
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0.0f, 34.0f, this.xSize, 8, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, (float)this.xSize, 0.0f, 12, 12, 256, 256);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.drawString(this.font, TITLE, this.width / 2 - this.font.width((FormattedText)TITLE) / 2, this.guiTop + 5, -12566464, false);
        if (!this.volumeList.isEmpty()) {
            this.volumeList.render(guiGraphics, mouseX, mouseY, delta);
        } else if (!this.searchBox.getValue().isEmpty()) {
            int n = this.width / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.font);
            guiGraphics.drawCenteredString(this.font, EMPTY_SEARCH, n, n2 - 9 / 2, -1);
        }
        if (!this.searchBox.isFocused() && this.searchBox.getValue().isEmpty()) {
            guiGraphics.drawString(this.font, SEARCH_HINT, this.searchBox.getX(), this.searchBox.getY(), -1, false);
        } else {
            this.searchBox.render(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.searchBox.isFocused()) {
            this.searchBox.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button) || this.volumeList.mouseClicked(mouseX, mouseY, button);
    }

    private void checkSearchStringUpdate(String string) {
        if (!(string = string.toLowerCase(Locale.ROOT)).equals(this.lastSearch)) {
            this.volumeList.setFilter(string);
            this.lastSearch = string;
        }
    }
}

