/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.onboarding;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreen;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingManager;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingScreenBase;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FinalOnboardingScreen
extends OnboardingScreenBase {
    private static final Component TITLE = Component.translatable((String)"message.voicechat.onboarding.final").withStyle(ChatFormatting.BOLD);
    private static final Component FINISH_SETUP = Component.translatable((String)"message.voicechat.onboarding.final.finish_setup");
    protected Component description = Component.empty();

    public FinalOnboardingScreen(@Nullable Screen previous) {
        super(TITLE, previous);
    }

    @Override
    protected void init() {
        super.init();
        MutableComponent text = Component.translatable((String)"message.voicechat.onboarding.final.description.success", (Object[])new Object[]{KeyEvents.KEY_VOICE_CHAT.getTranslatedKeyMessage().copy().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE})}).append("\n\n");
        text = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.PTT) ? text.append((Component)Component.translatable((String)"message.voicechat.onboarding.final.description.ptt", (Object[])new Object[]{KeyEvents.KEY_PTT.getTranslatedKeyMessage().copy().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE})}).withStyle(ChatFormatting.BOLD)).append("\n\n") : text.append((Component)Component.translatable((String)"message.voicechat.onboarding.final.description.voice", (Object[])new Object[]{KeyEvents.KEY_MUTE.getTranslatedKeyMessage().copy().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE})}).withStyle(ChatFormatting.BOLD)).append("\n\n");
        this.description = text.append((Component)Component.translatable((String)"message.voicechat.onboarding.final.description.configuration"));
        this.addBackOrCancelButton();
        this.addPositiveButton(FINISH_SETUP, button -> OnboardingManager.finishOnboarding());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTitle(guiGraphics, TITLE);
        this.renderMultilineText(guiGraphics, this.description);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            OnboardingManager.finishOnboarding();
            return true;
        }
        if (keyCode == ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_VOICE_CHAT).getValue()) {
            OnboardingManager.finishOnboarding();
            this.minecraft.setScreen((Screen)new VoiceChatScreen());
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }
}

