/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.google.common.collect.Lists;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class JoinGroupEntry
extends ListScreenEntryBase<JoinGroupEntry> {
    protected static final ResourceLocation LOCK = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/lock.png");
    protected static final Component GROUP_MEMBERS = Component.translatable((String)"message.voicechat.group_members").withStyle(ChatFormatting.GRAY);
    protected static final Component NO_GROUP_MEMBERS = Component.translatable((String)"message.voicechat.no_group_members").withStyle(ChatFormatting.GRAY);
    protected static final int SKIN_SIZE = 12;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = ARGB.color((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_SELECTED = ARGB.color((int)255, (int)90, (int)90, (int)90);
    protected static final int PLAYER_NAME_COLOR = ARGB.color((int)255, (int)255, (int)255, (int)255);
    protected final ListScreenBase parent;
    protected final Minecraft minecraft;
    protected final Group group;

    public JoinGroupEntry(ListScreenBase parent, Group group) {
        this.parent = parent;
        this.minecraft = Minecraft.getInstance();
        this.group = group;
    }

    public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        if (hovered) {
            guiGraphics.fill(left, top, left + width, top + height, BG_FILL_SELECTED);
        } else {
            guiGraphics.fill(left, top, left + width, top + height, BG_FILL);
        }
        boolean hasPassword = this.group.group.hasPassword();
        if (hasPassword) {
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)(left + 4), (float)top + (float)height / 2.0f - 8.0f);
            guiGraphics.pose().scale(1.3333334f, 1.3333334f);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, LOCK, 0, 0, 0.0f, 0.0f, 12, 12, 16, 16);
            guiGraphics.pose().popMatrix();
        }
        MutableComponent groupName = Component.literal((String)this.group.group.getName());
        Font font = this.minecraft.font;
        int n = left + 4 + (hasPassword ? 20 : 0);
        int n2 = top + height / 2;
        Objects.requireNonNull(this.minecraft.font);
        guiGraphics.drawString(font, (Component)groupName, n, n2 - 9 / 2, PLAYER_NAME_COLOR, false);
        int textWidth = this.minecraft.font.width((FormattedText)groupName) + (hasPassword ? 20 : 0);
        int headsPerRow = (width - (4 + textWidth + 4 + 4)) / 13;
        int rows = 2;
        for (int i = 0; i < this.group.members.size(); ++i) {
            PlayerState state = this.group.members.get(i);
            int headXIndex = i / rows;
            int headYIndex = i % rows;
            if (i >= headsPerRow * rows) break;
            int headPosX = left + width - 12 - 4 - headXIndex * 13;
            int headPosY = top + height / 2 - 13 + 13 * headYIndex;
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)headPosX, (float)headPosY);
            float scale = 1.5f;
            guiGraphics.pose().scale(scale, scale);
            PlayerSkin skin = GameProfileUtils.getSkin(state.getUuid());
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skin.texture(), 0, 0, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skin.texture(), 0, 0, 40.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.pose().popMatrix();
        }
        if (!hovered) {
            return;
        }
        ArrayList tooltip = Lists.newArrayList();
        if (this.group.getGroup().getType().equals(Group.Type.NORMAL)) {
            tooltip.add(Component.translatable((String)"message.voicechat.group_title", (Object[])new Object[]{Component.literal((String)this.group.getGroup().getName())}).getVisualOrderText());
        } else {
            tooltip.add(Component.translatable((String)"message.voicechat.group_type_title", (Object[])new Object[]{Component.literal((String)this.group.getGroup().getName()), GroupType.fromType(this.group.getGroup().getType()).getTranslation()}).getVisualOrderText());
        }
        if (this.group.getMembers().isEmpty()) {
            tooltip.add(NO_GROUP_MEMBERS.getVisualOrderText());
        } else {
            tooltip.add(GROUP_MEMBERS.getVisualOrderText());
            int maxMembers = 10;
            for (int i = 0; i < this.group.getMembers().size(); ++i) {
                if (i >= maxMembers) {
                    tooltip.add(Component.translatable((String)"message.voicechat.more_members", (Object[])new Object[]{this.group.getMembers().size() - maxMembers}).withStyle(ChatFormatting.GRAY).getVisualOrderText());
                    break;
                }
                PlayerState state = this.group.getMembers().get(i);
                tooltip.add(Component.literal((String)("  " + state.getName())).withStyle(ChatFormatting.GRAY).getVisualOrderText());
            }
        }
        this.parent.postRender(() -> guiGraphics.setTooltipForNextFrame(this.minecraft.font, tooltip, mouseX, mouseY));
    }

    public Group getGroup() {
        return this.group;
    }

    public static class Group {
        private final ClientGroup group;
        private final List<PlayerState> members;

        public Group(ClientGroup group) {
            this.group = group;
            this.members = new ArrayList<PlayerState>();
        }

        public ClientGroup getGroup() {
            return this.group;
        }

        public List<PlayerState> getMembers() {
            return this.members;
        }
    }
}

