/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumeEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class GroupEntry
extends ListScreenEntryBase<GroupEntry> {
    protected static final ResourceLocation TALK_OUTLINE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/talk_outline.png");
    protected static final ResourceLocation SPEAKER_OFF = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker_small_off.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = ARGB.color((int)255, (int)74, (int)74, (int)74);
    protected static final int PLAYER_NAME_COLOR = ARGB.color((int)255, (int)255, (int)255, (int)255);
    protected final ListScreenBase parent;
    protected final Minecraft minecraft;
    protected PlayerState state;
    protected final AdjustVolumeSlider volumeSlider;

    public GroupEntry(ListScreenBase parent, PlayerState state) {
        this.parent = parent;
        this.minecraft = Minecraft.getInstance();
        this.state = state;
        this.volumeSlider = new AdjustVolumeSlider(0, 0, 100, 20, new PlayerVolumeEntry.PlayerVolumeConfigEntry(state.getUuid()));
        this.children.add(this.volumeSlider);
    }

    public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        ClientVoicechat client;
        guiGraphics.fill(left, top, left + width, top + height, BG_FILL);
        guiGraphics.pose().pushMatrix();
        int outlineSize = height - 8;
        guiGraphics.pose().translate((float)(left + 4), (float)(top + 4));
        float scale = (float)outlineSize / 10.0f;
        guiGraphics.pose().scale(scale, scale);
        if (!this.state.isDisabled() && (client = ClientManager.getClient()) != null && client.getTalkCache().isTalking(this.state.getUuid())) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TALK_OUTLINE, 0, 0, 0.0f, 0.0f, 10, 10, 16, 16);
        }
        PlayerSkin skin = GameProfileUtils.getSkin(this.state.getUuid());
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skin.texture(), 1, 1, 8.0f, 8.0f, 8, 8, 64, 64);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skin.texture(), 1, 1, 40.0f, 8.0f, 8, 8, 64, 64);
        if (this.state.isDisabled()) {
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate(1.0f, 1.0f);
            guiGraphics.pose().scale(0.5f, 0.5f);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, SPEAKER_OFF, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.pose().popMatrix();
        }
        guiGraphics.pose().popMatrix();
        MutableComponent name = Component.literal((String)this.state.getName());
        Font font = this.minecraft.font;
        int n = top + height / 2;
        Objects.requireNonNull(this.minecraft.font);
        guiGraphics.drawString(font, (Component)name, left + 4 + outlineSize + 4, n - 9 / 2, PLAYER_NAME_COLOR, false);
        if (hovered && !ClientManager.getPlayerStateManager().getOwnID().equals(this.state.getUuid())) {
            this.volumeSlider.setWidth(Math.min(width - (4 + outlineSize + 4 + this.minecraft.font.width((FormattedText)name) + 4 + 4), 100));
            this.volumeSlider.setPosition(left + (width - this.volumeSlider.getWidth() - 4), top + (height - this.volumeSlider.getHeight()) / 2);
            this.volumeSlider.render(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public PlayerState getState() {
        return this.state;
    }

    public void setState(PlayerState state) {
        this.state = state;
    }
}

