/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.RecordingTooltipSupplier;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class VoiceChatScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/gui/gui_voicechat.png");
    private static final ResourceLocation MICROPHONE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/microphone_button.png");
    private static final ResourceLocation HIDE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/hide_button.png");
    private static final ResourceLocation VOLUMES = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/adjust_volumes.png");
    private static final ResourceLocation SPEAKER = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/speaker_button.png");
    private static final ResourceLocation RECORD = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/record_button.png");
    private static final Component TITLE = Component.translatable((String)"gui.voicechat.voice_chat.title");
    private static final Component SETTINGS = Component.translatable((String)"message.voicechat.settings");
    private static final Component GROUP = Component.translatable((String)"message.voicechat.group");
    public static final Component ADJUST_PLAYER_VOLUMES = Component.translatable((String)"message.voicechat.adjust_volumes");
    private ToggleImageButton mute;
    private ToggleImageButton disable;
    private VoiceChatScreenBase.HoverArea recordingHoverArea;
    private ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();

    public VoiceChatScreen() {
        super(TITLE, 195, 76);
    }

    @Override
    protected void init() {
        super.init();
        ClientVoicechat client = ClientManager.getClient();
        this.mute = new ToggleImageButton(this.guiLeft + 6, this.guiTop + this.ySize - 6 - 20, MICROPHONE, this.stateManager::isMuted, button -> this.stateManager.setMuted(!this.stateManager.isMuted()), new MuteTooltipSupplier(this, this.stateManager));
        this.addRenderableWidget((GuiEventListener)this.mute);
        this.disable = new ToggleImageButton(this.guiLeft + 6 + 20 + 2, this.guiTop + this.ySize - 6 - 20, SPEAKER, this.stateManager::isDisabled, button -> this.stateManager.setDisabled(!this.stateManager.isDisabled()), new DisableTooltipSupplier(this, this.stateManager));
        this.addRenderableWidget((GuiEventListener)this.disable);
        ImageButton volumes = new ImageButton(this.guiLeft + 6 + 20 + 2 + 20 + 2, this.guiTop + this.ySize - 6 - 20, VOLUMES, button -> this.minecraft.setScreen((Screen)new AdjustVolumesScreen()));
        volumes.setTooltip(Tooltip.create((Component)ADJUST_PLAYER_VOLUMES));
        this.addRenderableWidget((GuiEventListener)volumes);
        if (client != null && VoicechatClient.CLIENT_CONFIG.useNatives.get().booleanValue() && (client.getRecorder() != null || client.getConnection() != null && client.getConnection().getData().allowRecording())) {
            ToggleImageButton record = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20 - 2 - 20, this.guiTop + this.ySize - 6 - 20, RECORD, () -> ClientManager.getClient() != null && ClientManager.getClient().getRecorder() != null, button -> this.toggleRecording(), new RecordingTooltipSupplier(this));
            this.addRenderableWidget((GuiEventListener)record);
        }
        ToggleImageButton hide = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20, this.guiTop + this.ySize - 6 - 20, HIDE, VoicechatClient.CLIENT_CONFIG.hideIcons::get, button -> VoicechatClient.CLIENT_CONFIG.hideIcons.set(VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false).save(), new HideTooltipSupplier(this));
        this.addRenderableWidget((GuiEventListener)hide);
        Button settings = Button.builder((Component)SETTINGS, button -> this.minecraft.setScreen((Screen)new VoiceChatSettingsScreen())).bounds(this.guiLeft + 6, this.guiTop + 6 + 15, 75, 20).build();
        this.addRenderableWidget((GuiEventListener)settings);
        Button group = Button.builder((Component)GROUP, button -> {
            ClientGroup g = this.stateManager.getGroup();
            if (g != null) {
                this.minecraft.setScreen((Screen)new GroupScreen(g));
            } else {
                this.minecraft.setScreen((Screen)new JoinGroupScreen());
            }
        }).bounds(this.guiLeft + this.xSize - 6 - 75 + 1, this.guiTop + 6 + 15, 75, 20).build();
        this.addRenderableWidget((GuiEventListener)group);
        group.active = client != null && client.getConnection() != null && client.getConnection().getData().groupsEnabled();
        this.recordingHoverArea = new VoiceChatScreenBase.HoverArea(72, this.ySize - 6 - 20, this.xSize - 122, 20);
        this.checkButtons();
    }

    public void tick() {
        super.tick();
        this.checkButtons();
    }

    private void checkButtons() {
        this.mute.active = MuteTooltipSupplier.canMuteMic();
        this.disable.active = this.stateManager.canEnable();
    }

    private void toggleRecording() {
        ClientVoicechat c = ClientManager.getClient();
        if (c == null) {
            return;
        }
        c.toggleRecording();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_VOICE_CHAT).getValue()) {
            this.minecraft.setScreen(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, 256, 256);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int titleWidth = this.font.width((FormattedText)TITLE);
        guiGraphics.drawString(this.font, TITLE, this.guiLeft + (this.xSize - titleWidth) / 2, this.guiTop + 7, -12566464, false);
        ClientVoicechat client = ClientManager.getClient();
        if (client != null && client.getRecorder() != null) {
            AudioRecorder recorder = client.getRecorder();
            MutableComponent time = Component.literal((String)recorder.getDuration());
            MutableComponent mutableComponent = time.withStyle(ChatFormatting.DARK_RED);
            int n = this.guiLeft + this.recordingHoverArea.getPosX() + this.recordingHoverArea.getWidth() / 2 - this.font.width((FormattedText)time) / 2;
            int n2 = this.guiTop + this.recordingHoverArea.getPosY() + this.recordingHoverArea.getHeight() / 2;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, (Component)mutableComponent, n, n2 - 9 / 2, 0, false);
            if (this.recordingHoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) {
                guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"message.voicechat.storage_size", (Object[])new Object[]{recorder.getStorage()}), mouseX, mouseY);
            }
        }
    }
}

