/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.net.ClientServerNetManager;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class EnterPasswordScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/gui/gui_enter_password.png");
    private static final Component TITLE = Component.translatable((String)"gui.voicechat.enter_password.title");
    private static final Component JOIN_GROUP = Component.translatable((String)"message.voicechat.join_group");
    private static final Component ENTER_GROUP_PASSWORD = Component.translatable((String)"message.voicechat.enter_group_password");
    private static final Component PASSWORD = Component.translatable((String)"message.voicechat.password");
    private EditBox password;
    private Button joinGroup;
    private ClientGroup group;

    public EnterPasswordScreen(ClientGroup group) {
        super(TITLE, 195, 74);
        this.group = group;
    }

    @Override
    protected void init() {
        super.init();
        this.hoverAreas.clear();
        this.clearWidgets();
        Objects.requireNonNull(this.font);
        this.password = new EditBox(this.font, this.guiLeft + 7, this.guiTop + 7 + (9 + 5) * 2 - 5, this.xSize - 14, 14, (Component)Component.empty());
        this.password.setMaxLength(32);
        this.password.setFilter(s -> s.isEmpty() || Voicechat.GROUP_REGEX.matcher((CharSequence)s).matches());
        this.addRenderableWidget((GuiEventListener)this.password);
        this.joinGroup = Button.builder((Component)JOIN_GROUP, button -> this.joinGroup()).bounds(this.guiLeft + 7, this.guiTop + this.ySize - 20 - 7, this.xSize - 14, 20).build();
        this.addRenderableWidget((GuiEventListener)this.joinGroup);
    }

    private void joinGroup() {
        if (!this.password.getValue().isEmpty()) {
            ClientServerNetManager.sendToServer(new JoinGroupPacket(this.group.getId(), this.password.getValue()));
        }
    }

    public void tick() {
        super.tick();
        this.joinGroup.active = !this.password.getValue().isEmpty();
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, 256, 256);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.drawString(this.font, ENTER_GROUP_PASSWORD, this.guiLeft + this.xSize / 2 - this.font.width((FormattedText)ENTER_GROUP_PASSWORD) / 2, this.guiTop + 7, -12566464, false);
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, PASSWORD, this.guiLeft + 8, this.guiTop + 7 + 9 + 5, -12566464, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.setScreen(null);
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257) {
            this.joinGroup();
            return true;
        }
        return false;
    }

    public void resize(Minecraft client, int width, int height) {
        String passwordText = this.password.getValue();
        this.init(client, width, height);
        this.password.setValue(passwordText);
    }
}

