/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.net.ClientServerNetManager;
import de.maxhenkel.voicechat.net.CreateGroupPacket;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CreateGroupScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"textures/gui/gui_create_group.png");
    private static final Component TITLE = Component.translatable((String)"gui.voicechat.create_group.title");
    private static final Component CREATE = Component.translatable((String)"message.voicechat.create");
    private static final Component CREATE_GROUP = Component.translatable((String)"message.voicechat.create_group");
    private static final Component GROUP_NAME = Component.translatable((String)"message.voicechat.group_name");
    private static final Component OPTIONAL_PASSWORD = Component.translatable((String)"message.voicechat.optional_password");
    private static final Component GROUP_TYPE = Component.translatable((String)"message.voicechat.group_type");
    private EditBox groupName;
    private EditBox password;
    private GroupType groupType = GroupType.NORMAL;
    private Button createGroup;

    public CreateGroupScreen() {
        super(TITLE, 195, 124);
    }

    @Override
    protected void init() {
        super.init();
        this.hoverAreas.clear();
        this.clearWidgets();
        this.groupName = new EditBox(this.font, this.guiLeft + 7, this.guiTop + 30, this.xSize - 14, 14, (Component)Component.empty());
        this.groupName.setMaxLength(24);
        this.groupName.setFilter(s -> s.isEmpty() || Voicechat.GROUP_REGEX.matcher((CharSequence)s).matches());
        this.addRenderableWidget((GuiEventListener)this.groupName);
        this.password = new EditBox(this.font, this.guiLeft + 7, this.guiTop + 56, this.xSize - 14, 14, (Component)Component.empty());
        this.password.setMaxLength(32);
        this.password.setFilter(s -> s.isEmpty() || Voicechat.GROUP_REGEX.matcher((CharSequence)s).matches());
        this.addRenderableWidget((GuiEventListener)this.password);
        this.addRenderableWidget((GuiEventListener)CycleButton.builder(GroupType::getTranslation).withValues((Object[])GroupType.values()).withInitialValue((Object)GroupType.NORMAL).withTooltip(object -> Tooltip.create((Component)object.getDescription())).create(this.guiLeft + 6, this.guiTop + 74, this.xSize - 12, 20, GROUP_TYPE, (button, type) -> {
            this.groupType = type;
        }));
        this.createGroup = Button.builder((Component)CREATE, button -> this.createGroup()).bounds(this.guiLeft + 6, this.guiTop + this.ySize - 27, this.xSize - 12, 20).build();
        this.addRenderableWidget((GuiEventListener)this.createGroup);
    }

    private void createGroup() {
        if (!this.groupName.getValue().isEmpty()) {
            ClientServerNetManager.sendToServer(new CreateGroupPacket(this.groupName.getValue(), this.password.getValue().isEmpty() ? null : this.password.getValue(), this.groupType.getType()));
        }
    }

    public void tick() {
        super.tick();
        this.createGroup.active = !this.groupName.getValue().isEmpty();
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, 256, 256);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.drawString(this.font, CREATE_GROUP, this.guiLeft + this.xSize / 2 - this.font.width((FormattedText)CREATE_GROUP) / 2, this.guiTop + 7, -12566464, false);
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, GROUP_NAME, this.guiLeft + 8, this.guiTop + 7 + 9 + 5, -12566464, false);
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, OPTIONAL_PASSWORD, this.guiLeft + 8, this.guiTop + 7 + (9 + 5) * 2 + 10 + 2, -12566464, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.setScreen(null);
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257) {
            this.createGroup();
            return true;
        }
        return false;
    }

    public void resize(Minecraft client, int width, int height) {
        String groupNameText = this.groupName.getValue();
        String passwordText = this.password.getValue();
        this.init(client, width, height);
        this.groupName.setValue(groupNameText);
        this.password.setValue(passwordText);
    }
}

