/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldsave.mixin;

import com.fastasyncworldsave.FastAsyncWorldSave;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.PlayerDataStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PlayerDataStorage.class})
public class PlayerDatStorageMixin {
    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NbtIo;writeCompressed(Lnet/minecraft/nbt/CompoundTag;Ljava/nio/file/Path;)V"))
    private void writeAsync(CompoundTag compoundTag, Path path, Player player) {
        FastAsyncWorldSave.threadPool.submit(() -> {
            try {
                NbtIo.writeCompressed((CompoundTag)compoundTag, (Path)path);
            }
            catch (IOException e) {
                FastAsyncWorldSave.LOGGER.warn("Failed to save player data for {}", (Object)player.getName().getString());
            }
        });
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/Util;safeReplaceFile(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V"))
    private void writeAsync(Path path3, Path path2, Path path4, Player player) {
        FastAsyncWorldSave.threadPool.submit(() -> {
            try {
                Util.safeReplaceFile((Path)path3, (Path)path2, (Path)path4);
            }
            catch (Exception e) {
                FastAsyncWorldSave.LOGGER.warn("Failed to save player data for {}", (Object)player.getName().getString());
            }
        });
    }
}

