/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageTierUpgradeItem;

public class StorageHolderTierUpgradeHandler {
    public static final Map<StorageTierUpgradeItem.TierUpgrade, Map<Item, StorageHolderUpgradeDefinition>> STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS = new HashMap<StorageTierUpgradeItem.TierUpgrade, Map<Item, StorageHolderUpgradeDefinition>>();

    public static InteractionResult upgrade(Player player, StorageHolderBase storageHolder, ItemStack itemInHand, StorageTierUpgradeItem tierUpgradeItem) {
        Map<Item, StorageHolderUpgradeDefinition> tierDefinitions = STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get((Object)tierUpgradeItem.getTier());
        if (tierDefinitions == null) {
            SophisticatedStorage.LOGGER.warn("No tier upgrade definitions found for {}", (Object)tierUpgradeItem.getTier());
            return InteractionResult.PASS;
        }
        ItemStack storageStack = storageHolder.getSyncedStorageStack();
        if (!storageHolder.isOpen() && !storageHolder.isPacked()) {
            boolean cannotBeUpgradedWithThisUpgradeItem;
            StorageHolderUpgradeDefinition upgradeDefinition = tierDefinitions.get(storageStack.getItem());
            boolean bl = cannotBeUpgradedWithThisUpgradeItem = upgradeDefinition == null;
            if (cannotBeUpgradedWithThisUpgradeItem) {
                return InteractionResult.PASS;
            }
            int countRequired = upgradeDefinition.getCountRequired(storageStack);
            if (countRequired > itemInHand.getCount()) {
                player.displayClientMessage((Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translGui("status.too_low_tier_upgrade_count"), (Object[])new Object[]{countRequired, itemInHand.getHoverName()}), true);
                return InteractionResult.FAIL;
            }
            if (!player.level().isClientSide()) {
                upgradeDefinition.upgradeStorageHolder(storageHolder, storageStack);
                if (!player.isCreative()) {
                    itemInHand.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static {
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_COPPER, Map.of((Item)ModBlocks.BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.COPPER_BARREL_ITEM.get()), (Item)ModBlocks.CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.COPPER_CHEST_ITEM.get()), (Item)ModBlocks.SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.COPPER_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_IRON, Map.of((Item)ModBlocks.BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.IRON_BARREL_ITEM.get()), (Item)ModBlocks.CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.IRON_CHEST_ITEM.get()), (Item)ModBlocks.SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.IRON_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_GOLD, Map.of((Item)ModBlocks.BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.GOLD_BARREL_ITEM.get()), (Item)ModBlocks.CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.GOLD_CHEST_ITEM.get()), (Item)ModBlocks.SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.GOLD_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_DIAMOND, Map.of((Item)ModBlocks.BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_BARREL_ITEM.get()), (Item)ModBlocks.CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_CHEST_ITEM.get()), (Item)ModBlocks.SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_NETHERITE, Map.of((Item)ModBlocks.BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_BARREL_ITEM.get()), (Item)ModBlocks.CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_CHEST_ITEM.get()), (Item)ModBlocks.SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_IRON, Map.of((Item)ModBlocks.COPPER_BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.IRON_BARREL_ITEM.get()), (Item)ModBlocks.COPPER_CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.IRON_CHEST_ITEM.get()), (Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.IRON_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_GOLD, Map.of((Item)ModBlocks.COPPER_BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.GOLD_BARREL_ITEM.get()), (Item)ModBlocks.COPPER_CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.GOLD_CHEST_ITEM.get()), (Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.GOLD_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_DIAMOND, Map.of((Item)ModBlocks.COPPER_BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_BARREL_ITEM.get()), (Item)ModBlocks.COPPER_CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_CHEST_ITEM.get()), (Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_NETHERITE, Map.of((Item)ModBlocks.COPPER_BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_BARREL_ITEM.get()), (Item)ModBlocks.COPPER_CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_CHEST_ITEM.get()), (Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.IRON_TO_GOLD, Map.of((Item)ModBlocks.IRON_BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.GOLD_BARREL_ITEM.get()), (Item)ModBlocks.IRON_CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.GOLD_CHEST_ITEM.get()), (Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.GOLD_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.IRON_TO_DIAMOND, Map.of((Item)ModBlocks.IRON_BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_BARREL_ITEM.get()), (Item)ModBlocks.IRON_CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_CHEST_ITEM.get()), (Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.IRON_TO_NETHERITE, Map.of((Item)ModBlocks.IRON_BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_BARREL_ITEM.get()), (Item)ModBlocks.IRON_CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_CHEST_ITEM.get()), (Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.GOLD_TO_DIAMOND, Map.of((Item)ModBlocks.GOLD_BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_BARREL_ITEM.get()), (Item)ModBlocks.GOLD_CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_CHEST_ITEM.get()), (Item)ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.GOLD_TO_NETHERITE, Map.of((Item)ModBlocks.GOLD_BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_BARREL_ITEM.get()), (Item)ModBlocks.GOLD_CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_CHEST_ITEM.get()), (Item)ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get())));
        STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.DIAMOND_TO_NETHERITE, Map.of((Item)ModBlocks.DIAMOND_BARREL_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_BARREL_ITEM.get()), (Item)ModBlocks.DIAMOND_CHEST_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_CHEST_ITEM.get()), (Item)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get()), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get()), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get()), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get()), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get(), new StorageHolderUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get())));
    }

    public static class StorageHolderUpgradeDefinition {
        private final BlockItem upgradedItem;

        private StorageHolderUpgradeDefinition(BlockItem upgradedItem) {
            this.upgradedItem = upgradedItem;
        }

        public void upgradeStorageHolder(StorageHolderBase storageHolder, ItemStack storageItem) {
            Block block = this.upgradedItem.getBlock();
            if (block instanceof StorageBlockBase) {
                StorageBlockBase storageBlock = (StorageBlockBase)block;
                if (this.isDoubleChest(storageItem)) {
                    this.upgradeIndividualStorageHolder(storageHolder.getMainStorageHolder(), storageItem, storageBlock.getNumberOfInventorySlots() * 2, storageBlock.getNumberOfUpgradeSlots());
                    storageHolder.getAuxiliaryStorageHolder().ifPresent(auxiliaryStorageHolder -> this.upgradeIndividualStorageHolder((StorageHolderBase)auxiliaryStorageHolder, storageItem, storageBlock.getNumberOfInventorySlots() * 2, storageBlock.getNumberOfUpgradeSlots()));
                } else {
                    this.upgradeIndividualStorageHolder(storageHolder, storageItem, storageBlock.getNumberOfInventorySlots(), storageBlock.getNumberOfUpgradeSlots());
                }
            }
        }

        private void upgradeIndividualStorageHolder(StorageHolderBase storageHolder, ItemStack storageItem, int newNumberOfInventorySlots, int newNumberOfUpgradeSlots) {
            ItemStack newStorageItem = new ItemStack((ItemLike)this.upgradedItem);
            newStorageItem.applyComponents(storageItem.getComponentsPatch());
            storageHolder.setStorageItem(newStorageItem);
            IStorageWrapper storageWrapper = storageHolder.getStorageWrapper();
            if (storageWrapper instanceof MovingStorageWrapper) {
                MovingStorageWrapper movingStorageWrapper = (MovingStorageWrapper)storageWrapper;
                int additionalInventorySlots = newNumberOfInventorySlots - storageWrapper.getInventoryHandler().getSlots();
                int additionalUpgradeSlots = newNumberOfUpgradeSlots - storageWrapper.getUpgradeHandler().getSlots();
                movingStorageWrapper.changeSize(additionalInventorySlots, additionalUpgradeSlots);
            }
        }

        public int getCountRequired(ItemStack storageStack) {
            if (this.isDoubleChest(storageStack)) {
                return 2;
            }
            return 1;
        }

        private boolean isDoubleChest(ItemStack storageStack) {
            return storageStack.getItem() instanceof ChestBlockItem && ChestBlockItem.isDoubleChest(storageStack);
        }
    }
}

