/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.IRecipeDisplayGenerator;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class DyeRecipesMaker {
    private DyeRecipesMaker() {
    }

    public static void addRecipes(IRecipeDisplayGenerator<?> generator, Function<ItemStack, Optional<PropertyBasedSubtypeInterpreter>> getSubtypeInterpreter) {
        HashMap<Item, List<ItemStack>> blocks = new HashMap<Item, List<ItemStack>>();
        DyeRecipesMaker.getItemsOfClass(WoodStorageBlockItem.class).forEach(item -> blocks.put((Item)item, DyeRecipesMaker.getWoodStorageStacks(item.getBlock())));
        DyeRecipesMaker.getItemsOfClass(ShulkerBoxItem.class).forEach(item -> blocks.put((Item)item, Collections.singletonList(new ItemStack((ItemLike)item))));
        DyeRecipesMaker.addSingleColorRecipes(generator, blocks, getSubtypeInterpreter);
        DyeRecipesMaker.addMultipleColorsRecipe(generator, blocks, getSubtypeInterpreter);
    }

    private static Stream<BlockItem> getItemsOfClass(Class<? extends BlockItem> clazz) {
        return ModBlocks.ITEMS.getEntries().stream().filter(holder -> clazz.isInstance(holder.get())).map(holder -> (BlockItem)clazz.cast(((Item)holder.get()).asItem()));
    }

    private static List<ItemStack> getWoodStorageStacks(Block woodStorageBlock) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> ret.add(WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)woodStorageBlock), woodType)));
        return ret;
    }

    private static void addMultipleColorsRecipe(IRecipeDisplayGenerator<?> generator, Map<Item, List<ItemStack>> items, Function<ItemStack, Optional<PropertyBasedSubtypeInterpreter>> getSubtypeInterpreter) {
        items.forEach((block, stacks) -> {
            ItemStack result = new ItemStack((ItemLike)block);
            Item patt0$temp = result.getItem();
            if (patt0$temp instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)patt0$temp;
                tintableBlockItem.setMainColor(result, DyeColor.YELLOW.getTextureDiffuseColor());
                tintableBlockItem.setAccentColor(result, DyeColor.LIME.getTextureDiffuseColor());
            }
            generator.shaped(result).pattern("YSL").define(Character.valueOf('Y'), DyeColor.YELLOW.getTag()).define(Character.valueOf('S'), stacks).define(Character.valueOf('L'), DyeColor.LIME.getTag()).save(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorage", (String)((Optional)getSubtypeInterpreter.apply(result)).map(i -> i.getRegistrySanitizedItemString(result)).orElse("multiple_color"))));
        });
    }

    private static void addSingleColorRecipes(IRecipeDisplayGenerator<?> generator, Map<Item, List<ItemStack>> items, Function<ItemStack, Optional<PropertyBasedSubtypeInterpreter>> getSubtypeInterpreter) {
        for (DyeColor color : DyeColor.values()) {
            items.forEach((block, stacks) -> {
                ItemStack result = new ItemStack((ItemLike)block);
                Item patt0$temp = result.getItem();
                if (patt0$temp instanceof ITintableBlockItem) {
                    ITintableBlockItem tintableBlockItem = (ITintableBlockItem)patt0$temp;
                    tintableBlockItem.setMainColor(result, color.getTextureDiffuseColor());
                    tintableBlockItem.setAccentColor(result, color.getTextureDiffuseColor());
                }
                generator.shaped(result).pattern("S").pattern("C").define(Character.valueOf('C'), color.getTag()).define(Character.valueOf('S'), stacks).save(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorage", (String)((Optional)getSubtypeInterpreter.apply(result)).map(i -> i.getRegistrySanitizedItemString(result)).orElse("single_color_" + color.getSerializedName()))));
            });
        }
    }
}

