/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class LimitedBarrelRenderer
extends BarrelRenderer<LimitedBarrelBlockEntity> {
    public static final Material FILL_INDICATORS_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, SophisticatedStorage.getRL("block/fill_indicators"));
    private static final float MULTIPLE_ITEMS_FONT_SCALE = 0.010416667f;
    private static final float SINGLE_ITEM_FONT_SCALE = 0.020833334f;
    public static final Style INFINITE_COUNT_DISPLAY_STYLE = Style.EMPTY.withFont(Minecraft.UNIFORM_FONT);
    private static final Style COUNT_DISPLAY_STYLE = INFINITE_COUNT_DISPLAY_STYLE.withBold(Boolean.valueOf(true));
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new Vec3(0.0, 0.0, -0.0625));
    private final DisplayItemRenderer flatDisplayItemRenderer = new DisplayItemRenderer(0.5, Vec3.ZERO);

    @Override
    public void render(LimitedBarrelBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        StorageBlockBase storageBlock;
        BlockState blockState;
        block5: {
            block4: {
                Block block;
                blockState = blockEntity.getBlockState();
                if (blockEntity.isPacked() || !((block = blockState.getBlock()) instanceof StorageBlockBase)) break block4;
                storageBlock = (StorageBlockBase)block;
                if (blockEntity.hasDynamicRenderer() || blockEntity.shouldShowCounts() || this.holdsItemThatShowsUpgrades() || blockEntity.shouldShowUpgrades()) break block5;
            }
            return;
        }
        boolean flatTop = (Boolean)blockState.getValue((Property)BarrelBlock.FLAT_TOP);
        Direction horizontalFacing = (Direction)blockState.getValue(LimitedBarrelBlock.HORIZONTAL_FACING);
        this.renderItemCounts(blockEntity, poseStack, bufferSource, flatTop, horizontalFacing, (VerticalFacing)((Object)blockState.getValue(LimitedBarrelBlock.VERTICAL_FACING)), packedLight);
        if (blockEntity.getLevel() != null && blockEntity.shouldUseLightInFrontForFrontRender()) {
            packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().relative(storageBlock.getFacing(blockState)));
        }
        this.renderFrontFace(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, blockState, flatTop, horizontalFacing);
        this.renderHiddenTier(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderHiddenLock(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderFrontFace(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BlockState blockState, boolean flatTop, Direction horizontalFacing) {
        if (blockEntity.hasDynamicRenderer() || this.holdsItemThatShowsUpgrades() || blockEntity.shouldShowUpgrades() || blockEntity.shouldShowFillLevels() || this.holdsItemThatShowsFillLevels()) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(horizontalFacing));
            VerticalFacing verticalFacing = (VerticalFacing)((Object)blockState.getValue(LimitedBarrelBlock.VERTICAL_FACING));
            if (verticalFacing != VerticalFacing.NO) {
                poseStack.mulPose((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection()));
            }
            poseStack.translate(-0.5, -0.5, -(0.5 - (double)(flatTop ? 0.0f : 0.0625f)));
            if (blockEntity.hasDynamicRenderer()) {
                this.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop);
            }
            boolean holdsItemThatShowsUpgrades = this.holdsItemThatShowsUpgrades();
            if (blockEntity.shouldShowUpgrades() || holdsItemThatShowsUpgrades) {
                this.renderUpgrades(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop, holdsItemThatShowsUpgrades);
            }
            if (blockEntity.shouldShowFillLevels() || this.holdsItemThatShowsFillLevels()) {
                this.renderFillLevels(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
            }
            poseStack.popPose();
        }
    }

    private void renderUpgrades(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean flatTop, boolean holdsItemThatShowsUpgrades) {
        if (flatTop) {
            this.flatDisplayItemRenderer.renderUpgradeItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, holdsItemThatShowsUpgrades, this.shouldShowDisabledUpgradesDisplay(blockEntity));
        } else {
            this.displayItemRenderer.renderUpgradeItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, holdsItemThatShowsUpgrades, this.shouldShowDisabledUpgradesDisplay(blockEntity));
        }
    }

    private void renderFillLevels(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, -0.001);
        List<Float> slotFillLevels = blockEntity.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotFillRatios();
        if (slotFillLevels.isEmpty()) {
            slotFillLevels = blockEntity.getSlotFillLevels();
        }
        int slots = slotFillLevels.size();
        boolean translucentRender = !blockEntity.shouldShowFillLevels() && this.holdsToolInToggleFillLevelDisplay();
        switch (slots) {
            case 1: {
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(0).floatValue(), 0.0625f, 0.0625f, true, translucentRender);
                break;
            }
            case 2: {
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(0).floatValue(), 0.0625f, 0.5625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(1).floatValue(), 0.0625f, 0.0625f, false, translucentRender);
                break;
            }
            case 3: {
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(0).floatValue(), 0.0625f, 0.5625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(1).floatValue(), 0.875f, 0.0625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(2).floatValue(), 0.0625f, 0.0625f, false, translucentRender);
                break;
            }
            case 4: {
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(0).floatValue(), 0.875f, 0.5625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(1).floatValue(), 0.0625f, 0.5625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(2).floatValue(), 0.875f, 0.0625f, false, translucentRender);
                this.renderFillLevel(poseStack, bufferSource, packedLight, packedOverlay, slotFillLevels.get(3).floatValue(), 0.0625f, 0.0625f, false, translucentRender);
            }
        }
        poseStack.popPose();
    }

    private void renderDisplayItems(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean flatTop) {
        if (flatTop) {
            this.flatDisplayItemRenderer.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !blockEntity.hasFullyDynamicRenderer());
        } else {
            this.displayItemRenderer.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !blockEntity.hasFullyDynamicRenderer());
        }
    }

    private void renderItemCounts(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, boolean flatTop, Direction horizontalFacing, VerticalFacing verticalFacing, int packedLight) {
        if (!blockEntity.shouldShowCounts()) {
            return;
        }
        if (blockEntity.getLevel() != null && blockEntity.shouldUseLightInFrontForFrontRender()) {
            packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().relative(verticalFacing != VerticalFacing.NO ? verticalFacing.getDirection() : horizontalFacing));
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(horizontalFacing.getOpposite()));
        if (verticalFacing != VerticalFacing.NO) {
            poseStack.mulPose((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection().getOpposite()));
        }
        poseStack.translate(0.5, -0.5, 0.5);
        RenderInfo.ItemDisplayRenderInfo itemDisplayRenderInfo = blockEntity.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo();
        List<Integer> slotCounts = itemDisplayRenderInfo.getSlotCounts();
        List infiniteSlots = itemDisplayRenderInfo.getInfiniteSlots();
        if (slotCounts.isEmpty()) {
            slotCounts = blockEntity.getSlotCounts();
        }
        float countDisplayYOffset = -(slotCounts.size() == 1 ? 0.25f : 0.11f);
        for (int displayItemIndex = 0; displayItemIndex < slotCounts.size(); ++displayItemIndex) {
            float scale;
            int count = slotCounts.get(displayItemIndex);
            if (count <= 0) continue;
            poseStack.pushPose();
            Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, slotCounts.size());
            double xTranslation = -frontOffset.x();
            boolean isInfinite = infiniteSlots.contains(displayItemIndex);
            float yTranslation = frontOffset.y() + (isInfinite ? countDisplayYOffset / 1.8f : countDisplayYOffset);
            double zTranslation = 0.001 - (flatTop ? 0.0 : 0.046875);
            poseStack.translate(xTranslation, (double)yTranslation, zTranslation);
            float f = scale = slotCounts.size() == 1 ? 0.020833334f : 0.010416667f;
            if (isInfinite) {
                scale *= 2.0f;
            }
            poseStack.scale(scale, -scale, scale);
            MutableComponent countString = isInfinite ? Component.literal((String)"\u221e").withStyle(INFINITE_COUNT_DISPLAY_STYLE) : Component.literal((String)CountAbbreviator.abbreviate((int)count, (int)(slotCounts.size() == 1 ? 6 : 5))).withStyle(COUNT_DISPLAY_STYLE);
            Font font = Minecraft.getInstance().font;
            float countDisplayXOffset = -font.getSplitter().stringWidth((FormattedText)countString) / 2.0f;
            poseStack.translate(countDisplayXOffset, 0.0f, 0.0f);
            font.drawInBatch((Component)countString, 0.0f, 0.0f, blockEntity.getSlotColor(displayItemIndex), false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void renderFillLevel(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float fillLevel, float x, float y, boolean large, boolean translucentRender) {
        VertexConsumer vertexConsumer;
        poseStack.pushPose();
        poseStack.translate(x + 0.0125f, y + 0.0125f, 0.0f);
        int barHeight = large ? 14 : 6;
        poseStack.scale(0.0375f, fillLevel * 1.0f / 16.0f / 5.0f * (float)(barHeight * 5 - 2), 1.0f);
        poseStack.pushPose();
        if (translucentRender) {
            TextureAtlasSprite sprite = FILL_INDICATORS_TEXTURE.sprite();
            vertexConsumer = sprite.wrap(bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)sprite.atlasLocation())));
        } else {
            vertexConsumer = FILL_INDICATORS_TEXTURE.buffer(bufferSource, RenderType::entityCutoutNoCull);
        }
        PoseStack.Pose pose = poseStack.last();
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        pose.normal().transform(normal);
        float minU = large ? 0.0f : 0.0234375f;
        float maxV = large ? 0.53125f : 0.21875f;
        RenderHelper.renderQuad(vertexConsumer, pose.pose(), normal, packedOverlay, packedLight, translucentRender ? 0.5f : 1.0f, minU, (1.0f - fillLevel) * maxV, minU + 0.0234375f, maxV);
        poseStack.popPose();
        poseStack.popPose();
    }
}

