/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ControllerRenderer
implements BlockEntityRenderer<ControllerBlockEntity> {
    public static final RenderPipeline NO_DEPTH_LINES_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.LINES_SNIPPET}).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).withLocation(SophisticatedStorage.getRL("pipeline/controller_lines")).build();
    private static final RenderType LINES = RenderType.create((String)"storage_lines", (int)1536, (RenderPipeline)NO_DEPTH_LINES_PIPELINE, (RenderType.CompositeState)RenderType.CompositeState.builder().setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(RenderType.VIEW_OFFSET_Z_LAYERING).setOutputState(RenderType.ITEM_ENTITY_TARGET).createCompositeState(false));

    public void render(ControllerBlockEntity controller, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.DEBUG_TOOL.get())).ifPresent(storageTool -> this.renderConnectedStorageBlocksInfo(controller, Direction.orderedByNearest((Entity)player)[0].getOpposite(), poseStack, bufferSource));
        InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).ifPresent(storageTool -> {
            if (StorageToolItem.getMode(storageTool) != StorageToolItem.Mode.LINK) {
                return;
            }
            if (StorageToolItem.getControllerLink(storageTool).map(controllerPos -> controllerPos.equals((Object)controller.getBlockPos())).orElse(false).booleanValue()) {
                this.renderControllerOutline(controller, poseStack, bufferSource);
            }
            this.renderLinkedBlocks(controller, level, poseStack, bufferSource);
            this.renderStorageBlocksOutline(controller, poseStack, bufferSource);
        });
    }

    private void renderConnectedStorageBlocksInfo(ControllerBlockEntity controller, Direction playerLookDirection, PoseStack poseStack, MultiBufferSource bufferSource) {
        Font fontRenderer = Minecraft.getInstance().font;
        double zScale = 0.001;
        float scale = 0.015f;
        int storageOrder = 1;
        for (BlockPos position : controller.getStoragePositions()) {
            BlockPos controllerPos = controller.getBlockPos();
            double translateX = (double)position.getX() + 0.5 - (double)controllerPos.getX() + 0.501 * (double)playerLookDirection.getUnitVec3i().getX();
            double translateY = (double)position.getY() + 0.5 - (double)controllerPos.getY() + 0.501 * (double)playerLookDirection.getUnitVec3i().getY();
            double translateZ = (double)position.getZ() + 0.5 - (double)controllerPos.getZ() + 0.501 * (double)playerLookDirection.getUnitVec3i().getZ();
            poseStack.pushPose();
            poseStack.translate(translateX, translateY, translateZ);
            Quaternionf rotation = playerLookDirection.getRotation();
            rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose((Quaternionfc)rotation);
            poseStack.translate(-0.45f, 0.45f, 0.0f);
            poseStack.scale(scale, -scale, (float)zScale);
            fontRenderer.drawInBatch("Order: " + storageOrder, 0.0f, 0.0f, DyeColor.WHITE.getTextColor(), false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            poseStack.translate(0.0f, 10.0f, 0.0f);
            fontRenderer.drawInBatch("Slots: " + controller.getSlots(storageOrder - 1), 0.0f, 0.0f, DyeColor.WHITE.getTextColor(), false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            poseStack.popPose();
            ++storageOrder;
        }
    }

    private void renderLinkedBlocks(ControllerBlockEntity controller, ClientLevel level, PoseStack poseStack, MultiBufferSource bufferSource) {
        controller.getLinkedBlocks().forEach(pos -> {
            BlockState state = level.getBlockState(pos);
            VoxelShape shape = state.getShape((BlockGetter)level, pos, CollisionContext.empty());
            this.renderLineBetweenBlocks(controller.getBlockPos(), (BlockPos)pos, shape, poseStack, bufferSource, DyeColor.LIME.getTextColor());
        });
        BlockHighlightRenderHelper.renderThickEdges((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)DyeColor.LIME.getTextColor(), controller.getLinkedBlockEdges(), (BlockPos)controller.getBlockPos());
    }

    private void renderStorageBlocksOutline(ControllerBlockEntity controller, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockHighlightRenderHelper.renderThickEdges((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)6931771, controller.getStorageBlockEdges(), (BlockPos)controller.getBlockPos());
    }

    private void renderLineBetweenBlocks(BlockPos initialPos, BlockPos pos, VoxelShape shape, PoseStack poseStack, MultiBufferSource bufferSource, int color) {
        if (shape.isEmpty()) {
            return;
        }
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Vec3 center = shape.bounds().getCenter();
        VertexConsumer buffer = bufferSource.getBuffer(LINES);
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix4f = pose.pose();
        float normalX = (float)((double)(pos.getX() - initialPos.getX()) + (0.5 - center.x()));
        float normalY = (float)((double)(pos.getY() - initialPos.getY()) + (0.5 - center.y()));
        float normalZ = (float)((double)(pos.getZ() - initialPos.getZ()) + (0.5 - center.z()));
        buffer.addVertex(matrix4f, 0.5f, 0.5f, 0.5f).setColor(red, green, blue, 255).setNormal(pose, normalX, normalY, normalZ);
        buffer.addVertex(matrix4f, (float)((double)(pos.getX() - initialPos.getX()) + center.x()), (float)((double)(pos.getY() - initialPos.getY()) + center.y()), (float)((double)(pos.getZ() - initialPos.getZ()) + center.z())).setColor(red, green, blue, 255).setNormal(pose, normalX, normalY, normalZ);
    }

    private void renderControllerOutline(ControllerBlockEntity controller, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockHighlightRenderHelper.renderThickEdges((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)3062783, controller.getControllerEdges(), (BlockPos)controller.getBlockPos());
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public AABB getRenderBoundingBox(ControllerBlockEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos()).inflate((double)Config.SERVER.controllerRange.getAsInt());
    }
}

