/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Transformation;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBlockStateModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DynamicBarrelBakingData;
import net.p3pp3rf1y.sophisticatedstorage.client.render.SimpleCompositeUnbakedModel;
import org.joml.Quaternionf;

public abstract class BarrelUnbakedModelBase
implements UnbakedModel {
    private static final Map<Integer, QuadCollection> BAKED_PART_MODELS = new ConcurrentHashMap<Integer, QuadCollection>();
    private static final String REFERENCE_PREFIX = "reference/";
    private final Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodModelPartDefinitions;
    @Nullable
    private final ResourceLocation parentLocation;
    private final Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> dynamicPartModels;
    private final Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions;

    public static void invalidateCache() {
        BAKED_PART_MODELS.clear();
    }

    protected BarrelUnbakedModelBase(@Nullable ResourceLocation parentLocation, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodModelPartDefinitions, Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> dynamicPartModels, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions) {
        this.parentLocation = parentLocation;
        this.woodModelPartDefinitions = woodModelPartDefinitions;
        this.dynamicPartModels = dynamicPartModels;
        this.woodPartitionedModelPartDefinitions = woodPartitionedModelPartDefinitions;
    }

    @Nullable
    public ResourceLocation parent() {
        return this.parentLocation;
    }

    private void copyAndResolveTextures(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> partitionedWoodOverrides) {
        BarrelUnbakedModelBase.copyTextures(woodOverrides, partitionedWoodOverrides);
        BarrelUnbakedModelBase.resolveTextureReferences(partitionedWoodOverrides);
    }

    private static void resolveTextureReferences(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> partitionedWoodOverrides) {
        partitionedWoodOverrides.values().forEach(partDefinitions -> partDefinitions.values().forEach(definition -> {
            HashMap replacements = new HashMap();
            definition.textures.forEach((key, value) -> {
                String path = value.texture().getPath();
                if (value.texture().getNamespace().equals("minecraft") && path.startsWith(REFERENCE_PREFIX)) {
                    String referredTextureName = path.substring(REFERENCE_PREFIX.length());
                    if (definition.textures().containsKey(referredTextureName)) {
                        replacements.put(key, definition.textures.get(referredTextureName));
                    }
                }
            });
            definition.textures.putAll(replacements);
        }));
    }

    private static void copyTextures(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> partitionedWoodOverrides) {
        woodOverrides.forEach((woodType, partDefinitions) -> {
            if (partitionedWoodOverrides.containsKey(woodType)) {
                Map partitionedWoodOverride = (Map)partitionedWoodOverrides.get(woodType);
                partDefinitions.forEach((part, definition) -> {
                    if (partitionedWoodOverride.containsKey(part)) {
                        ((BarrelModelPartDefinition)partitionedWoodOverride.get((Object)((Object)((Object)((Object)part))))).textures.putAll(definition.textures);
                    } else {
                        partitionedWoodOverride.put(part, new BarrelModelPartDefinition(null, new ConcurrentHashMap<String, Material>(definition.textures())));
                    }
                });
            }
        });
    }

    private Map<String, Map<BarrelModelPart, ResolvedModel>> createUnbakedWoodModelParts(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> definitions, ModelBaker baker, ModelDebugName debugName) {
        ImmutableMap.Builder woodModelsBuilder = ImmutableMap.builder();
        definitions.forEach((woodName, woodDefinitions) -> {
            ImmutableMap.Builder modelsBuilder = ImmutableMap.builder();
            woodDefinitions.forEach((barrelPart, barrelPartDefinition) -> barrelPartDefinition.modelLocation().ifPresent(partModelLocation -> {
                TextureSlots.Data.Builder textureBuilder = new TextureSlots.Data.Builder();
                barrelPartDefinition.textures().forEach((arg_0, arg_1) -> ((TextureSlots.Data.Builder)textureBuilder).addTexture(arg_0, arg_1));
                modelsBuilder.put((Object)barrelPart, (Object)baker.resolveInlineModel((UnbakedModel)new BlockModel(null, null, Boolean.valueOf(true), ItemTransforms.NO_TRANSFORMS, textureBuilder.build(), partModelLocation), debugName));
            }));
            woodModelsBuilder.put(woodName, (Object)modelsBuilder.build());
        });
        return woodModelsBuilder.build();
    }

    private Map<String, Map<BarrelModelPart, QuadCollection>> bakeWoodModelParts(ModelBaker baker, ModelState modelState, Map<String, Map<BarrelModelPart, ResolvedModel>> woodModels) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        woodModels.forEach((woodName, partModels) -> {
            ImmutableMap.Builder partBuilder = ImmutableMap.builder();
            partModels.forEach((part, model) -> {
                int hash = this.getBakedModelHash((ResolvedModel)model, modelState, (BarrelModelPart)((Object)((Object)part)));
                QuadCollection quads = BAKED_PART_MODELS.computeIfAbsent(hash, h -> model.getTopGeometry().bake(this.findTopTextureSlots((ResolvedModel)model, baker), baker, modelState, (ModelDebugName)model, ContextMap.EMPTY));
                if (!quads.getAll().isEmpty()) {
                    partBuilder.put((Object)part, (Object)quads);
                }
            });
            builder.put(woodName, (Object)partBuilder.build());
        });
        return builder.build();
    }

    private TextureSlots findTopTextureSlots(ResolvedModel model, ModelBaker baker) {
        TextureSlots.Resolver resolver = new TextureSlots.Resolver();
        for (ResolvedModel resolvedmodel = model; resolvedmodel != null; resolvedmodel = resolvedmodel.parent()) {
            resolver.addLast(resolvedmodel.wrapped().textureSlots());
            UnbakedGeometry unbakedGeometry = resolvedmodel.wrapped().geometry();
            if (!(unbakedGeometry instanceof SimpleCompositeUnbakedModel.SimpleCompositeUnbakedGeometry)) continue;
            SimpleCompositeUnbakedModel.SimpleCompositeUnbakedGeometry simpleCompositeGeometry = (SimpleCompositeUnbakedModel.SimpleCompositeUnbakedGeometry)unbakedGeometry;
            simpleCompositeGeometry.children().forEach((key, childModel) -> {
                ResolvedModel childResolvedModel = (ResolvedModel)childModel.map(arg_0 -> ((ModelBaker)baker).getModel(arg_0), inline -> baker.resolveInlineModel(inline, () -> model.debugName() + "_" + key));
                resolver.addLast(childResolvedModel.wrapped().textureSlots());
                for (childResolvedModel = childResolvedModel.parent(); childResolvedModel != null; childResolvedModel = childResolvedModel.parent()) {
                    resolver.addLast(childResolvedModel.wrapped().textureSlots());
                }
            });
        }
        return resolver.resolve((ModelDebugName)model);
    }

    private Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> getDynamicBakingData(ModelState modelTransform, ModelDebugName modelDebugName, Map<DynamicBarrelBakingData.DynamicPart, ResolvedModel> resolvedDynamicPartModels) {
        HashMap<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData = new HashMap<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>>();
        this.woodModelPartDefinitions.forEach((woodName, partDefinitions) -> {
            EnumMap dynamicPartBakingData = new EnumMap(DynamicBarrelBakingData.DynamicPart.class);
            this.dynamicPartModels.forEach((dynamicPart, dynamicPartModel) -> dynamicPartBakingData.put((DynamicBarrelBakingData.DynamicPart)((Object)((Object)dynamicPart)), new DynamicBarrelBakingData(((ResolvedModel)resolvedDynamicPartModels.get(dynamicPart)).wrapped(), ((BarrelModelPartDefinition)partDefinitions.get((Object)BarrelModelPart.BASE)).textures(), modelTransform, modelDebugName)));
            woodDynamicBakingData.put((String)woodName, dynamicPartBakingData);
        });
        return woodDynamicBakingData;
    }

    private int getBakedModelHash(ResolvedModel model, ModelState modelTransform, BarrelModelPart part) {
        int hash = part.hashCode();
        hash = 31 * hash + this.getDepHash(model);
        UnbakedModel unbakedModel = model.wrapped();
        if (unbakedModel instanceof BlockModel) {
            BlockModel blockModel = (BlockModel)unbakedModel;
            for (TextureSlots.SlotContents material : blockModel.textureSlots().values().values()) {
                hash = 31 * hash + material.hashCode();
            }
        }
        Transformation transformation = modelTransform.transformation();
        hash = 31 * hash + transformation.getMatrix().hashCode();
        hash = 31 * hash + transformation.getTranslation().hashCode();
        hash = 31 * hash + BarrelUnbakedModelBase.robustHash(transformation.getRightRotation());
        hash = 31 * hash + BarrelUnbakedModelBase.robustHash(transformation.getLeftRotation());
        hash = 31 * hash + transformation.getScale().hashCode();
        return hash;
    }

    public static int robustHash(Quaternionf q) {
        long h = 1L;
        h = 31L * h + (long)Float.floatToIntBits(q.w());
        h = 31L * h + (long)Float.floatToIntBits(q.x());
        h = 31L * h + (long)Float.floatToIntBits(q.y());
        h = 31L * h + (long)Float.floatToIntBits(q.z());
        return Long.hashCode(h);
    }

    private int getDepHash(ResolvedModel model) {
        int depHash = 0;
        while (model.wrapped() instanceof BarrelUnbakedModelBase || model.wrapped() instanceof BlockModel) {
            UnbakedModel unbakedModel = model.wrapped();
            if (unbakedModel instanceof BarrelUnbakedModelBase) {
                BarrelUnbakedModelBase barrelModel = (BarrelUnbakedModelBase)unbakedModel;
                if (barrelModel.parentLocation != null) {
                    depHash = 31 * depHash + barrelModel.parentLocation.hashCode();
                }
            } else {
                BlockModel blockModel;
                unbakedModel = model.wrapped();
                if (unbakedModel instanceof BlockModel && (blockModel = (BlockModel)unbakedModel).parent() != null) {
                    depHash = 31 * depHash + blockModel.parent().hashCode();
                }
            }
            if ((model = model.parent()) != null) continue;
            break;
        }
        return depHash;
    }

    protected abstract BarrelBlockStateModelBase instantiateBlockStateModel(ModelBaker var1, Map<String, Map<BarrelModelPart, QuadCollection>> var2, Map<String, Map<BarrelModelPart, TextureAtlasSprite>> var3, Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> var4, Map<String, Map<BarrelModelPart, QuadCollection>> var5);

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        if (this.parentLocation != null) {
            resolver.markDependency(this.parentLocation);
        }
        this.woodModelPartDefinitions.values().forEach(partDefs -> partDefs.values().forEach(def -> {
            if (def.modelLocation != null) {
                resolver.markDependency(def.modelLocation);
            }
        }));
        this.woodPartitionedModelPartDefinitions.values().forEach(partDefs -> partDefs.values().forEach(def -> {
            if (def.modelLocation != null) {
                resolver.markDependency(def.modelLocation);
            }
        }));
        this.dynamicPartModels.values().forEach(arg_0 -> ((ResolvableModel.Resolver)resolver).markDependency(arg_0));
    }

    private Map<DynamicBarrelBakingData.DynamicPart, ResolvedModel> createUnbakedDynamicPartModels(ModelBaker baker) {
        ImmutableMap.Builder dynamicPartModelsBuilder = ImmutableMap.builder();
        this.dynamicPartModels.forEach((part, modelLocation) -> dynamicPartModelsBuilder.put((Object)part, (Object)baker.getModel(modelLocation)));
        return dynamicPartModelsBuilder.build();
    }

    private void updateDynamicPartModelsFromModel(BarrelUnbakedModelBase model) {
        model.dynamicPartModels.forEach((dynamicPart, dynamicPartModel) -> {
            if (!this.dynamicPartModels.containsKey(dynamicPart)) {
                this.dynamicPartModels.put((DynamicBarrelBakingData.DynamicPart)((Object)dynamicPart), (ResourceLocation)dynamicPartModel);
            }
        });
    }

    private void updateDefinitionsFromParents(ModelBaker baker) {
        UnbakedModel unbakedModel;
        if (this.parentLocation == null) {
            return;
        }
        for (ResolvedModel resolvedModel = baker.getModel(this.parentLocation); resolvedModel != null && (unbakedModel = resolvedModel.wrapped()) instanceof BarrelUnbakedModelBase; resolvedModel = resolvedModel.parent()) {
            BarrelUnbakedModelBase barrelUnbakedModel = (BarrelUnbakedModelBase)unbakedModel;
            this.updateWoodModelPartDefinitionsFromModel(barrelUnbakedModel);
            this.updateWoodPartitionedModelPartDefinitionsFromModel(barrelUnbakedModel);
            this.updateDynamicPartModelsFromModel(barrelUnbakedModel);
        }
    }

    private void updateWoodModelPartDefinitionsFromModel(BarrelUnbakedModelBase model) {
        model.woodModelPartDefinitions.forEach((woodType, parentModelDefinitions) -> {
            if (!this.woodModelPartDefinitions.containsKey(woodType)) {
                this.woodModelPartDefinitions.put((String)woodType, parentModelDefinitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BarrelModelPartDefinition)e.getValue()).copy())));
            } else {
                parentModelDefinitions.forEach((part, definition) -> {
                    if (!this.woodModelPartDefinitions.get(woodType).containsKey(part)) {
                        this.woodModelPartDefinitions.get(woodType).put((BarrelModelPart)((Object)((Object)part)), definition.copy());
                    } else {
                        this.woodModelPartDefinitions.get(woodType).get(part).mergeMissing((BarrelModelPartDefinition)definition);
                    }
                });
            }
        });
    }

    private void updateWoodPartitionedModelPartDefinitionsFromModel(BarrelUnbakedModelBase model) {
        model.woodPartitionedModelPartDefinitions.forEach((woodType, parentModelDefinitions) -> {
            if (!this.woodPartitionedModelPartDefinitions.containsKey(woodType)) {
                this.woodPartitionedModelPartDefinitions.put((String)woodType, parentModelDefinitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BarrelModelPartDefinition)e.getValue()).copy())));
            } else {
                parentModelDefinitions.forEach((part, definition) -> {
                    if (!this.woodPartitionedModelPartDefinitions.get(woodType).containsKey(part)) {
                        this.woodPartitionedModelPartDefinitions.get(woodType).put((BarrelModelPart)((Object)((Object)part)), definition.copy());
                    } else {
                        this.woodPartitionedModelPartDefinitions.get(woodType).get(part).mergeMissing((BarrelModelPartDefinition)definition);
                    }
                });
            }
        });
    }

    public BarrelBlockStateModelBase bakeBlockStateModel(ModelBaker baker, ResolvedModel resolvedModel, ModelState modelState) {
        this.updateDefinitionsFromParents(baker);
        this.copyAndResolveTextures(this.woodModelPartDefinitions, this.woodPartitionedModelPartDefinitions);
        Map<String, Map<BarrelModelPart, ResolvedModel>> resolvedWoodModelParts = this.createUnbakedWoodModelParts(this.woodModelPartDefinitions, baker, (ModelDebugName)resolvedModel);
        Map<String, Map<BarrelModelPart, ResolvedModel>> resolvedWoodPartitionedModelParts = this.createUnbakedWoodModelParts(this.woodPartitionedModelPartDefinitions, baker, (ModelDebugName)resolvedModel);
        Map<DynamicBarrelBakingData.DynamicPart, ResolvedModel> resolvedDynamicPartModels = this.createUnbakedDynamicPartModels(baker);
        Map<String, Map<BarrelModelPart, QuadCollection>> woodModelParts = this.bakeWoodModelParts(baker, modelState, resolvedWoodModelParts);
        Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData = this.getDynamicBakingData(modelState, (ModelDebugName)resolvedModel, resolvedDynamicPartModels);
        Map<String, Map<BarrelModelPart, QuadCollection>> woodPartitionedModelParts = this.bakeWoodModelParts(baker, modelState, resolvedWoodPartitionedModelParts);
        Map<String, Map<BarrelModelPart, TextureAtlasSprite>> particleIcons = this.getParticleIcons(baker, resolvedWoodModelParts);
        return this.instantiateBlockStateModel(baker, woodModelParts, particleIcons, woodDynamicBakingData, woodPartitionedModelParts);
    }

    private Map<String, Map<BarrelModelPart, TextureAtlasSprite>> getParticleIcons(ModelBaker baker, Map<String, Map<BarrelModelPart, ResolvedModel>> resolvedWoodModelParts) {
        HashMap<String, Map<BarrelModelPart, TextureAtlasSprite>> particleIcons = new HashMap<String, Map<BarrelModelPart, TextureAtlasSprite>>();
        resolvedWoodModelParts.forEach((woodName, modelParts) -> {
            EnumMap textures = new EnumMap(BarrelModelPart.class);
            modelParts.forEach((part, model) -> {
                if (part == BarrelModelPart.BASE || part == BarrelModelPart.TINTABLE_MAIN) {
                    textures.put((BarrelModelPart)((Object)((Object)part)), model.resolveParticleSprite(model.getTopTextureSlots(), baker));
                }
            });
            particleIcons.put((String)woodName, textures);
        });
        return particleIcons;
    }

    public static final class BarrelModelPartDefinition {
        @Nullable
        private ResourceLocation modelLocation;
        private final Map<String, Material> textures;

        private BarrelModelPartDefinition(@Nullable ResourceLocation modelLocation, Map<String, Material> textures) {
            this.modelLocation = modelLocation;
            this.textures = textures;
        }

        public BarrelModelPartDefinition copy() {
            return new BarrelModelPartDefinition(this.modelLocation, new ConcurrentHashMap<String, Material>(this.textures));
        }

        public void mergeMissing(BarrelModelPartDefinition other) {
            if (other.modelLocation != null && this.modelLocation == null) {
                this.modelLocation = other.modelLocation;
            }
            other.textures.forEach((key, value) -> {
                if (!this.textures.containsKey(key)) {
                    this.textures.put((String)key, (Material)value);
                }
            });
        }

        public static BarrelModelPartDefinition deserialize(JsonObject json) {
            ResourceLocation modelLocation = null;
            if (json.has("model")) {
                modelLocation = ResourceLocation.parse((String)json.get("model").getAsString());
            }
            ConcurrentHashMap<String, Material> textures = new ConcurrentHashMap<String, Material>();
            if (json.has("textures")) {
                JsonObject texturesJson = json.getAsJsonObject("textures");
                for (Map.Entry entry : texturesJson.entrySet()) {
                    Object textureName = ((JsonElement)entry.getValue()).getAsString();
                    if (((String)textureName).startsWith("#")) {
                        textureName = BarrelUnbakedModelBase.REFERENCE_PREFIX + ((String)textureName).substring(1);
                    }
                    textures.put((String)entry.getKey(), new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.parse((String)textureName)));
                }
            }
            return new BarrelModelPartDefinition(modelLocation, textures);
        }

        public Optional<ResourceLocation> modelLocation() {
            return Optional.ofNullable(this.modelLocation);
        }

        public Map<String, Material> textures() {
            return this.textures;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            BarrelModelPartDefinition that = (BarrelModelPartDefinition)obj;
            return Objects.equals(this.modelLocation, that.modelLocation) && Objects.equals(this.textures, that.textures);
        }

        public int hashCode() {
            return Objects.hash(this.modelLocation, this.textures);
        }

        public String toString() {
            return "BarrelModelPartDefinition[modelLocation=" + String.valueOf(this.modelLocation) + ", textures=" + String.valueOf(this.textures) + "]";
        }
    }

    public record UnbakedBlockStateModel(Variant variant) implements CustomUnbakedBlockStateModel
    {
        public static final MapCodec<UnbakedBlockStateModel> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Variant.MAP_CODEC.forGetter(UnbakedBlockStateModel::variant)).apply((Applicative)instance, UnbakedBlockStateModel::new));
        public static final ResourceLocation ID = SophisticatedStorage.getRL("barrel_blockstate_model_loader");

        public BlockStateModel bake(ModelBaker modelBaker) {
            ResolvedModel resolvedModel = modelBaker.getModel(this.variant.modelLocation());
            UnbakedModel unbakedModel = resolvedModel.wrapped();
            if (unbakedModel instanceof BarrelUnbakedModelBase) {
                BarrelUnbakedModelBase model = (BarrelUnbakedModelBase)unbakedModel;
                return model.bakeBlockStateModel(modelBaker, resolvedModel, this.variant.modelState().asModelState());
            }
            throw new IllegalStateException("Expected BarrelUnbakedModelBase but got " + resolvedModel.wrapped().getClass().getName() + " for model " + String.valueOf(this.variant.modelLocation()));
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.variant.modelLocation());
        }

        public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
            return CODEC;
        }
    }

    public static abstract class Loader<T extends BarrelUnbakedModelBase>
    implements UnbakedModelLoader<T> {
        public T read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            ResourceLocation parentLocation = null;
            if (modelContents.has("parent")) {
                parentLocation = ResourceLocation.parse((String)modelContents.get("parent").getAsString());
            }
            Map<BarrelModelPart, BarrelModelPartDefinition> modelParts = Loader.readModelParts(modelContents, "model_parts");
            Map<BarrelModelPart, BarrelModelPartDefinition> partitionedModelParts = Loader.readModelParts(modelContents, "partitioned_model_parts");
            Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> dynamicPartModels = Loader.readDynamicPartModels(modelContents);
            Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides = Loader.readWoodOverrides(modelContents);
            if (parentLocation == null && modelParts.isEmpty() && woodOverrides.isEmpty() && dynamicPartModels.isEmpty()) {
                SophisticatedStorage.LOGGER.warn("None of 'parent', 'model_parts' and 'wood_overrides' present in model definition");
            }
            this.mergeModelPartDefinitionsIntoWoodOnes(modelParts, woodOverrides);
            Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions = Loader.readWoodOverrides(modelContents, Set.of(BarrelModelPart.BASE, BarrelModelPart.BASE_OPEN));
            this.mergeModelPartDefinitionsIntoWoodOnes(partitionedModelParts, woodPartitionedModelPartDefinitions);
            return this.instantiateModel(parentLocation, woodOverrides, dynamicPartModels, woodPartitionedModelPartDefinitions);
        }

        private static Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> readWoodOverrides(JsonObject modelContents) {
            return Loader.readWoodOverrides(modelContents, Collections.emptySet());
        }

        private static Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> readWoodOverrides(JsonObject modelContents, Set<BarrelModelPart> partsToIgnore) {
            HashMap<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides = new HashMap<String, Map<BarrelModelPart, BarrelModelPartDefinition>>();
            if (modelContents.has("wood_overrides")) {
                JsonObject woodOverridesJson = modelContents.getAsJsonObject("wood_overrides");
                for (Map.Entry entry : woodOverridesJson.entrySet()) {
                    JsonObject woodOverrideJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                    EnumMap woodOverride = new EnumMap(BarrelModelPart.class);
                    for (Map.Entry woodModelParts : woodOverrideJson.entrySet()) {
                        JsonObject modelPartJson = ((JsonElement)woodModelParts.getValue()).getAsJsonObject();
                        BarrelModelPart.getByNameOptional((String)woodModelParts.getKey()).ifPresent(part -> {
                            if (partsToIgnore.contains(part)) {
                                return;
                            }
                            woodOverride.put((BarrelModelPart)((Object)part), BarrelModelPartDefinition.deserialize(modelPartJson));
                        });
                    }
                    woodOverrides.put((String)entry.getKey(), woodOverride);
                }
            }
            return woodOverrides;
        }

        private static Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> readDynamicPartModels(JsonObject modelContents) {
            EnumMap<DynamicBarrelBakingData.DynamicPart, ResourceLocation> dynamicPartModels = new EnumMap<DynamicBarrelBakingData.DynamicPart, ResourceLocation>(DynamicBarrelBakingData.DynamicPart.class);
            if (modelContents.has("dynamic_part_models")) {
                JsonObject dynamicPartsJson = modelContents.getAsJsonObject("dynamic_part_models");
                for (Map.Entry entry : dynamicPartsJson.entrySet()) {
                    DynamicBarrelBakingData.DynamicPart.getByNameOptional((String)entry.getKey()).ifPresent(part -> dynamicPartModels.put((DynamicBarrelBakingData.DynamicPart)((Object)part), ResourceLocation.parse((String)((JsonElement)entry.getValue()).getAsString())));
                }
            }
            return dynamicPartModels;
        }

        private static Map<BarrelModelPart, BarrelModelPartDefinition> readModelParts(JsonObject modelContents, String memberName) {
            EnumMap<BarrelModelPart, BarrelModelPartDefinition> modelParts = new EnumMap<BarrelModelPart, BarrelModelPartDefinition>(BarrelModelPart.class);
            if (modelContents.has(memberName)) {
                JsonObject modelPartsJson = modelContents.getAsJsonObject(memberName);
                for (Map.Entry entry : modelPartsJson.entrySet()) {
                    JsonObject modelPartJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                    BarrelModelPart.getByNameOptional((String)entry.getKey()).ifPresent(part -> modelParts.put((BarrelModelPart)((Object)part), BarrelModelPartDefinition.deserialize(modelPartJson)));
                }
            }
            return modelParts;
        }

        private void mergeModelPartDefinitionsIntoWoodOnes(Map<BarrelModelPart, BarrelModelPartDefinition> modelPartDefinitions, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodModelPartdefinitions) {
            for (BarrelModelPart part : BarrelModelPart.values()) {
                if (!modelPartDefinitions.containsKey((Object)part)) continue;
                WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> {
                    String woodName = woodType.name().toLowerCase(Locale.ROOT);
                    if (woodModelPartdefinitions.containsKey(woodName)) {
                        Map definitions = (Map)woodModelPartdefinitions.get(woodName);
                        if (definitions.containsKey((Object)part)) {
                            ((BarrelModelPartDefinition)definitions.get((Object)part)).mergeMissing((BarrelModelPartDefinition)modelPartDefinitions.get((Object)part));
                        } else {
                            definitions.put(part, ((BarrelModelPartDefinition)modelPartDefinitions.get((Object)part)).copy());
                        }
                    } else {
                        woodModelPartdefinitions.put(woodName, new EnumMap<BarrelModelPart, BarrelModelPartDefinition>(Map.of(part, ((BarrelModelPartDefinition)modelPartDefinitions.get((Object)part)).copy())));
                    }
                });
            }
        }

        protected abstract T instantiateModel(@Nullable ResourceLocation var1, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> var2, Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> var3, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> var4);
    }
}

