/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.texture;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class TextureMappingTool {
    public static ResourceManager RESOURCE_MANAGER;

    public static Map<Integer, Integer> createPaletteMap(BufferedImage from, BufferedImage to) {
        if (from.getWidth() != to.getWidth() || from.getHeight() != to.getHeight()) {
            throw new IllegalArgumentException("Old palette image must be the same size as new palette image!");
        }
        HashMap<Integer, Integer> palette = new HashMap<Integer, Integer>();
        for (int x = 0; x < from.getWidth(); ++x) {
            for (int y = 0; y < from.getHeight(); ++y) {
                palette.put(from.getRGB(x, y), to.getRGB(x, y));
            }
        }
        return palette;
    }

    public static void applyPaletteMap(BufferedImage image, Map<Integer, Integer> palette, boolean ignoreMissingColors, String name) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int color = image.getRGB(x, y);
                if (color == 0) continue;
                if (!ignoreMissingColors && !palette.containsKey(color)) {
                    throw new IllegalStateException("Palette is missing color '" + String.valueOf(new Color(color)) + "' for pattern '" + name + "'");
                }
                image.setRGB(x, y, palette.getOrDefault(color, color));
            }
        }
    }

    public static List<String> getSuffixes(String name) {
        ArrayList<String> suffixes = new ArrayList<String>();
        RESOURCE_MANAGER.listPacks().filter(pack -> pack.getNamespaces(PackType.CLIENT_RESOURCES).contains("rechiseled")).forEach(pack -> pack.listResources(PackType.CLIENT_RESOURCES, "rechiseled", "textures/block", (s, stream) -> {
            if (s.getPath().startsWith("textures/block/" + name) && s.getPath().endsWith(".png")) {
                int beginOffset = s.getPath().indexOf(name) + name.length();
                int end = s.getPath().length() - ".png".length();
                suffixes.add(s.getPath().substring(beginOffset, end));
            }
        }));
        return suffixes;
    }

    public static boolean exists(ResourceLocation location) {
        return RESOURCE_MANAGER.getResource(location).isPresent();
    }

    public static Resource getResource(ResourceLocation location) throws NoSuchElementException {
        return (Resource)RESOURCE_MANAGER.getResource(location).get();
    }
}

