/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.supermartijn642.core.generator.LootTableGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class RegistrationLootTableGenerator
extends LootTableGenerator {
    private final RechiseledRegistrationImpl registration;

    public RegistrationLootTableGenerator(RechiseledRegistrationImpl registration, ResourceCache cache) {
        super(registration.getModid(), cache);
        this.registration = registration;
    }

    public void generate() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getBlockBuilders().stream().map(Pair::right).forEach(type -> {
            if (type.hasRegularVariant()) {
                this.addLootTable(type.getRegularBlock());
            }
            if (type.hasConnectingVariant()) {
                this.addLootTable(type.getConnectingBlock());
            }
        });
    }

    private void addLootTable(Block block) {
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier((Object)block);
        ResourceLocation lootTable = block.getLootTable().map(ResourceKey::location).orElse(null);
        if (lootTable != null && lootTable.getNamespace().equals(identifier.getNamespace()) && lootTable.getPath().equals("block/" + identifier.getPath())) {
            return;
        }
        this.dropSelf(block);
    }

    public String getName() {
        return "Registration Loot Table Generator: " + this.modName;
    }
}

