/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.texture.TextureMappingTool;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;

public abstract class ChiseledTextureProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final String modid;
    private final DataGenerator generator;
    private final Map<Pair<ResourceLocation, ResourceLocation>, PaletteMap> textures = new HashMap<Pair<ResourceLocation, ResourceLocation>, PaletteMap>();
    private final Set<String> outputLocations = new HashSet<String>();
    private final List<String> oakPlankSuffixes;

    public ChiseledTextureProvider(String modid, DataGenerator generator) {
        this.modid = modid;
        this.generator = generator;
        this.oakPlankSuffixes = TextureMappingTool.getSuffixes("oak_planks");
    }

    public String getName() {
        return "Chiseled Textures: " + this.modid;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.createTextures();
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        Path path = this.generator.getPackOutput().getOutputFolder();
        for (Map.Entry<Pair<ResourceLocation, ResourceLocation>, PaletteMap> entry : this.textures.entrySet()) {
            if (entry.getValue().targets.isEmpty()) continue;
            Pair<BufferedImage, JsonObject> oldPalette = this.loadTexture((ResourceLocation)entry.getKey().left());
            Pair<BufferedImage, JsonObject> newPalette = this.loadTexture((ResourceLocation)entry.getKey().right());
            Map<String, ResourceLocation> targets = entry.getValue().targets;
            boolean ignoreMissingColors = entry.getValue().ignoreMissingColors;
            Map<Integer, Integer> colorMap = TextureMappingTool.createPaletteMap((BufferedImage)oldPalette.left(), (BufferedImage)newPalette.left());
            for (Map.Entry<String, ResourceLocation> target : targets.entrySet()) {
                Pair<BufferedImage, JsonObject> targetTexture = this.loadTexture(target.getValue());
                String outputLocation = target.getKey();
                TextureMappingTool.applyPaletteMap((BufferedImage)targetTexture.left(), colorMap, ignoreMissingColors, outputLocation);
                Path texturePath = path.resolve("assets/" + this.modid + "/textures/" + outputLocation + ".png");
                tasks.add(ChiseledTextureProvider.saveTexture(cache, (BufferedImage)targetTexture.left(), texturePath));
                if (targetTexture.right() == null) continue;
                Path textureMetadataPath = path.resolve("assets/" + this.modid + "/textures/" + outputLocation + ".png.mcmeta");
                tasks.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)targetTexture.right()), (Path)textureMetadataPath));
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    private Pair<BufferedImage, JsonObject> loadTexture(ResourceLocation location) {
        BufferedImage image;
        ResourceLocation fullLocation = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("textures/" + location.getPath() + ".png"));
        if (!TextureMappingTool.exists(fullLocation)) {
            throw new IllegalStateException("Could not find existing texture: " + String.valueOf(location));
        }
        ResourceLocation metadataLocation = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("textures/" + location.getPath() + ".png.mcmeta"));
        boolean hasMetadata = TextureMappingTool.exists(metadataLocation);
        JsonObject metadata = null;
        if (hasMetadata) {
            try (BufferedReader reader = TextureMappingTool.getResource(metadataLocation).openAsReader();){
                metadata = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception when trying to load texture metadata: " + String.valueOf(location), e);
            }
        }
        try (InputStream stream = TextureMappingTool.getResource(fullLocation).open();){
            image = ImageIO.read(stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception when trying to load texture: " + String.valueOf(location), e);
        }
        if (image.getType() != 2) {
            BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D graphics = newImage.createGraphics();
            graphics.drawImage((Image)image, 0, 0, null);
            graphics.dispose();
            image = newImage;
        }
        return Pair.of((Object)image, (Object)metadata);
    }

    private static CompletableFuture<?> saveTexture(CachedOutput cache, BufferedImage image, Path path) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                HashingOutputStream hashingStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteStream);
                ImageIO.write((RenderedImage)image, "png", (OutputStream)hashingStream);
                cache.writeIfNeeded(path, byteStream.toByteArray(), hashingStream.hash());
            }
            catch (IOException iOException) {
                LOGGER.error("Couldn't save texture to {}", (Object)path, (Object)iOException);
            }
        }, (Executor)Util.backgroundExecutor());
    }

    private boolean validateTexture(ResourceLocation texture) {
        ResourceLocation fullLocation = ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)("textures/" + texture.getPath() + ".png"));
        return TextureMappingTool.exists(fullLocation);
    }

    protected abstract void createTextures();

    protected PaletteMap createPaletteMap(ResourceLocation oldPalette, ResourceLocation newPalette) {
        if (!this.validateTexture(oldPalette)) {
            throw new IllegalStateException("Could not find texture '" + String.valueOf(oldPalette) + "'!");
        }
        if (!this.validateTexture(newPalette)) {
            throw new IllegalStateException("Could not find texture '" + String.valueOf(newPalette) + "'!");
        }
        return this.textures.computeIfAbsent((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)oldPalette, (Object)newPalette), o -> new PaletteMap());
    }

    protected void createPlankTextures(ResourceLocation plankTexture, String outputLocation) {
        if (!this.validateTexture(plankTexture)) {
            throw new IllegalStateException("Could not find texture '" + String.valueOf(plankTexture) + "'!");
        }
        if (outputLocation == null || outputLocation.trim().isEmpty()) {
            throw new IllegalArgumentException("Output location must not be empty!");
        }
        if (!this.outputLocations.add(outputLocation)) {
            throw new IllegalStateException("Two or more textures have the same output location: " + outputLocation);
        }
        PaletteMap paletteMap = this.createPaletteMap(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/oak_planks"), plankTexture);
        for (String suffix : this.oakPlankSuffixes) {
            paletteMap.applyToTexture(ResourceLocation.fromNamespaceAndPath((String)"rechiseled", (String)("block/oak_planks" + suffix)), outputLocation + suffix);
        }
    }

    protected class PaletteMap {
        private final Map<String, ResourceLocation> targets = new HashMap<String, ResourceLocation>();
        private boolean ignoreMissingColors = false;

        private PaletteMap() {
        }

        public PaletteMap applyToTexture(ResourceLocation texture, String outputLocation) {
            if (!ChiseledTextureProvider.this.validateTexture(texture)) {
                throw new IllegalStateException("Could not find texture '" + String.valueOf(texture) + "'!");
            }
            if (outputLocation == null || outputLocation.trim().isEmpty()) {
                throw new IllegalArgumentException("Output location must not be empty!");
            }
            if (!ChiseledTextureProvider.this.outputLocations.add(outputLocation)) {
                throw new IllegalStateException("Two or more textures have the same output location: " + outputLocation);
            }
            this.targets.put(outputLocation.toLowerCase(Locale.ROOT).trim(), texture);
            return this;
        }

        public PaletteMap ignoreMissing() {
            this.ignoreMissingColors = true;
            return this;
        }
    }
}

