/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.world.level.block;

import fuzs.easymagic.init.ModRegistry;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.easymagic.world.level.block.entity.EnchantmentTableWithInventoryBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class EnchantmentTableWithInventoryBlock
extends EnchantingTableBlock
implements TickingEntityBlock<EnchantmentTableWithInventoryBlockEntity> {
    public EnchantmentTableWithInventoryBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return super.newBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return super.getTicker(level, state, blockEntityType);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EnchantmentTableWithInventoryBlockEntity) {
            EnchantmentTableWithInventoryBlockEntity blockEntity2 = (EnchantmentTableWithInventoryBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockEntity2);
            if (player.containerMenu instanceof ModEnchantmentMenu) {
                player.containerMenu.slotsChanged((Container)blockEntity2);
            }
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)blockEntity) : null;
    }

    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean bl) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockState, (Level)serverLevel, (BlockPos)blockPos);
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            return Math.min(container.getItem(1).getCount(), 3);
        }
        return 0;
    }

    public BlockEntityType<? extends EnchantmentTableWithInventoryBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.ENCHANTING_TABLE_BLOCK_ENTITY_TYPE.value();
    }
}

