/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.util;

import com.google.common.collect.Lists;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.util.PlayerExperienceHelper;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ClientComponentSplitter;
import fuzs.puzzleslib.api.util.v1.ComponentHelper;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.jetbrains.annotations.Nullable;

public final class EnchantmentTooltipHelper {
    public static final String KEY_ONE_ENCHANT_CATALYST = "container.enchant.lapis.one";
    public static final String KEY_MANY_ENCHANT_CATALYSTS = "container.enchant.lapis.many";
    public static final String KEY_ONE_REROLL_CATALYST = "container.enchant.reroll.one";
    public static final String KEY_MANY_REROLL_CATALYSTS = "container.enchant.reroll.many";
    public static final String KEY_ONE_ENCHANTMENT_LEVEL = "container.enchant.level.one";
    public static final String KEY_MANY_ENCHANTMENT_LEVELS = "container.enchant.level.many";
    public static final String KEY_ONE_EXPERIENCE_POINT = "container.enchant.experience.one";
    public static final String KEY_MANY_EXPERIENCE_POINTS = "container.enchant.experience.many";
    public static final String KEY_REROLL = "container.enchant.reroll";

    private EnchantmentTooltipHelper() {
    }

    public static void gatherSlotEnchantmentsTooltip(List<EnchantmentInstance> slotData, Consumer<Component> tooltipAdder, HolderLookup.Provider registries) {
        Object2IntMap enchantments = (Object2IntMap)slotData.stream().collect(Collectors.toMap(EnchantmentInstance::enchantment, EnchantmentInstance::level, (o1, o2) -> o2, Object2IntLinkedOpenHashMap::new));
        HolderSet holderSet = EnchantmentTooltipHelper.getTagOrEmpty(registries, Registries.ENCHANTMENT, EnchantmentTags.TOOLTIP_ORDER);
        for (Holder holder : holderSet) {
            int enchantmentLevel = enchantments.getInt((Object)holder);
            if (enchantmentLevel <= 0) continue;
            EnchantmentTooltipHelper.addTooltipLine((Holder<Enchantment>)holder, enchantmentLevel, tooltipAdder);
        }
        for (Object2IntMap.Entry entry : enchantments.object2IntEntrySet()) {
            if (holderSet.contains((Holder)entry.getKey())) continue;
            EnchantmentTooltipHelper.addTooltipLine((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue(), tooltipAdder);
        }
    }

    private static void addTooltipLine(Holder<Enchantment> holder, int enchantmentLevel, Consumer<Component> tooltipAdder) {
        MutableComponent enchantmentComponent = Component.empty().append(Enchantment.getFullname(holder, (int)enchantmentLevel)).withStyle(ChatFormatting.GRAY);
        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint == ServerConfig.EnchantmentHint.ALL) {
            tooltipAdder.accept((Component)enchantmentComponent);
        } else {
            tooltipAdder.accept((Component)Component.translatable((String)"container.enchant.clue", (Object[])new Object[]{enchantmentComponent}));
        }
        EnchantmentTooltipHelper.getEnchantmentDescriptionKey(holder).ifPresent(translationKey -> {
            MutableComponent descriptionComponent = Component.translatable((String)translationKey).withStyle(ChatFormatting.GRAY);
            ClientComponentSplitter.splitTooltipLines((FormattedText[])new FormattedText[]{descriptionComponent}).map(ComponentHelper::toComponent).forEach(tooltipAdder);
        });
    }

    private static <T> HolderSet<T> getTagOrEmpty(@Nullable HolderLookup.Provider registries, ResourceKey<Registry<T>> registryKey, TagKey<T> key) {
        Optional optional;
        if (registries != null && (optional = registries.lookupOrThrow(registryKey).get(key)).isPresent()) {
            return (HolderSet)optional.get();
        }
        return HolderSet.direct((Holder[])new Holder[0]);
    }

    private static Optional<String> getEnchantmentDescriptionKey(Holder<Enchantment> enchantment) {
        String translationKey = enchantment.unwrapKey().map(resourceKey -> Util.makeDescriptionId((String)resourceKey.registry().getPath(), (ResourceLocation)resourceKey.location())).orElse(null);
        if (translationKey == null) {
            return Optional.empty();
        }
        if (Language.getInstance().has(translationKey + ".desc")) {
            return Optional.of(translationKey + ".desc");
        }
        if (Language.getInstance().has(translationKey + ".description")) {
            return Optional.of(translationKey + ".description");
        }
        return Optional.empty();
    }

    public static void gatherSlotCostsTooltip(int slotIndex, List<Component> tooltipLines, Player player, ModEnchantmentMenu menu) {
        ArrayList additionalTooltip = Lists.newArrayList();
        if (!player.getAbilities().instabuild) {
            int enchantLevels = menu.costs[slotIndex];
            if (player.experienceLevel < enchantLevels) {
                additionalTooltip.add(Component.translatable((String)"container.enchant.level.requirement", (Object[])new Object[]{enchantLevels}).withStyle(ChatFormatting.RED));
            } else {
                EnchantmentTooltipHelper.getEnchantingComponent(slotIndex + 1, menu.getGoldCount(), KEY_ONE_ENCHANT_CATALYST, KEY_MANY_ENCHANT_CATALYSTS).ifPresent(additionalTooltip::add);
                EnchantmentTooltipHelper.getEnchantingComponent(slotIndex + 1, player.experienceLevel, KEY_ONE_ENCHANTMENT_LEVEL, KEY_MANY_ENCHANTMENT_LEVELS).ifPresent(additionalTooltip::add);
            }
        }
        if (!additionalTooltip.isEmpty()) {
            if (!tooltipLines.isEmpty()) {
                tooltipLines.add(CommonComponents.EMPTY);
            }
            tooltipLines.addAll(additionalTooltip);
        }
    }

    public static void gatherRerollTooltip(List<Component> tooltipLines, Player player, ModEnchantmentMenu menu) {
        tooltipLines.add((Component)Component.translatable((String)KEY_REROLL).withStyle(ChatFormatting.GRAY));
        ArrayList additionalTooltip = Lists.newArrayList();
        if (!player.getAbilities().instabuild) {
            int rerollCatalystCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst) {
                EnchantmentTooltipHelper.getEnchantingComponent(rerollCatalystCost, menu.getRerollCatalystCount(), KEY_ONE_REROLL_CATALYST, KEY_MANY_REROLL_CATALYSTS).ifPresent(additionalTooltip::add);
            } else {
                EnchantmentTooltipHelper.getEnchantingComponent(rerollCatalystCost, menu.getRerollCatalystCount(), KEY_ONE_ENCHANT_CATALYST, KEY_MANY_ENCHANT_CATALYSTS).ifPresent(additionalTooltip::add);
            }
            String singleKey = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels ? KEY_ONE_ENCHANTMENT_LEVEL : KEY_ONE_EXPERIENCE_POINT;
            String manyKey = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels ? KEY_MANY_ENCHANTMENT_LEVELS : KEY_MANY_EXPERIENCE_POINTS;
            EnchantmentTooltipHelper.getEnchantingComponent(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost, PlayerExperienceHelper.getTotalExperience(player), singleKey, manyKey).ifPresent(additionalTooltip::add);
        }
        if (!additionalTooltip.isEmpty()) {
            tooltipLines.add(CommonComponents.EMPTY);
            tooltipLines.addAll(additionalTooltip);
        }
    }

    private static Optional<Component> getEnchantingComponent(int requiredAmount, int currentAmount, String singleKey, String manyKey) {
        if (requiredAmount < 1) {
            return Optional.empty();
        }
        MutableComponent component = requiredAmount == 1 ? Component.translatable((String)singleKey) : Component.translatable((String)manyKey, (Object[])new Object[]{requiredAmount});
        return EnchantmentTooltipHelper.getEnchantingComponent(requiredAmount, currentAmount, component);
    }

    private static Optional<Component> getEnchantingComponent(int requiredAmount, int currentAmount, MutableComponent component) {
        if (requiredAmount < 1) {
            return Optional.empty();
        }
        return Optional.of(component.withStyle(currentAmount >= requiredAmount ? ChatFormatting.GRAY : ChatFormatting.RED));
    }
}

