/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.processing.AnimationProcessor;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtil;

public class GeoArmorRenderer<T extends Item, R extends HumanoidRenderState>
extends HumanoidModel
implements GeoRenderer<T, RenderData, R> {
    protected final GeoRenderLayersContainer<T, RenderData, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();
    protected BakedGeoModel lastModel = null;
    protected GeoBone headBone = null;
    protected GeoBone bodyBone = null;
    protected GeoBone rightArmBone = null;
    protected GeoBone leftArmBone = null;
    protected GeoBone rightLegBone = null;
    protected GeoBone leftLegBone = null;
    protected GeoBone rightBootBone = null;
    protected GeoBone leftBootBone = null;

    public GeoArmorRenderer(GeoModel<T> model) {
        super(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, RenderData, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoArmorRenderer<T, R> addRenderLayer(GeoRenderLayer<T, RenderData, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoArmorRenderer<T, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoArmorRenderer<T, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, RenderData stackAndSlot) {
        long stackId = GeoItem.getId(stackAndSlot.itemStack());
        if (stackId == Long.MAX_VALUE) {
            int id = stackAndSlot.entity().getId() * 13;
            return (long)id * (long)id * (long)id * (long)(-(stackAndSlot.slot().ordinal() + 1));
        }
        return -stackId;
    }

    @Override
    public int getRenderColor(T animatable, RenderData stackAndSlot, float partialTick) {
        return GeckoLibServices.Client.ITEM_RENDERING.getDyedItemColor(stackAndSlot.itemStack(), -1);
    }

    @Override
    @Nullable
    public RenderType getRenderType(R renderState, ResourceLocation texture) {
        return RenderType.armorCutoutNoCull((ResourceLocation)texture);
    }

    @Override
    @ApiStatus.Internal
    public R captureDefaultRenderState(T animatable, RenderData renderData, R renderState, float partialTick) {
        GeoRenderer.super.captureDefaultRenderState(animatable, renderData, renderState, partialTick);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_GECKOLIB_WEARER, renderData.entity() instanceof GeoAnimatable);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.EQUIPMENT_SLOT, renderData.slot());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.HAS_GLINT, renderData.itemStack().hasFoil());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.INVISIBLE_TO_PLAYER, ((HumanoidRenderState)renderState).isInvisibleToPlayer);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_GLOWING, ((HumanoidRenderState)renderState).appearsGlowing);
        return renderState;
    }

    @Override
    public void preRender(R renderState, PoseStack poseStack, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
            this.applyBaseTransformations(((GeoRenderState)renderState).getGeckolibData(DataTickets.HUMANOID_MODEL));
            this.applyBaseModel(((GeoRenderState)renderState).getGeckolibData(DataTickets.HUMANOID_MODEL));
            this.grabRelevantBones(model);
            if (!((GeoRenderState)renderState).getGeckolibData(DataTickets.IS_GECKOLIB_WEARER).booleanValue()) {
                this.applyBoneVisibilityBySlot(((GeoRenderState)renderState).getGeckolibData(DataTickets.EQUIPMENT_SLOT));
            }
        }
    }

    @Override
    public void scaleModelForRender(R renderState, float widthScale, float heightScale, PoseStack poseStack, BakedGeoModel model, boolean isReRender) {
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth, heightScale * this.scaleHeight, poseStack, model, isReRender);
    }

    @ApiStatus.Internal
    public final void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        GeckoLibConstants.LOGGER.debug("Something is attempting to directly call HumanoidModel#renderToBuffer. This is not supported by GeoArmorRenderer.");
    }

    @Override
    public void actuallyRender(R renderState, PoseStack poseStack, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 1.5f, 0.0f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        if (!isReRender) {
            this.getGeoModel().handleAnimations(this.createAnimationState((GeoRenderState)renderState));
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        if (buffer != null) {
            GeoRenderer.super.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        }
        poseStack.popPose();
    }

    @Override
    public void renderRecursively(R renderState, PoseStack poseStack, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations));
        }
        GeoRenderer.super.renderRecursively(renderState, poseStack, bone, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        if (this.lastModel == bakedModel) {
            return;
        }
        AnimationProcessor<T> animationProcessor = this.model.getAnimationProcessor();
        this.lastModel = bakedModel;
        this.headBone = animationProcessor.getBone("armorHead");
        this.bodyBone = animationProcessor.getBone("armorBody");
        this.rightArmBone = animationProcessor.getBone("armorRightArm");
        this.leftArmBone = animationProcessor.getBone("armorLeftArm");
        this.rightLegBone = animationProcessor.getBone("armorRightLeg");
        this.leftLegBone = animationProcessor.getBone("armorLeftLeg");
        this.rightBootBone = animationProcessor.getBone("armorRightBoot");
        this.leftBootBone = animationProcessor.getBone("armorLeftBoot");
    }

    protected void applyBaseModel(HumanoidModel<?> baseModel) {
        GeoArmorRenderer self = this;
        self.head.visible = baseModel.head.visible;
        self.hat.visible = baseModel.hat.visible;
        self.body.visible = baseModel.body.visible;
        self.rightArm.visible = baseModel.rightArm.visible;
        self.leftArm.visible = baseModel.leftArm.visible;
        self.rightLeg.visible = baseModel.rightLeg.visible;
        self.leftLeg.visible = baseModel.leftLeg.visible;
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
        this.setAllBonesVisible(false);
        switch (currentSlot) {
            case HEAD: {
                this.setBonesVisible(this.head.visible, new GeoBone[]{this.headBone});
                break;
            }
            case CHEST: {
                this.setBonesVisible(this.body.visible, new GeoBone[]{this.bodyBone, this.rightArmBone, this.leftArmBone});
                break;
            }
            case LEGS: {
                this.setBonesVisible(this.rightLeg.visible, new GeoBone[]{this.rightLegBone, this.leftLegBone});
                break;
            }
            case FEET: {
                this.setBonesVisible(this.rightLeg.visible, new GeoBone[]{this.rightBootBone, this.leftBootBone});
                break;
            }
        }
    }

    public void applyBoneVisibilityByPart(EquipmentSlot currentSlot, ModelPart currentPart, HumanoidModel<?> model) {
        this.setAllVisible(false);
        currentPart.visible = true;
        GeoBone bone = null;
        if (currentPart == model.hat || currentPart == model.head) {
            bone = this.headBone;
        } else if (currentPart == model.body) {
            bone = this.bodyBone;
        } else if (currentPart == model.leftArm) {
            bone = this.leftArmBone;
        } else if (currentPart == model.rightArm) {
            bone = this.rightArmBone;
        } else if (currentPart == model.leftLeg) {
            bone = currentSlot == EquipmentSlot.FEET ? this.leftBootBone : this.leftLegBone;
        } else if (currentPart == model.rightLeg) {
            GeoBone geoBone = bone = currentSlot == EquipmentSlot.FEET ? this.rightBootBone : this.rightLegBone;
        }
        if (bone != null) {
            bone.setHidden(false);
        }
    }

    protected void applyBaseTransformations(HumanoidModel<?> baseModel) {
        if (this.headBone != null) {
            ModelPart headPart = baseModel.head;
            RenderUtil.matchModelPartRot(headPart, this.headBone);
            this.headBone.updatePosition(headPart.x, -headPart.y, headPart.z);
        }
        if (this.bodyBone != null) {
            ModelPart bodyPart = baseModel.body;
            RenderUtil.matchModelPartRot(bodyPart, this.bodyBone);
            this.bodyBone.updatePosition(bodyPart.x, -bodyPart.y, bodyPart.z);
        }
        if (this.rightArmBone != null) {
            ModelPart rightArmPart = baseModel.rightArm;
            RenderUtil.matchModelPartRot(rightArmPart, this.rightArmBone);
            this.rightArmBone.updatePosition(rightArmPart.x + 5.0f, 2.0f - rightArmPart.y, rightArmPart.z);
        }
        if (this.leftArmBone != null) {
            ModelPart leftArmPart = baseModel.leftArm;
            RenderUtil.matchModelPartRot(leftArmPart, this.leftArmBone);
            this.leftArmBone.updatePosition(leftArmPart.x - 5.0f, 2.0f - leftArmPart.y, leftArmPart.z);
        }
        if (this.rightLegBone != null) {
            ModelPart rightLegPart = baseModel.rightLeg;
            RenderUtil.matchModelPartRot(rightLegPart, this.rightLegBone);
            this.rightLegBone.updatePosition(rightLegPart.x + 2.0f, 12.0f - rightLegPart.y, rightLegPart.z);
            if (this.rightBootBone != null) {
                RenderUtil.matchModelPartRot(rightLegPart, this.rightBootBone);
                this.rightBootBone.updatePosition(rightLegPart.x + 2.0f, 12.0f - rightLegPart.y, rightLegPart.z);
            }
        }
        if (this.leftLegBone != null) {
            ModelPart leftLegPart = baseModel.leftLeg;
            RenderUtil.matchModelPartRot(leftLegPart, this.leftLegBone);
            this.leftLegBone.updatePosition(leftLegPart.x - 2.0f, 12.0f - leftLegPart.y, leftLegPart.z);
            if (this.leftBootBone != null) {
                RenderUtil.matchModelPartRot(leftLegPart, this.leftBootBone);
                this.leftBootBone.updatePosition(leftLegPart.x - 2.0f, 12.0f - leftLegPart.y, leftLegPart.z);
            }
        }
    }

    public void setAllVisible(boolean visible) {
        super.setAllVisible(visible);
        this.setAllBonesVisible(visible);
    }

    protected void setAllBonesVisible(boolean visible) {
        this.setBonesVisible(visible, new GeoBone[]{this.headBone, this.bodyBone, this.rightArmBone, this.leftArmBone, this.rightLegBone, this.leftLegBone, this.rightBootBone, this.leftBootBone});
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileArmorRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, RenderData relatedObject, R renderState) {
        GeckoLibServices.Client.EVENTS.fireCompileArmorRenderState(this, renderState, animatable, relatedObject);
    }

    @Override
    public boolean firePreRenderEvent(R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
        return GeckoLibServices.Client.EVENTS.fireArmorPreRender(this, renderState, poseStack, model, bufferSource);
    }

    @Override
    public void firePostRenderEvent(R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
        GeckoLibServices.Client.EVENTS.fireArmorPostRender(this, renderState, poseStack, model, bufferSource);
    }

    @ApiStatus.Internal
    public static <S extends HumanoidRenderState, M extends HumanoidModel<S>, A extends HumanoidModel<S>> boolean tryRenderGeoArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, S humanoidRenderState, ItemStack stack, EquipmentSlot equipmentSlot, M parentModel, A baseModel, int packedLight, float netHeadYaw, float headPitch, BiConsumer<A, EquipmentSlot> partVisibilitySetter) {
        GeoRenderProvider renderProvider;
        if (!HumanoidArmorLayer.shouldRender((ItemStack)stack, (EquipmentSlot)equipmentSlot) || (renderProvider = GeoRenderProvider.of(stack)) == GeoRenderProvider.DEFAULT || !(humanoidRenderState instanceof GeoRenderState)) {
            return false;
        }
        GeoRenderState geoRenderState = (GeoRenderState)humanoidRenderState;
        GeoArmorRenderer<?, ?> armorRenderer = renderProvider.getGeoArmorRenderer(humanoidRenderState, stack, equipmentSlot, equipmentSlot == EquipmentSlot.LEGS ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID, baseModel);
        if (armorRenderer == null) {
            return false;
        }
        Reference2ObjectOpenHashMap existingRenderData = null;
        EnumMap perSlotData = geoRenderState.hasGeckolibData(DataTickets.PER_SLOT_RENDER_DATA) ? geoRenderState.getGeckolibData(DataTickets.PER_SLOT_RENDER_DATA) : null;
        geoRenderState.addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
        if (perSlotData != null && perSlotData.containsKey(equipmentSlot)) {
            Map<DataTicket<?>, Object> renderData = geoRenderState.getDataMap();
            existingRenderData = new Reference2ObjectOpenHashMap(renderData);
            renderData.clear();
            renderData.putAll((Map)perSlotData.get(equipmentSlot));
        }
        geoRenderState.addGeckolibData(DataTickets.HUMANOID_MODEL, baseModel);
        geoRenderState.addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
        parentModel.copyPropertiesTo(baseModel);
        partVisibilitySetter.accept(baseModel, equipmentSlot);
        baseModel.copyPropertiesTo(armorRenderer);
        RenderType renderType = armorRenderer.getRenderType(humanoidRenderState, armorRenderer.getTextureLocation(geoRenderState));
        VertexConsumer buffer = renderType == null ? null : ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)geoRenderState.getGeckolibData(DataTickets.HAS_GLINT));
        armorRenderer.defaultRender(geoRenderState, poseStack, bufferSource, renderType, buffer);
        if (existingRenderData != null) {
            geoRenderState.getDataMap().clear();
            geoRenderState.getDataMap().putAll((Map<DataTicket<?>, Object>)existingRenderData);
        }
        return true;
    }

    @ApiStatus.Internal
    public static <R extends HumanoidRenderState> void captureRenderStates(R baseRenderState, LivingEntity entity, float partialTick) {
        EnumMap<EquipmentSlot, Pair<GeoArmorRenderer<?, ?>, ItemStack>> relevantSlots = GeoArmorRenderer.getRelevantSlotsForRendering(entity);
        if (relevantSlots == null) {
            return;
        }
        EnumMap<EquipmentSlot, Reference2ObjectOpenHashMap> slotRenderData = new EnumMap<EquipmentSlot, Reference2ObjectOpenHashMap>(EquipmentSlot.class);
        Map<DataTicket<?>, Object> dataMap = ((GeoRenderState)baseRenderState).getDataMap();
        for (Map.Entry<EquipmentSlot, Pair<GeoArmorRenderer<?, ?>, ItemStack>> entry : relevantSlots.entrySet()) {
            GeoArmorRenderer renderer = (GeoArmorRenderer)entry.getValue().left();
            ItemStack stack = (ItemStack)entry.getValue().right();
            RenderData renderData = new RenderData(stack, entry.getKey(), entity);
            renderer.fillRenderState((GeoAnimatable)stack.getItem(), renderData, (GeoRenderState)baseRenderState, partialTick);
            slotRenderData.put(entry.getKey(), new Reference2ObjectOpenHashMap(dataMap));
            dataMap.clear();
        }
        ((GeoRenderState)baseRenderState).addGeckolibData(DataTickets.PER_SLOT_RENDER_DATA, slotRenderData);
    }

    @Nullable
    @ApiStatus.Internal
    private static EnumMap<EquipmentSlot, Pair<GeoArmorRenderer<?, ?>, ItemStack>> getRelevantSlotsForRendering(LivingEntity entity) {
        EnumMap<EquipmentSlot, Pair> relevantSlots = null;
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            GeoArmorRenderer<?, ?> geoArmorRenderer;
            GeoArmorRenderer<?, ?> renderer;
            GeoRenderProvider geoRenderProvider;
            ItemStack stack = HumanoidMobRenderer.getEquipmentIfRenderable((LivingEntity)entity, (EquipmentSlot)slot);
            if (stack.isEmpty() || (geoRenderProvider = GeoRenderProvider.of(stack)) == GeoRenderProvider.DEFAULT) continue;
            GeoArmorRenderer<?, ?> geoArmorRenderer2 = geoRenderProvider.getGeoArmorRenderer(null, stack, slot, slot == EquipmentSlot.LEGS ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID, null);
            GeoArmorRenderer<?, ?> geoArmorRenderer3 = renderer = geoArmorRenderer2 instanceof GeoArmorRenderer ? (geoArmorRenderer = geoArmorRenderer2) : null;
            if (renderer == null) continue;
            if (relevantSlots == null) {
                relevantSlots = new EnumMap<EquipmentSlot, Pair>(EquipmentSlot.class);
            }
            relevantSlots.put(slot, Pair.of(renderer, (Object)stack));
        }
        return relevantSlots;
    }

    public record RenderData(ItemStack itemStack, EquipmentSlot slot, LivingEntity entity) {
    }
}

