/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.model;

import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedGeoModel;

public class DefaultedEntityGeoModel<T extends GeoAnimatable>
extends DefaultedGeoModel<T> {
    protected final boolean turnsHead;

    public DefaultedEntityGeoModel(ResourceLocation assetSubpath) {
        this(assetSubpath, false);
    }

    public DefaultedEntityGeoModel(ResourceLocation assetSubpath, boolean turnsHead) {
        super(assetSubpath);
        this.turnsHead = turnsHead;
    }

    @Override
    protected String subtype() {
        return "entity";
    }

    @Override
    public void setCustomAnimations(AnimationState<T> animationState) {
        if (!this.turnsHead) {
            return;
        }
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            float pitch = animationState.getData(DataTickets.ENTITY_PITCH).floatValue();
            float yaw = animationState.getData(DataTickets.ENTITY_YAW).floatValue();
            head.setRotX(-pitch * ((float)Math.PI / 180));
            head.setRotY(-yaw * ((float)Math.PI / 180));
        }
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltModel(ResourceLocation altPath) {
        return (DefaultedEntityGeoModel)super.withAltModel(altPath);
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltAnimations(ResourceLocation altPath) {
        return (DefaultedEntityGeoModel)super.withAltAnimations(altPath);
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltTexture(ResourceLocation altPath) {
        return (DefaultedEntityGeoModel)super.withAltTexture(altPath);
    }
}

