/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.math;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.loading.math.value.Variable;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.util.ClientUtil;

public final class MolangQueries {
    public static final String ACTOR_COUNT = "query.actor_count";
    public static final String ANIM_TIME = "query.anim_time";
    public static final String BLOCK_STATE = "query.block_state";
    public static final String BLOCKING = "query.blocking";
    public static final String BODY_X_ROTATION = "query.body_x_rotation";
    public static final String BODY_Y_ROTATION = "query.body_y_rotation";
    public static final String CAN_CLIMB = "query.can_climb";
    public static final String CAN_FLY = "query.can_fly";
    public static final String CAN_SWIM = "query.can_swim";
    public static final String CAN_WALK = "query.can_walk";
    public static final String CARDINAL_FACING = "query.cardinal_facing";
    public static final String CARDINAL_FACING_2D = "query.cardinal_facing_2d";
    public static final String CARDINAL_PLAYER_FACING = "query.cardinal_player_facing";
    public static final String CONTROLLER_SPEED = "query.controller_speed";
    public static final String DAY = "query.day";
    public static final String DEATH_TICKS = "query.death_ticks";
    public static final String DISTANCE_FROM_CAMERA = "query.distance_from_camera";
    public static final String EQUIPMENT_COUNT = "query.equipment_count";
    public static final String FRAME_ALPHA = "query.frame_alpha";
    public static final String GET_ACTOR_INFO_ID = "query.get_actor_info_id";
    public static final String GROUND_SPEED = "query.ground_speed";
    public static final String HAS_CAPE = "query.has_cape";
    public static final String HAS_COLLISION = "query.has_collision";
    public static final String HAS_GRAVITY = "query.has_gravity";
    public static final String HAS_HEAD_GEAR = "query.has_head_gear";
    public static final String HAS_OWNER = "query.has_owner";
    public static final String HAS_PLAYER_RIDER = "query.has_player_rider";
    public static final String HAS_RIDER = "query.has_rider";
    public static final String HEAD_X_ROTATION = "query.head_x_rotation";
    public static final String HEAD_Y_ROTATION = "query.head_y_rotation";
    public static final String HEALTH = "query.health";
    public static final String HURT_TIME = "query.hurt_time";
    public static final String INVULNERABLE_TICKS = "query.invulnerable_ticks";
    public static final String IS_ALIVE = "query.is_alive";
    public static final String IS_ANGRY = "query.is_angry";
    public static final String IS_BABY = "query.is_baby";
    public static final String IS_BREATHING = "query.is_breathing";
    public static final String IS_ENCHANTED = "query.is_enchanted";
    public static final String IS_FIRE_IMMUNE = "query.is_fire_immune";
    public static final String IS_FIRST_PERSON = "query.is_first_person";
    public static final String IS_IN_CONTACT_WITH_WATER = "query.is_in_contact_with_water";
    public static final String IS_IN_LAVA = "query.is_in_lava";
    public static final String IS_IN_WATER = "query.is_in_water";
    public static final String IS_IN_WATER_OR_RAIN = "query.is_in_water_or_rain";
    public static final String IS_INVISIBLE = "query.is_invisible";
    public static final String IS_LEASHED = "query.is_leashed";
    public static final String IS_MOVING = "query.is_moving";
    public static final String IS_ON_FIRE = "query.is_on_fire";
    public static final String IS_ON_GROUND = "query.is_on_ground";
    public static final String IS_RIDING = "query.is_riding";
    public static final String IS_SADDLED = "query.is_saddled";
    public static final String IS_SILENT = "query.is_silent";
    public static final String IS_SLEEPING = "query.is_sleeping";
    public static final String IS_SNEAKING = "query.is_sneaking";
    public static final String IS_SPRINTING = "query.is_sprinting";
    public static final String IS_STACKABLE = "query.is_stackable";
    public static final String IS_SWIMMING = "query.is_swimming";
    public static final String IS_USING_ITEM = "query.is_using_item";
    public static final String IS_WALL_CLIMBING = "query.is_wall_climbing";
    public static final String ITEM_MAX_USE_DURATION = "query.item_max_use_duration";
    public static final String LIFE_TIME = "query.life_time";
    public static final String LIMB_SWING = "query.limb_swing";
    public static final String LIMB_SWING_AMOUNT = "query.limb_swing_amount";
    public static final String MAIN_HAND_ITEM_MAX_DURATION = "query.main_hand_item_max_duration";
    public static final String MAIN_HAND_ITEM_USE_DURATION = "query.main_hand_item_use_duration";
    public static final String MAX_DURABILITY = "query.max_durability";
    public static final String MAX_HEALTH = "query.max_health";
    public static final String MOON_BRIGHTNESS = "query.moon_brightness";
    public static final String MOON_PHASE = "query.moon_phase";
    public static final String MOVEMENT_DIRECTION = "query.movement_direction";
    public static final String PLAYER_LEVEL = "query.player_level";
    public static final String REMAINING_DURABILITY = "query.remaining_durability";
    public static final String RIDER_BODY_X_ROTATION = "query.rider_body_x_rotation";
    public static final String RIDER_BODY_Y_ROTATION = "query.rider_body_y_rotation";
    public static final String RIDER_HEAD_X_ROTATION = "query.rider_head_x_rotation";
    public static final String RIDER_HEAD_Y_ROTATION = "query.rider_head_y_rotation";
    public static final String SCALE = "query.scale";
    public static final String SLEEP_ROTATION = "query.sleep_rotation";
    public static final String TIME_OF_DAY = "query.time_of_day";
    public static final String TIME_STAMP = "query.time_stamp";
    public static final String VERTICAL_SPEED = "query.vertical_speed";
    public static final String YAW_SPEED = "query.yaw_speed";
    private static final Map<String, Variable> VARIABLES = new Object2ObjectOpenHashMap();
    private static final Map<Variable, ToDoubleFunction<Actor<? extends GeoAnimatable>>> ACTOR_VARIABLES = new Reference2ObjectOpenHashMap();

    public static boolean isExistingVariable(String name) {
        return VARIABLES.containsKey(name);
    }

    static void registerVariable(Variable variable) {
        VARIABLES.put(variable.name(), variable);
    }

    static Variable getVariableFor(String name) {
        return VARIABLES.computeIfAbsent(MolangQueries.applyPrefixAliases(name, "query.", "q."), key -> new Variable((String)key, 0.0));
    }

    private static String applyPrefixAliases(String text, String properName, String ... aliases) {
        for (String alias : aliases) {
            if (!text.startsWith(alias)) continue;
            return properName + text.substring(alias.length());
        }
        return text;
    }

    public static <T> void setActorVariable(String name, ToDoubleFunction<Actor<T>> valueFunction) {
        Variable variable = MolangQueries.getVariableFor(name);
        ACTOR_VARIABLES.put(variable, valueFunction);
        MolangQueries.getVariableFor(name).set(state -> state.getActorVariableValue(variable));
    }

    public static <T extends GeoAnimatable> void setVariableFunction(String name, ToDoubleFunction<AnimationState<T>> valueFunction) {
        Variable variable = MolangQueries.getVariableFor(name);
        if (ACTOR_VARIABLES.containsKey(variable)) {
            throw new IllegalArgumentException("Cannot replace actor variables");
        }
        variable.set(valueFunction);
    }

    public static void setVariableValue(String name, double value) {
        Variable variable = MolangQueries.getVariableFor(name);
        if (ACTOR_VARIABLES.containsKey(variable)) {
            throw new IllegalArgumentException("Cannot replace actor variables");
        }
        variable.set(value);
    }

    public static <T extends GeoAnimatable> void buildActorVariables(Actor<T> actor, Set<Variable> variables, Reference2DoubleMap<Variable> valueMap) {
        for (Variable variable : variables) {
            if (!ACTOR_VARIABLES.containsKey(variable)) continue;
            valueMap.computeIfAbsent((Object)variable, v -> ACTOR_VARIABLES.get(v).applyAsDouble(actor));
        }
    }

    private static void setDefaultQueryValues() {
        MolangQueries.setVariableValue("PI", Math.PI);
        MolangQueries.setVariableValue("E", Math.E);
        MolangQueries.setActorVariable(ACTOR_COUNT, actor -> ClientUtil.getVisibleEntityCount());
        MolangQueries.setActorVariable(ANIM_TIME, actor -> ((AnimationController)actor.controller().getValue()).getCurrentAnimationSeconds());
        MolangQueries.setActorVariable(CONTROLLER_SPEED, actor -> ((AnimationController)actor.controller.getValue()).getAnimationSpeed());
        MolangQueries.setActorVariable(CARDINAL_PLAYER_FACING, actor -> actor.clientPlayer.getDirection().ordinal());
        MolangQueries.setActorVariable(DAY, actor -> (double)actor.level.getGameTime() / 24000.0);
        MolangQueries.setActorVariable(FRAME_ALPHA, actor -> actor.partialTick);
        MolangQueries.setActorVariable(HAS_CAPE, actor -> ClientUtil.clientPlayerHasCape() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_FIRST_PERSON, actor -> ClientUtil.isFirstPerson() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(LIFE_TIME, actor -> actor.animationTicks / 20.0);
        MolangQueries.setActorVariable(MOON_BRIGHTNESS, actor -> actor.level.getMoonBrightness());
        MolangQueries.setActorVariable(MOON_PHASE, actor -> actor.level.getMoonPhase());
        MolangQueries.setActorVariable(PLAYER_LEVEL, actor -> actor.clientPlayer.experienceLevel);
        MolangQueries.setActorVariable(TIME_OF_DAY, actor -> (double)actor.level.getDayTime() / 24000.0);
        MolangQueries.setActorVariable(TIME_STAMP, actor -> actor.level.getGameTime());
        MolangQueries.setDefaultBlockEntityQueryValues();
        MolangQueries.setDefaultEntityQueryValues();
        MolangQueries.setDefaultLivingEntityQueryValues();
        MolangQueries.setDefaultMobQueryValues();
        MolangQueries.setDefaultItemQueryValues();
    }

    private static void setDefaultBlockEntityQueryValues() {
        MolangQueries.setActorVariable(BLOCK_STATE, actor -> ((BlockEntity)actor.animatable).getBlockState().getBlock().getStateDefinition().getPossibleStates().indexOf((Object)((BlockEntity)actor.animatable).getBlockState()));
    }

    private static void setDefaultEntityQueryValues() {
        MolangQueries.setActorVariable(BODY_X_ROTATION, actor -> actor.animatable instanceof LivingEntity ? 0.0 : (double)((Entity)actor.animatable).getViewXRot(actor.partialTick));
        MolangQueries.setActorVariable(BODY_Y_ROTATION, actor -> {
            double d;
            Object patt0$temp = actor.animatable;
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                d = Mth.lerp((float)actor.partialTick, (float)living.yBodyRotO, (float)living.yBodyRot);
            } else {
                d = ((Entity)actor.animatable).getViewYRot(actor.partialTick);
            }
            return d;
        });
        MolangQueries.setActorVariable(CARDINAL_FACING, actor -> ((Entity)actor.animatable).getDirection().get3DDataValue());
        MolangQueries.setActorVariable(CARDINAL_FACING_2D, actor -> {
            int directionId = ((Entity)actor.animatable).getDirection().get3DDataValue();
            return directionId < 2 ? 6.0 : (double)directionId;
        });
        MolangQueries.setActorVariable(DISTANCE_FROM_CAMERA, actor -> actor.cameraPos.distanceTo(((Entity)actor.animatable).position()));
        MolangQueries.setActorVariable(GET_ACTOR_INFO_ID, actor -> ((Entity)actor.animatable).getId());
        MolangQueries.setActorVariable(EQUIPMENT_COUNT, actor -> {
            long l;
            Object patt0$temp = actor.animatable;
            if (patt0$temp instanceof EquipmentUser) {
                EquipmentUser armorable = (EquipmentUser)patt0$temp;
                l = Arrays.stream(EquipmentSlot.values()).filter(EquipmentSlot::isArmor).filter(slot -> !armorable.getItemBySlot(slot).isEmpty()).count();
            } else {
                l = 0L;
            }
            return l;
        });
        MolangQueries.setActorVariable(HAS_COLLISION, actor -> !((Entity)actor.animatable).noPhysics ? 1.0 : 0.0);
        MolangQueries.setActorVariable(HAS_GRAVITY, actor -> !((Entity)actor.animatable).isNoGravity() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(HAS_OWNER, actor -> {
            OwnableEntity ownable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof OwnableEntity && (ownable = (OwnableEntity)patt0$temp).getOwnerReference() != null ? 1 : 0;
        });
        MolangQueries.setActorVariable(HAS_PLAYER_RIDER, actor -> ((Entity)actor.animatable).hasPassenger(Player.class::isInstance) ? 1.0 : 0.0);
        MolangQueries.setActorVariable(HAS_RIDER, actor -> ((Entity)actor.animatable).isVehicle() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_ALIVE, actor -> ((Entity)actor.animatable).isAlive() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_ANGRY, actor -> {
            NeutralMob neutralMob;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof NeutralMob && (neutralMob = (NeutralMob)patt0$temp).isAngry() ? 1 : 0;
        });
        MolangQueries.setActorVariable(IS_BREATHING, actor -> ((Entity)actor.animatable).getAirSupply() >= ((Entity)actor.animatable).getMaxAirSupply() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_FIRE_IMMUNE, actor -> ((Entity)actor.animatable).getType().fireImmune() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_INVISIBLE, actor -> ((Entity)actor.animatable).isInvisible() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_IN_CONTACT_WITH_WATER, actor -> ((Entity)actor.animatable).isInWaterOrRain() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_IN_LAVA, actor -> ((Entity)actor.animatable).isInLava() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_IN_WATER, actor -> ((Entity)actor.animatable).isInWater() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_IN_WATER_OR_RAIN, actor -> ((Entity)actor.animatable).isInWaterOrRain() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_LEASHED, actor -> {
            Leashable leashable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof Leashable && (leashable = (Leashable)patt0$temp).isLeashed() ? 1 : 0;
        });
        MolangQueries.setActorVariable(IS_MOVING, actor -> actor.renderState.getGeckolibData(DataTickets.IS_MOVING) != false ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_ON_FIRE, actor -> ((Entity)actor.animatable).isOnFire() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_ON_GROUND, actor -> ((Entity)actor.animatable).onGround() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_RIDING, actor -> ((Entity)actor.animatable).isPassenger() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_SADDLED, actor -> {
            EquipmentUser saddleable;
            Object patt0$temp = actor.animatable;
            return patt0$temp instanceof EquipmentUser && !(saddleable = (EquipmentUser)patt0$temp).getItemBySlot(EquipmentSlot.SADDLE).isEmpty() ? 1 : 0;
        });
        MolangQueries.setActorVariable(IS_SILENT, actor -> ((Entity)actor.animatable).isSilent() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_SNEAKING, actor -> ((Entity)actor.animatable).isCrouching() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_SPRINTING, actor -> ((Entity)actor.animatable).isSprinting() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_SWIMMING, actor -> ((Entity)actor.animatable).isSwimming() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(MOVEMENT_DIRECTION, actor -> actor.renderState.getGeckolibData(DataTickets.IS_MOVING) != false ? (double)Direction.getApproximateNearest((Vec3)((Entity)actor.animatable).getDeltaMovement()).get3DDataValue() : 6.0);
        MolangQueries.setActorVariable(RIDER_BODY_X_ROTATION, actor -> ((Entity)actor.animatable).isVehicle() ? (((Entity)actor.animatable).getFirstPassenger() instanceof LivingEntity ? 0.0 : (double)((Entity)actor.animatable).getFirstPassenger().getViewXRot(actor.partialTick)) : 0.0);
        MolangQueries.setActorVariable(RIDER_BODY_Y_ROTATION, actor -> {
            double d;
            if (((Entity)actor.animatable).isVehicle()) {
                Entity patt0$temp = ((Entity)actor.animatable).getFirstPassenger();
                if (patt0$temp instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)patt0$temp;
                    d = Mth.lerp((float)actor.partialTick, (float)living.yBodyRotO, (float)living.yBodyRot);
                } else {
                    d = ((Entity)actor.animatable).getFirstPassenger().getViewYRot(actor.partialTick);
                }
            } else {
                d = 0.0;
            }
            return d;
        });
        MolangQueries.setActorVariable(RIDER_HEAD_X_ROTATION, actor -> {
            double d;
            Entity patt0$temp = ((Entity)actor.animatable).getFirstPassenger();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                d = living.getViewXRot(actor.partialTick);
            } else {
                d = 0.0;
            }
            return d;
        });
        MolangQueries.setActorVariable(RIDER_HEAD_Y_ROTATION, actor -> {
            double d;
            Entity patt0$temp = ((Entity)actor.animatable).getFirstPassenger();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                d = living.getViewYRot(actor.partialTick);
            } else {
                d = 0.0;
            }
            return d;
        });
        MolangQueries.setActorVariable(VERTICAL_SPEED, actor -> ((Entity)actor.animatable).getDeltaMovement().y);
        MolangQueries.setActorVariable(YAW_SPEED, actor -> ((Entity)actor.animatable).getYRot() - ((Entity)actor.animatable).yRotO);
    }

    private static void setDefaultLivingEntityQueryValues() {
        MolangQueries.setActorVariable(BLOCKING, actor -> ((LivingEntity)actor.animatable).isBlocking() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(DEATH_TICKS, actor -> ((LivingEntity)actor.animatable).deathTime == 0 ? 0.0 : (double)((float)((LivingEntity)actor.animatable).deathTime + actor.partialTick));
        MolangQueries.setActorVariable(GROUND_SPEED, actor -> ((LivingEntity)actor.animatable).getDeltaMovement().horizontalDistance());
        MolangQueries.setActorVariable(HAS_HEAD_GEAR, actor -> !((LivingEntity)actor.animatable).getItemBySlot(EquipmentSlot.HEAD).isEmpty() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(HEAD_X_ROTATION, actor -> ((LivingEntity)actor.animatable).getViewXRot(actor.partialTick));
        MolangQueries.setActorVariable(HEAD_Y_ROTATION, actor -> ((LivingEntity)actor.animatable).getViewYRot(actor.partialTick));
        MolangQueries.setActorVariable(HEALTH, actor -> ((LivingEntity)actor.animatable).getHealth());
        MolangQueries.setActorVariable(HURT_TIME, actor -> ((LivingEntity)actor.animatable).hurtTime == 0 ? 0.0 : (double)((float)((LivingEntity)actor.animatable).hurtTime - actor.partialTick));
        MolangQueries.setActorVariable(INVULNERABLE_TICKS, actor -> ((LivingEntity)actor.animatable).invulnerableTime == 0 ? 0.0 : (double)((float)((LivingEntity)actor.animatable).invulnerableTime - actor.partialTick));
        MolangQueries.setActorVariable(IS_BABY, actor -> ((LivingEntity)actor.animatable).isBaby() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_SLEEPING, actor -> ((LivingEntity)actor.animatable).isSleeping() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_USING_ITEM, actor -> ((LivingEntity)actor.animatable).isUsingItem() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_WALL_CLIMBING, actor -> ((LivingEntity)actor.animatable).onClimbable() ? 1.0 : 0.0);
        MolangQueries.setActorVariable(LIMB_SWING, actor -> ((LivingEntity)actor.animatable).walkAnimation.position());
        MolangQueries.setActorVariable(LIMB_SWING_AMOUNT, actor -> ((LivingEntity)actor.animatable).walkAnimation.speed(actor.partialTick()));
        MolangQueries.setActorVariable(MAIN_HAND_ITEM_MAX_DURATION, actor -> ((LivingEntity)actor.animatable).getMainHandItem().getUseDuration((LivingEntity)actor.animatable));
        MolangQueries.setActorVariable(MAIN_HAND_ITEM_USE_DURATION, actor -> ((LivingEntity)actor.animatable).getUsedItemHand() == InteractionHand.MAIN_HAND ? (double)((LivingEntity)actor.animatable).getTicksUsingItem() / 20.0 + (double)actor.partialTick : 0.0);
        MolangQueries.setActorVariable(MAX_HEALTH, actor -> ((LivingEntity)actor.animatable).getMaxHealth());
        MolangQueries.setActorVariable(SCALE, actor -> ((LivingEntity)actor.animatable).getScale());
        MolangQueries.setActorVariable(SLEEP_ROTATION, actor -> Optional.ofNullable(((LivingEntity)actor.animatable).getBedOrientation()).map(Direction::toYRot).orElse(Float.valueOf(0.0f)).floatValue());
    }

    private static void setDefaultMobQueryValues() {
        MolangQueries.setActorVariable(CAN_CLIMB, actor -> !((Mob)actor.animatable).isNoAi() && ((Mob)actor.animatable).getNavigation() instanceof WallClimberNavigation ? 1.0 : 0.0);
        MolangQueries.setActorVariable(CAN_FLY, actor -> !((Mob)actor.animatable).isNoAi() && ((Mob)actor.animatable).getNavigation() instanceof FlyingPathNavigation ? 1.0 : 0.0);
        MolangQueries.setActorVariable(CAN_SWIM, actor -> !((Mob)actor.animatable).isNoAi() && ((Mob)actor.animatable).getNavigation() instanceof WaterBoundPathNavigation || ((Mob)actor.animatable).getNavigation() instanceof AmphibiousPathNavigation ? 1.0 : 0.0);
        MolangQueries.setActorVariable(CAN_WALK, actor -> !((Mob)actor.animatable).isNoAi() && ((Mob)actor.animatable).getNavigation() instanceof GroundPathNavigation || ((Mob)actor.animatable).getNavigation() instanceof AmphibiousPathNavigation ? 1.0 : 0.0);
    }

    private static void setDefaultItemQueryValues() {
        MolangQueries.setActorVariable(IS_ENCHANTED, actor -> actor.renderState.getGeckolibData(DataTickets.IS_ENCHANTED) != false ? 1.0 : 0.0);
        MolangQueries.setActorVariable(IS_STACKABLE, actor -> actor.renderState.getGeckolibData(DataTickets.IS_STACKABLE) != false ? 1.0 : 0.0);
        MolangQueries.setActorVariable(ITEM_MAX_USE_DURATION, actor -> actor.renderState.getGeckolibData(DataTickets.MAX_USE_DURATION).intValue());
        MolangQueries.setActorVariable(MAX_DURABILITY, actor -> actor.renderState.getGeckolibData(DataTickets.MAX_DURABILITY).intValue());
        MolangQueries.setActorVariable(REMAINING_DURABILITY, actor -> actor.renderState.getGeckolibData(DataTickets.REMAINING_DURABILITY).intValue());
    }

    static {
        MolangQueries.setDefaultQueryValues();
    }

    public record Actor<T>(T animatable, GeoRenderState renderState, MutableObject<AnimationController<?>> controller, double animationTicks, float partialTick, Level level, Player clientPlayer, Vec3 cameraPos) {
    }
}

