/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoObjectRenderer;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public interface GeoRenderEvent<T extends GeoAnimatable, O, R extends GeoRenderState> {
    public GeoRenderer<T, O, R> getRenderer();

    public R getRenderState();

    @Nullable
    default public <D> D getRenderData(DataTicket<D> dataTicket) {
        R renderState = this.getRenderState();
        return renderState.hasGeckolibData(dataTicket) ? (D)this.getRenderState().getGeckolibData(dataTicket) : null;
    }

    default public float getPartialTick() {
        return this.getRenderData(DataTickets.PARTIAL_TICK).floatValue();
    }

    default public int packedLight() {
        return this.getRenderData(DataTickets.PACKED_LIGHT);
    }

    default public Class<? extends GeoAnimatable> getAnimatableClass() {
        return this.getRenderData(DataTickets.ANIMATABLE_CLASS);
    }

    public static abstract class Object<T extends GeoAnimatable>
    extends Event
    implements GeoRenderEvent<T, Void, GeoRenderState> {
        private final GeoObjectRenderer<T> renderer;
        private final GeoRenderState renderState;

        public Object(GeoObjectRenderer<T> renderer, GeoRenderState renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        @Override
        public GeoRenderState getRenderState() {
            return this.renderState;
        }

        public GeoObjectRenderer<T> getRenderer() {
            return this.renderer;
        }

        public static class Post<T extends GeoAnimatable>
        extends Object<T> {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Post(GeoObjectRenderer<T> renderer, GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class Pre<T extends GeoAnimatable>
        extends Object<T>
        implements ICancellableEvent {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Pre(GeoObjectRenderer<T> renderer, GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class CompileRenderState<T extends GeoAnimatable>
        extends Object<T> {
            private final T animatable;

            public CompileRenderState(GeoObjectRenderer<T> renderer, GeoRenderState renderState, T animatable) {
                super(renderer, renderState);
                this.animatable = animatable;
            }

            public T getAnimatable() {
                return this.animatable;
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                this.getRenderState().addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return this.getRenderState().hasGeckolibData(dataTicket);
            }
        }

        public static class CompileRenderLayers<T extends GeoAnimatable>
        extends Object<T> {
            public CompileRenderLayers(GeoObjectRenderer<T> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public GeoRenderState getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, Void, GeoRenderState> renderLayer) {
                ((GeoObjectRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }
        }
    }

    public static abstract class Item<T extends net.minecraft.world.item.Item>
    extends Event
    implements GeoRenderEvent<T, GeoItemRenderer.RenderData, GeoRenderState> {
        private final GeoItemRenderer<T> renderer;
        private final GeoRenderState renderState;

        public Item(GeoItemRenderer<T> renderer, GeoRenderState renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        @Override
        public GeoRenderState getRenderState() {
            return this.renderState;
        }

        public GeoItemRenderer<T> getRenderer() {
            return this.renderer;
        }

        public static class Post<T extends net.minecraft.world.item.Item>
        extends Item<T> {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Post(GeoItemRenderer<T> renderer, GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class Pre<T extends net.minecraft.world.item.Item>
        extends Item<T>
        implements ICancellableEvent {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Pre(GeoItemRenderer<T> renderer, GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class CompileRenderState<T extends net.minecraft.world.item.Item>
        extends Item<T> {
            private final T animatable;
            private final GeoItemRenderer.RenderData renderData;

            public CompileRenderState(GeoItemRenderer<T> renderer, GeoRenderState renderState, T animatable, GeoItemRenderer.RenderData renderData) {
                super(renderer, renderState);
                this.animatable = animatable;
                this.renderData = renderData;
            }

            public T getAnimatable() {
                return this.animatable;
            }

            public GeoItemRenderer.RenderData getRenderData() {
                return this.renderData;
            }

            public ItemStack getItemStack() {
                return this.renderData.itemStack();
            }

            public ItemDisplayContext getRenderPerspective() {
                return this.renderData.renderPerspective();
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                this.getRenderState().addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return this.getRenderState().hasGeckolibData(dataTicket);
            }
        }

        public static class CompileRenderLayers<T extends net.minecraft.world.item.Item>
        extends Item<T> {
            public CompileRenderLayers(GeoItemRenderer<T> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public GeoRenderState getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, GeoItemRenderer.RenderData, GeoRenderState> renderLayer) {
                ((GeoItemRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }
        }
    }

    public static abstract class ReplacedEntity<T extends GeoAnimatable, E extends net.minecraft.world.entity.Entity, R extends EntityRenderState>
    extends Event
    implements GeoRenderEvent<T, E, R> {
        private final GeoReplacedEntityRenderer<T, E, R> renderer;
        private final R renderState;

        public ReplacedEntity(GeoReplacedEntityRenderer<T, E, R> renderer, R renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        @Override
        public R getRenderState() {
            return this.renderState;
        }

        @Override
        public GeoReplacedEntityRenderer<T, E, R> getRenderer() {
            return this.renderer;
        }

        public static class Post<T extends GeoAnimatable, E extends net.minecraft.world.entity.Entity, R extends EntityRenderState>
        extends ReplacedEntity<T, E, R> {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Post(GeoReplacedEntityRenderer<T, E, R> renderer, R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class Pre<T extends GeoAnimatable, E extends net.minecraft.world.entity.Entity, R extends EntityRenderState>
        extends ReplacedEntity<T, E, R>
        implements ICancellableEvent {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Pre(GeoReplacedEntityRenderer<T, E, R> renderer, R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class CompileRenderState<T extends GeoAnimatable, E extends net.minecraft.world.entity.Entity, R extends EntityRenderState>
        extends ReplacedEntity<T, E, R> {
            private final GeoAnimatable animatable;
            private final E entity;

            public CompileRenderState(GeoReplacedEntityRenderer<T, E, R> renderer, R renderState, GeoAnimatable animatable, E entity) {
                super(renderer, renderState);
                this.animatable = animatable;
                this.entity = entity;
            }

            public GeoAnimatable getAnimatable() {
                return this.animatable;
            }

            public net.minecraft.world.entity.Entity getReplacedEntity() {
                return this.entity;
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                ((GeoRenderState)this.getRenderState()).addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return ((GeoRenderState)this.getRenderState()).hasGeckolibData(dataTicket);
            }
        }

        public static class CompileRenderLayers<T extends GeoAnimatable, E extends net.minecraft.world.entity.Entity, R extends EntityRenderState>
        extends ReplacedEntity<T, E, R> {
            public CompileRenderLayers(GeoReplacedEntityRenderer<T, E, R> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, E, R> renderLayer) {
                ((GeoReplacedEntityRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }
        }
    }

    public static abstract class Entity<T extends net.minecraft.world.entity.Entity, R extends EntityRenderState>
    extends Event
    implements GeoRenderEvent<T, Void, R> {
        private final GeoEntityRenderer<T, R> renderer;
        private final R renderState;

        public Entity(GeoEntityRenderer<T, R> renderer, R renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        @Override
        public R getRenderState() {
            return this.renderState;
        }

        public GeoEntityRenderer<T, R> getRenderer() {
            return this.renderer;
        }

        public static class Post<T extends net.minecraft.world.entity.Entity, R extends EntityRenderState>
        extends Entity<T, R> {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Post(GeoEntityRenderer<T, R> renderer, R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class Pre<T extends net.minecraft.world.entity.Entity, R extends EntityRenderState>
        extends Entity<T, R>
        implements ICancellableEvent {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Pre(GeoEntityRenderer<T, R> renderer, R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class CompileRenderState<T extends net.minecraft.world.entity.Entity, R extends EntityRenderState>
        extends Entity<T, R> {
            private final T animatable;

            public CompileRenderState(GeoEntityRenderer<T, R> renderer, R renderState, T animatable) {
                super(renderer, renderState);
                this.animatable = animatable;
            }

            public T getAnimatable() {
                return this.animatable;
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                ((GeoRenderState)this.getRenderState()).addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return ((GeoRenderState)this.getRenderState()).hasGeckolibData(dataTicket);
            }
        }

        public static class CompileRenderLayers<T extends net.minecraft.world.entity.Entity, R extends EntityRenderState>
        extends Entity<T, R> {
            public CompileRenderLayers(GeoEntityRenderer<T, R> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, Void, R> renderLayer) {
                ((GeoEntityRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }
        }
    }

    public static abstract class Armor<T extends net.minecraft.world.item.Item, R extends HumanoidRenderState>
    extends Event
    implements GeoRenderEvent<T, GeoArmorRenderer.RenderData, R> {
        private final GeoArmorRenderer<T, R> renderer;
        private final R renderState;

        public Armor(GeoArmorRenderer<T, R> renderer, R renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        public GeoArmorRenderer<T, R> getRenderer() {
            return this.renderer;
        }

        @Override
        public R getRenderState() {
            return this.renderState;
        }

        public EquipmentSlot getEquipmentSlot() {
            return (EquipmentSlot)this.getRenderData(DataTickets.EQUIPMENT_SLOT);
        }

        public static class Post<T extends net.minecraft.world.item.Item, R extends HumanoidRenderState>
        extends Armor<T, R> {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Post(GeoArmorRenderer<T, R> renderer, R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class Pre<T extends net.minecraft.world.item.Item, R extends HumanoidRenderState>
        extends Armor<T, R>
        implements ICancellableEvent {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Pre(GeoArmorRenderer<T, R> renderer, R renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class CompileRenderState<T extends net.minecraft.world.item.Item, R extends HumanoidRenderState>
        extends Armor<T, R> {
            private final T animatable;
            private final GeoArmorRenderer.RenderData renderData;

            public CompileRenderState(GeoArmorRenderer<T, R> renderer, R renderState, T animatable, GeoArmorRenderer.RenderData renderData) {
                super(renderer, renderState);
                this.animatable = animatable;
                this.renderData = renderData;
            }

            public T getAnimatable() {
                return this.animatable;
            }

            public GeoArmorRenderer.RenderData getRenderData() {
                return this.renderData;
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                ((GeoRenderState)this.getRenderState()).addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return ((GeoRenderState)this.getRenderState()).hasGeckolibData(dataTicket);
            }
        }

        public static class CompileRenderLayers<T extends net.minecraft.world.item.Item, R extends HumanoidRenderState>
        extends Armor<T, R> {
            public CompileRenderLayers(GeoArmorRenderer<T, R> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, GeoArmorRenderer.RenderData, R> renderLayer) {
                ((GeoArmorRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }
        }
    }

    public static abstract class Block<T extends BlockEntity>
    extends Event
    implements GeoRenderEvent<T, Void, GeoRenderState> {
        private final GeoBlockRenderer<T> renderer;
        private final GeoRenderState renderState;

        public Block(GeoBlockRenderer<T> renderer, GeoRenderState renderState) {
            this.renderer = renderer;
            this.renderState = renderState;
        }

        @Override
        public GeoRenderState getRenderState() {
            return this.renderState;
        }

        public GeoBlockRenderer<T> getRenderer() {
            return this.renderer;
        }

        public static class Post<T extends BlockEntity>
        extends Block<T> {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Post(GeoBlockRenderer<T> renderer, GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class Pre<T extends BlockEntity>
        extends Block<T>
        implements ICancellableEvent {
            private final PoseStack poseStack;
            private final BakedGeoModel model;
            private final MultiBufferSource bufferSource;

            public Pre(GeoBlockRenderer<T> renderer, GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
                super(renderer, renderState);
                this.poseStack = poseStack;
                this.model = model;
                this.bufferSource = bufferSource;
            }

            public PoseStack getPoseStack() {
                return this.poseStack;
            }

            public BakedGeoModel getModel() {
                return this.model;
            }

            public MultiBufferSource getBufferSource() {
                return this.bufferSource;
            }
        }

        public static class CompileRenderState<T extends BlockEntity>
        extends Block<T> {
            private final T animatable;

            public CompileRenderState(GeoBlockRenderer<T> renderer, GeoRenderState renderState, T animatable) {
                super(renderer, renderState);
                this.animatable = animatable;
            }

            public T getAnimatable() {
                return this.animatable;
            }

            public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                this.getRenderState().addGeckolibData(dataTicket, data);
            }

            public boolean hasData(DataTicket<?> dataTicket) {
                return this.getRenderState().hasGeckolibData(dataTicket);
            }
        }

        public static class CompileRenderLayers<T extends BlockEntity>
        extends Block<T> {
            public CompileRenderLayers(GeoBlockRenderer<T> renderer) {
                super(renderer, null);
            }

            @Override
            @ApiStatus.Internal
            public GeoRenderState getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            public void addLayer(GeoRenderLayer<T, Void, GeoRenderState> renderLayer) {
                ((GeoBlockRenderer)this.getRenderer()).addRenderLayer(renderLayer);
            }
        }
    }
}

