/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public final class AnimatableIdCache
extends SavedData {
    public static final SavedDataType<AnimatableIdCache> TYPE = new SavedDataType("geckolib_id_cache", AnimatableIdCache::new, AnimatableIdCache::codec, null);
    private long lastId;

    private static Codec<AnimatableIdCache> codec(SavedData.Context context) {
        return RecordCodecBuilder.create(builder -> builder.group((App)RecordCodecBuilder.point((Object)context.levelOrThrow()), (App)Codec.LONG.fieldOf("last_id").forGetter(cache -> cache.lastId)).apply((Applicative)builder, AnimatableIdCache::new));
    }

    private AnimatableIdCache(SavedData.Context context) {
        this(context.levelOrThrow(), 0L);
    }

    private AnimatableIdCache(ServerLevel level, long lastId) {
        this.lastId = lastId;
    }

    public static long getFreeId(ServerLevel level) {
        return AnimatableIdCache.getCache(level.getServer().overworld()).getNextId();
    }

    private long getNextId() {
        this.setDirty();
        return ++this.lastId;
    }

    private static AnimatableIdCache getCache(ServerLevel level) {
        return (AnimatableIdCache)level.getServer().overworld().getDataStorage().computeIfAbsent(TYPE);
    }
}

