/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable.processing;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Direction;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationProcessor;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.animatable.processing.AnimationTest;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.AnimationPoint;
import software.bernie.geckolib.animation.keyframe.BoneAnimation;
import software.bernie.geckolib.animation.keyframe.BoneAnimationQueue;
import software.bernie.geckolib.animation.keyframe.Keyframe;
import software.bernie.geckolib.animation.keyframe.KeyframeLocation;
import software.bernie.geckolib.animation.keyframe.KeyframeStack;
import software.bernie.geckolib.animation.keyframe.event.KeyFrameEvent;
import software.bernie.geckolib.animation.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.KeyFrameData;
import software.bernie.geckolib.animation.keyframe.event.data.ParticleKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.MolangQueries;
import software.bernie.geckolib.loading.math.value.Constant;
import software.bernie.geckolib.loading.math.value.Variable;
import software.bernie.geckolib.model.GeoModel;

public class AnimationController<T extends GeoAnimatable> {
    protected final String name;
    protected final AnimationStateHandler<T> stateHandler;
    protected final Map<String, BoneAnimationQueue> boneAnimationQueues = new Object2ObjectOpenHashMap();
    protected final Map<String, BoneSnapshot> boneSnapshots = new Object2ObjectOpenHashMap();
    protected Queue<AnimationProcessor.QueuedAnimation> animationQueue = new LinkedList<AnimationProcessor.QueuedAnimation>();
    protected boolean isJustStarting = false;
    protected boolean needsAnimationReload = false;
    protected boolean shouldResetTick = false;
    private boolean justStopped = true;
    protected boolean justStartedTransition = false;
    protected KeyframeEventHandler<T, SoundKeyframeData> soundKeyframeHandler = null;
    protected KeyframeEventHandler<T, ParticleKeyframeData> particleKeyframeHandler = null;
    protected KeyframeEventHandler<T, CustomInstructionKeyframeData> customKeyframeHandler = null;
    protected final Map<String, RawAnimation> triggerableAnimations = new Object2ObjectOpenHashMap(0);
    protected RawAnimation triggeredAnimation = null;
    protected boolean handlingTriggeredAnimations = false;
    protected double transitionLength;
    protected RawAnimation currentRawAnimation;
    protected AnimationProcessor.QueuedAnimation currentAnimation;
    protected State animationState = State.STOPPED;
    protected double tickOffset;
    protected double lastPollTime = -1.0;
    protected double animationSpeed = 1.0;
    protected Function<T, Double> animationSpeedModifier = animatable -> 1.0;
    protected Function<AnimationState<T>, EasingType> overrideEasingTypeFunction = animationState -> null;
    private final Set<KeyFrameData> executedKeyFrames = new ObjectOpenHashSet();
    protected GeoModel<T> currentModel;
    protected T currentAnimatable;
    protected double currentAnimationSeconds;
    protected PlayState nextPlaystate;
    protected AnimationState<T> currentAnimationState;
    protected double processedAnimationTick;

    public AnimationController(AnimationStateHandler<T> animationHandler) {
        this("base_controller", 0, animationHandler);
    }

    public AnimationController(String name, AnimationStateHandler<T> animationHandler) {
        this(name, 0, animationHandler);
    }

    public AnimationController(int transitionTickTime, AnimationStateHandler<T> animationHandler) {
        this("base_controller", transitionTickTime, animationHandler);
    }

    public AnimationController(String name, int transitionTickTime, AnimationStateHandler<T> animationHandler) {
        this.name = name;
        this.transitionLength = transitionTickTime;
        this.stateHandler = animationHandler;
    }

    public AnimationController<T> setSoundKeyframeHandler(KeyframeEventHandler<T, SoundKeyframeData> soundHandler) {
        this.soundKeyframeHandler = soundHandler;
        return this;
    }

    public AnimationController<T> setParticleKeyframeHandler(KeyframeEventHandler<T, ParticleKeyframeData> particleHandler) {
        this.particleKeyframeHandler = particleHandler;
        return this;
    }

    public AnimationController<T> setCustomInstructionKeyframeHandler(KeyframeEventHandler<T, CustomInstructionKeyframeData> customInstructionHandler) {
        this.customKeyframeHandler = customInstructionHandler;
        return this;
    }

    public AnimationController<T> setAnimationSpeedHandler(Function<T, Double> speedModFunction) {
        this.animationSpeedModifier = speedModFunction;
        return this;
    }

    public AnimationController<T> setAnimationSpeed(double speed) {
        return this.setAnimationSpeedHandler(animatable -> speed);
    }

    public AnimationController<T> setOverrideEasingType(EasingType easingTypeFunction) {
        return this.setOverrideEasingTypeFunction(animatable -> easingTypeFunction);
    }

    public AnimationController<T> setOverrideEasingTypeFunction(Function<AnimationState<T>, EasingType> easingType) {
        this.overrideEasingTypeFunction = easingType;
        return this;
    }

    public AnimationController<T> triggerableAnim(String name, RawAnimation animation) {
        this.triggerableAnimations.put(name, animation);
        return this;
    }

    public AnimationController<T> receiveTriggeredAnimations() {
        this.handlingTriggeredAnimations = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public AnimationProcessor.QueuedAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    @Nullable
    public RawAnimation getTriggeredAnimation() {
        return this.triggeredAnimation;
    }

    public State getAnimationState() {
        return this.animationState;
    }

    public Map<String, BoneAnimationQueue> getBoneAnimationQueues() {
        return this.boneAnimationQueues;
    }

    public double getCurrentAnimationSeconds() {
        return this.currentAnimationSeconds;
    }

    public double getAnimationSpeed() {
        return this.animationSpeed;
    }

    public void forceAnimationReset() {
        this.needsAnimationReload = true;
    }

    public void stop() {
        this.animationState = State.STOPPED;
    }

    public AnimationController<T> transitionLength(int ticks) {
        this.transitionLength = ticks;
        return this;
    }

    public boolean hasAnimationFinished() {
        return this.currentRawAnimation != null && this.animationState == State.STOPPED;
    }

    public RawAnimation getCurrentRawAnimation() {
        return this.currentRawAnimation;
    }

    public boolean isPlayingTriggeredAnimation() {
        return this.triggeredAnimation != null && !this.hasAnimationFinished();
    }

    public void setAnimationState(State state) {
        this.animationState = state;
    }

    public void setAnimation(RawAnimation rawAnimation) {
        if (rawAnimation == null || rawAnimation.getAnimationStages().isEmpty()) {
            this.stop();
            return;
        }
        if (this.needsAnimationReload || !rawAnimation.equals(this.currentRawAnimation)) {
            Queue<AnimationProcessor.QueuedAnimation> animations;
            if (this.currentModel != null && (animations = this.currentModel.getAnimationProcessor().buildAnimationQueue(this.currentAnimatable, rawAnimation)) != null) {
                this.animationQueue = animations;
                this.currentRawAnimation = rawAnimation;
                this.shouldResetTick = true;
                this.animationState = State.TRANSITIONING;
                this.justStartedTransition = true;
                this.needsAnimationReload = false;
                return;
            }
            this.stop();
        }
    }

    public boolean tryTriggerAnimation(String animName) {
        RawAnimation anim = this.triggerableAnimations.get(animName);
        if (anim == null) {
            return false;
        }
        this.triggeredAnimation = anim;
        if (this.animationState == State.STOPPED) {
            this.animationState = State.TRANSITIONING;
            this.shouldResetTick = true;
            this.justStartedTransition = true;
        }
        return true;
    }

    public boolean stopTriggeredAnimation() {
        if (this.triggeredAnimation == null) {
            return false;
        }
        if (this.currentRawAnimation == this.triggeredAnimation) {
            this.currentAnimation = null;
            this.currentRawAnimation = null;
        }
        this.triggeredAnimation = null;
        this.needsAnimationReload = true;
        return true;
    }

    public boolean isTriggeredAnimation(String animName) {
        return this.triggeredAnimation != null && this.triggeredAnimation.equals(this.triggerableAnimations.get(animName));
    }

    protected PlayState handleAnimationState(AnimationTest<T> animationTest) {
        if (this.triggeredAnimation != null) {
            if (this.currentRawAnimation != this.triggeredAnimation) {
                this.currentAnimation = null;
            }
            this.setAnimation(this.triggeredAnimation);
            if (!(this.hasAnimationFinished() || this.handlingTriggeredAnimations && this.stateHandler.handle(animationTest) != PlayState.CONTINUE)) {
                return PlayState.CONTINUE;
            }
            this.triggeredAnimation = null;
            this.needsAnimationReload = true;
        }
        return this.stateHandler.handle(animationTest);
    }

    public void prepareForRenderPass(T animatable, AnimatableManager<T> manager, MolangQueries.Actor<T> actor, Reference2DoubleMap<Variable> variables, double lerpedAnimationTick, GeoModel<T> model) {
        Set<Variable> usedVariables;
        this.isJustStarting = manager.isFirstTick();
        this.currentModel = model;
        this.currentAnimatable = animatable;
        this.animationSpeed = this.animationSpeedModifier.apply(animatable);
        this.processedAnimationTick = this.adjustTick(lerpedAnimationTick);
        if (this.animationState == State.TRANSITIONING && this.processedAnimationTick >= this.transitionLength) {
            this.shouldResetTick = true;
            this.animationState = State.RUNNING;
            this.processedAnimationTick = this.adjustTick(lerpedAnimationTick);
        }
        this.nextPlaystate = this.handleAnimationState(new AnimationTest<T>(animatable, actor.renderState(), manager, this));
        if (this.nextPlaystate != PlayState.STOP && !(usedVariables = this.getUsedVariables()).isEmpty()) {
            MolangQueries.buildActorVariables(actor, usedVariables, variables);
        }
    }

    protected Set<Variable> getUsedVariables() {
        AnimationProcessor.QueuedAnimation queuedAnimation;
        if (this.currentAnimation == null && this.animationQueue.isEmpty()) {
            return Set.of();
        }
        ObjectOpenHashSet usedVariables = new ObjectOpenHashSet();
        if (this.currentAnimation != null) {
            usedVariables.addAll(this.currentAnimation.animation().usedVariables());
        }
        if ((queuedAnimation = this.animationQueue.peek()) != null) {
            usedVariables.addAll(queuedAnimation.animation().usedVariables());
        }
        return usedVariables;
    }

    @ApiStatus.Internal
    public void beginTick(AnimationState<T> state, Map<String, GeoBone> bones, Map<String, BoneSnapshot> snapshots, double lerpedAnimationTick) {
        if (this.nextPlaystate == PlayState.STOP || this.currentAnimation == null && this.animationQueue.isEmpty()) {
            this.animationState = State.STOPPED;
            this.justStopped = true;
            return;
        }
        this.createInitialQueues(bones.values());
        if (this.justStartedTransition && (this.shouldResetTick || this.justStopped)) {
            this.justStopped = false;
            this.processedAnimationTick = this.adjustTick(lerpedAnimationTick);
            if (this.currentAnimation == null) {
                this.animationState = State.TRANSITIONING;
            }
        } else if (this.currentAnimation == null) {
            this.shouldResetTick = true;
            this.animationState = State.TRANSITIONING;
            this.justStartedTransition = true;
            this.needsAnimationReload = false;
            this.processedAnimationTick = this.adjustTick(lerpedAnimationTick);
        } else if (this.animationState != State.TRANSITIONING) {
            this.animationState = State.RUNNING;
        }
        if (this.getAnimationState() == State.RUNNING) {
            this.processCurrentAnimation(state, this.processedAnimationTick, lerpedAnimationTick);
        } else if (this.animationState == State.TRANSITIONING) {
            if (this.lastPollTime != lerpedAnimationTick && (this.processedAnimationTick == 0.0 || this.isJustStarting)) {
                this.justStartedTransition = false;
                this.lastPollTime = lerpedAnimationTick;
                this.currentAnimation = this.animationQueue.poll();
                this.resetEventKeyFrames();
                if (this.currentAnimation == null) {
                    return;
                }
                this.saveSnapshotsForAnimation(this.currentAnimation, snapshots);
            }
            if (this.currentAnimation != null) {
                this.currentAnimationSeconds = 0.0;
                for (BoneAnimation boneAnimation : this.currentAnimation.animation().boneAnimations()) {
                    BoneAnimationQueue boneAnimationQueue = this.boneAnimationQueues.get(boneAnimation.boneName());
                    BoneSnapshot boneSnapshot = this.boneSnapshots.get(boneAnimation.boneName());
                    GeoBone bone = bones.get(boneAnimation.boneName());
                    if (boneSnapshot == null || bone == null) continue;
                    KeyframeStack<Keyframe<MathValue>> rotationKeyFrames = boneAnimation.rotationKeyFrames();
                    KeyframeStack<Keyframe<MathValue>> positionKeyFrames = boneAnimation.positionKeyFrames();
                    KeyframeStack<Keyframe<MathValue>> scaleKeyFrames = boneAnimation.scaleKeyFrames();
                    if (!rotationKeyFrames.xKeyframes().isEmpty()) {
                        boneAnimationQueue.addNextRotation(null, this.processedAnimationTick, this.transitionLength, boneSnapshot, bone.getInitialSnapshot(), this.getAnimationPointAtTick(rotationKeyFrames.xKeyframes(), state, 0.0, true, Direction.Axis.X), this.getAnimationPointAtTick(rotationKeyFrames.yKeyframes(), state, 0.0, true, Direction.Axis.Y), this.getAnimationPointAtTick(rotationKeyFrames.zKeyframes(), state, 0.0, true, Direction.Axis.Z));
                    }
                    if (!positionKeyFrames.xKeyframes().isEmpty()) {
                        boneAnimationQueue.addNextPosition(null, this.processedAnimationTick, this.transitionLength, boneSnapshot, this.getAnimationPointAtTick(positionKeyFrames.xKeyframes(), state, 0.0, false, Direction.Axis.X), this.getAnimationPointAtTick(positionKeyFrames.yKeyframes(), state, 0.0, false, Direction.Axis.Y), this.getAnimationPointAtTick(positionKeyFrames.zKeyframes(), state, 0.0, false, Direction.Axis.Z));
                    }
                    if (scaleKeyFrames.xKeyframes().isEmpty()) continue;
                    boneAnimationQueue.addNextScale(null, this.processedAnimationTick, this.transitionLength, boneSnapshot, this.getAnimationPointAtTick(scaleKeyFrames.xKeyframes(), state, 0.0, false, Direction.Axis.X), this.getAnimationPointAtTick(scaleKeyFrames.yKeyframes(), state, 0.0, false, Direction.Axis.Y), this.getAnimationPointAtTick(scaleKeyFrames.zKeyframes(), state, 0.0, false, Direction.Axis.Z));
                }
            }
        }
    }

    @ApiStatus.Internal
    public void finishRenderPass() {
        this.currentModel = null;
        this.currentAnimationState = null;
        this.nextPlaystate = null;
    }

    private void processCurrentAnimation(AnimationState<T> animationState, double adjustedTick, double lerpedAnimationTick) {
        if (adjustedTick >= this.currentAnimation.animation().length()) {
            if (this.currentAnimation.loopType().shouldPlayAgain(animationState, this, this.currentAnimation.animation())) {
                if (this.animationState != State.PAUSED) {
                    this.shouldResetTick = true;
                    adjustedTick = this.adjustTick(lerpedAnimationTick);
                    this.resetEventKeyFrames();
                }
            } else {
                AnimationProcessor.QueuedAnimation nextAnimation = this.animationQueue.peek();
                this.resetEventKeyFrames();
                if (nextAnimation == null) {
                    this.animationState = State.STOPPED;
                    return;
                }
                this.animationState = State.TRANSITIONING;
                this.shouldResetTick = true;
                adjustedTick = this.adjustTick(lerpedAnimationTick);
                this.currentAnimation = this.animationQueue.poll();
            }
        }
        this.currentAnimationSeconds = adjustedTick / 20.0;
        for (BoneAnimation boneAnimation : this.currentAnimation.animation().boneAnimations()) {
            BoneAnimationQueue boneAnimationQueue = this.boneAnimationQueues.get(boneAnimation.boneName());
            if (boneAnimationQueue == null) continue;
            KeyframeStack<Keyframe<MathValue>> rotationKeyFrames = boneAnimation.rotationKeyFrames();
            KeyframeStack<Keyframe<MathValue>> positionKeyFrames = boneAnimation.positionKeyFrames();
            KeyframeStack<Keyframe<MathValue>> scaleKeyFrames = boneAnimation.scaleKeyFrames();
            if (!rotationKeyFrames.xKeyframes().isEmpty()) {
                boneAnimationQueue.addRotations(this.getAnimationPointAtTick(rotationKeyFrames.xKeyframes(), animationState, adjustedTick, true, Direction.Axis.X), this.getAnimationPointAtTick(rotationKeyFrames.yKeyframes(), animationState, adjustedTick, true, Direction.Axis.Y), this.getAnimationPointAtTick(rotationKeyFrames.zKeyframes(), animationState, adjustedTick, true, Direction.Axis.Z));
            }
            if (!positionKeyFrames.xKeyframes().isEmpty()) {
                boneAnimationQueue.addPositions(this.getAnimationPointAtTick(positionKeyFrames.xKeyframes(), animationState, adjustedTick, false, Direction.Axis.X), this.getAnimationPointAtTick(positionKeyFrames.yKeyframes(), animationState, adjustedTick, false, Direction.Axis.Y), this.getAnimationPointAtTick(positionKeyFrames.zKeyframes(), animationState, adjustedTick, false, Direction.Axis.Z));
            }
            if (scaleKeyFrames.xKeyframes().isEmpty()) continue;
            boneAnimationQueue.addScales(this.getAnimationPointAtTick(scaleKeyFrames.xKeyframes(), animationState, adjustedTick, false, Direction.Axis.X), this.getAnimationPointAtTick(scaleKeyFrames.yKeyframes(), animationState, adjustedTick, false, Direction.Axis.Y), this.getAnimationPointAtTick(scaleKeyFrames.zKeyframes(), animationState, adjustedTick, false, Direction.Axis.Z));
        }
        adjustedTick += this.transitionLength;
        for (SoundKeyframeData soundKeyframeData : this.currentAnimation.animation().keyframeMarkers().sounds()) {
            if (!(adjustedTick >= soundKeyframeData.getStartTick()) || !this.executedKeyFrames.add(soundKeyframeData)) continue;
            if (this.soundKeyframeHandler == null) {
                GeckoLibConstants.LOGGER.log(Level.WARN, "Sound Keyframe found for {} -> {}, but no keyframe handler registered", (Object)animationState.getData(DataTickets.ANIMATABLE_CLASS).getName(), (Object)this.getName());
                break;
            }
            this.soundKeyframeHandler.handle(new KeyFrameEvent<T, Object>(animationState, this, soundKeyframeData));
        }
        for (ParticleKeyframeData particleKeyframeData : this.currentAnimation.animation().keyframeMarkers().particles()) {
            if (!(adjustedTick >= particleKeyframeData.getStartTick()) || !this.executedKeyFrames.add(particleKeyframeData)) continue;
            if (this.particleKeyframeHandler == null) {
                GeckoLibConstants.LOGGER.log(Level.WARN, "Particle Keyframe found for {} -> {}, but no keyframe handler registered", (Object)animationState.getData(DataTickets.ANIMATABLE_CLASS).getName(), (Object)this.getName());
                break;
            }
            this.particleKeyframeHandler.handle(new KeyFrameEvent<T, Object>(animationState, this, particleKeyframeData));
        }
        for (CustomInstructionKeyframeData customInstructionKeyframeData : this.currentAnimation.animation().keyframeMarkers().customInstructions()) {
            if (!(adjustedTick >= customInstructionKeyframeData.getStartTick()) || !this.executedKeyFrames.add(customInstructionKeyframeData)) continue;
            if (this.customKeyframeHandler == null) {
                GeckoLibConstants.LOGGER.log(Level.WARN, "Custom Instruction Keyframe found for {} -> {}, but no keyframe handler registered", (Object)animationState.getData(DataTickets.ANIMATABLE_CLASS).getName(), (Object)this.getName());
                break;
            }
            this.customKeyframeHandler.handle(new KeyFrameEvent<T, Object>(animationState, this, customInstructionKeyframeData));
        }
        if (this.transitionLength == 0.0 && this.shouldResetTick && this.animationState == State.TRANSITIONING) {
            this.currentAnimation = this.animationQueue.poll();
        }
    }

    private void createInitialQueues(Collection<GeoBone> modelRendererList) {
        this.boneAnimationQueues.clear();
        for (GeoBone modelRenderer : modelRendererList) {
            this.boneAnimationQueues.put(modelRenderer.getName(), new BoneAnimationQueue(modelRenderer));
        }
    }

    private void saveSnapshotsForAnimation(AnimationProcessor.QueuedAnimation animation, Map<String, BoneSnapshot> snapshots) {
        block0: for (BoneSnapshot snapshot : snapshots.values()) {
            if (animation.animation().boneAnimations() == null) continue;
            for (BoneAnimation boneAnimation : animation.animation().boneAnimations()) {
                if (!boneAnimation.boneName().equals(snapshot.getBone().getName())) continue;
                this.boneSnapshots.put(boneAnimation.boneName(), BoneSnapshot.copy(snapshot));
                continue block0;
            }
        }
    }

    protected double adjustTick(double tick) {
        if (!this.shouldResetTick) {
            return this.animationSpeed * Math.max(tick - this.tickOffset, 0.0);
        }
        if (this.getAnimationState() != State.STOPPED) {
            this.tickOffset = tick;
        }
        this.shouldResetTick = false;
        return 0.0;
    }

    private AnimationPoint getAnimationPointAtTick(List<Keyframe<MathValue>> frames, AnimationState<?> animationState, double tick, boolean isRotation, Direction.Axis axis) {
        KeyframeLocation<Keyframe<MathValue>> location = this.getCurrentKeyFrameLocation(frames, tick);
        Keyframe<MathValue> currentFrame = location.keyframe();
        double startValue = currentFrame.startValue().get(animationState);
        double endValue = currentFrame.endValue().get(animationState);
        if (isRotation) {
            if (!(currentFrame.startValue() instanceof Constant)) {
                startValue = Math.toRadians(startValue);
                if (axis == Direction.Axis.X || axis == Direction.Axis.Y) {
                    startValue *= -1.0;
                }
            }
            if (!(currentFrame.endValue() instanceof Constant)) {
                endValue = Math.toRadians(endValue);
                if (axis == Direction.Axis.X || axis == Direction.Axis.Y) {
                    endValue *= -1.0;
                }
            }
        }
        return new AnimationPoint(currentFrame, location.startTick(), currentFrame.length(), startValue, endValue);
    }

    private KeyframeLocation<Keyframe<MathValue>> getCurrentKeyFrameLocation(List<Keyframe<MathValue>> frames, double ageInTicks) {
        double totalFrameTime = 0.0;
        for (Keyframe<MathValue> frame : frames) {
            if (!((totalFrameTime += frame.length()) > ageInTicks)) continue;
            return new KeyframeLocation<Keyframe<MathValue>>(frame, ageInTicks - (totalFrameTime - frame.length()));
        }
        return new KeyframeLocation<Keyframe<MathValue>>(frames.getLast(), ageInTicks);
    }

    private void resetEventKeyFrames() {
        this.executedKeyFrames.clear();
    }

    @FunctionalInterface
    public static interface AnimationStateHandler<A extends GeoAnimatable> {
        public PlayState handle(AnimationTest<A> var1);
    }

    @FunctionalInterface
    public static interface KeyframeEventHandler<A extends GeoAnimatable, E extends KeyFrameData> {
        public void handle(KeyFrameEvent<A, E> var1);
    }

    public static enum State {
        RUNNING,
        TRANSITIONING,
        PAUSED,
        STOPPED;

    }
}

