/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.items;

import de.maxhenkel.easypiglins.blocks.BartererBlock;
import de.maxhenkel.easypiglins.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easypiglins.corelib.CachedMap;
import de.maxhenkel.easypiglins.corelib.codec.ValueInputOutputUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;

public class BlockItemDataCache {
    private static final CachedMap<CustomData, FakeWorldTileentity> CACHE = new CachedMap(10000L);

    @Nullable
    public static <T extends FakeWorldTileentity> T get(Level level, ItemStack stack, Class<T> beClass) {
        FakeWorldTileentity fakeWorldTileentity = BlockItemDataCache.get(level, stack);
        if (!beClass.isInstance((Object)fakeWorldTileentity)) {
            return null;
        }
        return (T)((Object)((FakeWorldTileentity)((Object)beClass.cast((Object)fakeWorldTileentity))));
    }

    @Nullable
    public static FakeWorldTileentity get(Level level, ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data == null) {
            return null;
        }
        return CACHE.get(data, () -> BlockItemDataCache.load(level, stack, data));
    }

    private static FakeWorldTileentity load(Level level, ItemStack stack, CustomData data) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            throw new IllegalArgumentException("Item is not a block item");
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        if (!(block instanceof BartererBlock)) {
            throw new IllegalArgumentException("Item is not a villager block");
        }
        BartererBlock bartererBlock = (BartererBlock)block;
        BlockEntity blockEntity = bartererBlock.newBlockEntity(BlockPos.ZERO, bartererBlock.defaultBlockState());
        if (!(blockEntity instanceof FakeWorldTileentity)) {
            throw new IllegalArgumentException("Item is no fake world block entity");
        }
        FakeWorldTileentity fakeWorldTileentity = (FakeWorldTileentity)blockEntity;
        fakeWorldTileentity.setFakeWorld(level);
        if (data != null) {
            fakeWorldTileentity.loadCustomOnly((ValueInput)ValueInputOutputUtils.createValueInput(fakeWorldTileentity, (HolderLookup.Provider)level.registryAccess(), data.copyTag()));
        }
        return fakeWorldTileentity;
    }
}

