/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.integration.waila;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.DeathHistoryScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerCorpse
implements IEntityComponentProvider {
    public static final ResourceLocation OBJECT_NAME_TAG = ResourceLocation.fromNamespaceAndPath((String)"jade", (String)"object_name");
    public static final HUDHandlerCorpse INSTANCE = new HUDHandlerCorpse();
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"corpse", (String)"corpse");

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof CorpseEntity) {
            CorpseEntity corpse = (CorpseEntity)entity;
            iTooltip.remove(OBJECT_NAME_TAG);
            iTooltip.add((Component)corpse.getDisplayName().copy().withStyle(ChatFormatting.WHITE));
            CompoundTag data = entityAccessor.getServerData();
            data.getCompound("Death").ifPresent(deathTag -> {
                Death death = Death.read((HolderLookup.Provider)corpse.registryAccess(), deathTag);
                long timestamp = death.getTimestamp();
                if (timestamp > 0L) {
                    iTooltip.add((Component)Component.translatable((String)"tooltip.corpse.death_date", (Object[])new Object[]{DeathHistoryScreen.getDate(timestamp)}));
                }
            });
            if (data.contains("ItemCount")) {
                iTooltip.add((Component)Component.translatable((String)"tooltip.corpse.item_count", (Object[])new Object[]{data.getIntOr("ItemCount", 0)}));
            }
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

