/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import de.maxhenkel.corpse.CorpseMod;
import de.maxhenkel.corpse.corelib.CachedMap;
import de.maxhenkel.corpse.corelib.FontColorUtils;
import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.entities.DummyPlayer;
import de.maxhenkel.corpse.gui.ScreenBase;
import de.maxhenkel.corpse.integration.openhud.OpenHudIntegration;
import de.maxhenkel.corpse.net.MessageShowCorpseInventory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class DeathHistoryScreen
extends ScreenBase {
    private static final ResourceLocation DEATH_HISTORY_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"corpse", (String)"textures/gui/gui_death_history.png");
    private static final Component TITLE = Component.translatable((String)"gui.corpse.death_history.title").withStyle(ChatFormatting.BLACK);
    private static final Component TELEPORT = Component.translatable((String)"tooltip.corpse.teleport");
    private static final Component DIMENSION = Component.translatable((String)"gui.corpse.death_history.dimension");
    private final CachedMap<Death, DummyPlayer> players = new CachedMap(10000L);
    private Button previous;
    @Nullable
    private Button waypoint;
    private Button showItems;
    private Button next;
    private final List<Death> deaths;
    private final int hSplit;
    private int index;
    private static boolean errorShown;

    public DeathHistoryScreen(List<Death> deaths) {
        super(TITLE);
        this.deaths = deaths;
        this.index = 0;
        this.texture = DEATH_HISTORY_GUI_TEXTURE;
        this.xSize = 248;
        this.ySize = 166;
        this.hSplit = this.xSize / 2;
    }

    @Override
    protected void init() {
        super.init();
        int padding = 7;
        int buttonLayoutWidth = this.xSize - padding * 2;
        this.previous = Button.builder((Component)Component.literal((String)"\u2190"), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = 0;
            }
            this.checkButtons();
        }).build();
        if (OpenHudIntegration.isLoaded()) {
            this.waypoint = Button.builder((Component)Component.translatable((String)"button.corpse.add_waypoint"), button -> {
                ResourceLocation dim = ResourceLocation.tryParse((String)this.getCurrentDeath().getDimension());
                ResourceKey dimension = dim != null ? ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dim) : null;
                OpenHudIntegration.openWaypointScreen(this, (ResourceKey<Level>)dimension, this.getCurrentDeath().getBlockPos());
            }).build();
        }
        this.showItems = Button.builder((Component)Component.translatable((String)"button.corpse.show_items"), button -> ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageShowCorpseInventory(this.getCurrentDeath().getPlayerUUID(), this.getCurrentDeath().getId()), (CustomPacketPayload[])new CustomPacketPayload[0])).build();
        this.next = Button.builder((Component)Component.literal((String)"\u2192"), button -> {
            ++this.index;
            if (this.index >= this.deaths.size()) {
                this.index = this.deaths.size() - 1;
            }
            this.checkButtons();
        }).build();
        LinearLayout buttonLayout = LinearLayout.horizontal().spacing(2);
        this.previous.setWidth(20);
        buttonLayout.addChild((LayoutElement)this.previous);
        int buttonWidth = buttonLayoutWidth - 40 - 4;
        if (this.waypoint != null) {
            buttonWidth = buttonWidth / 2 - 1;
            this.waypoint.setWidth(buttonWidth);
            buttonLayout.addChild((LayoutElement)this.waypoint);
        }
        this.showItems.setWidth(buttonWidth);
        buttonLayout.addChild((LayoutElement)this.showItems);
        this.next.setWidth(20);
        buttonLayout.addChild((LayoutElement)this.next);
        buttonLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        buttonLayout.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)buttonLayout, (int)(this.guiLeft + padding), (int)(this.guiTop + this.ySize - padding - 20), (int)buttonLayoutWidth, (int)20, (float)0.0f, (float)0.0f);
        this.checkButtons();
    }

    public boolean mouseClicked(double x, double y, int clickType) {
        if (x >= (double)(this.guiLeft + 7) && x <= (double)(this.guiLeft + this.hSplit) && y >= (double)(this.guiTop + 70)) {
            Objects.requireNonNull(this.font);
            if (y <= (double)(this.guiTop + 100 + 9)) {
                this.onTeleportClick();
            }
        }
        return super.mouseClicked(x, y, clickType);
    }

    private void onTeleportClick() {
        BlockPos pos = this.getCurrentDeath().getBlockPos();
        MutableComponent teleport = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()})).withStyle(style -> style.applyFormat(ChatFormatting.GREEN).withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/execute in " + this.getCurrentDeath().getDimension() + " run tp @s " + pos.getX() + " " + pos.getY() + " " + pos.getZ())).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"chat.coordinates.tooltip"))));
        this.minecraft.gui.getChat().addMessage((Component)Component.translatable((String)"chat.corpse.teleport_death_location", (Object[])new Object[]{teleport}));
        this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        this.minecraft.setScreen(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        Death death = this.getCurrentDeath();
        this.drawCenteredString(guiGraphics, this.title, this.guiLeft + this.xSize / 2, this.guiTop + 7, FontColorUtils.getFontColor(ChatFormatting.BLACK));
        MutableComponent date = Component.literal((String)DeathHistoryScreen.getDate(death.getTimestamp()).getString()).withStyle(ChatFormatting.DARK_GRAY);
        this.drawCenteredString(guiGraphics, (Component)date, this.guiLeft + this.xSize / 2, this.guiTop + 20, FontColorUtils.getFontColor(ChatFormatting.BLACK));
        this.drawLeft(guiGraphics, Component.translatable((String)"gui.corpse.death_history.name").append((Component)Component.literal((String)":")).withStyle(ChatFormatting.DARK_GRAY), this.guiTop + 40);
        this.drawRight(guiGraphics, Component.literal((String)death.getPlayerName()).withStyle(ChatFormatting.GRAY), this.guiTop + 40);
        MutableComponent dimension = Component.translatable((String)"gui.corpse.death_history.dimension").append((Component)Component.literal((String)":")).withStyle(ChatFormatting.DARK_GRAY);
        this.drawLeft(guiGraphics, dimension, this.guiTop + 55);
        String dimensionName = death.getDimension().split(":")[1];
        boolean shortened = false;
        int dimWidth = this.font.width((FormattedText)dimension);
        while (dimWidth + this.font.width(dimensionName + (shortened ? "..." : "")) >= this.hSplit - 7) {
            dimensionName = dimensionName.substring(0, dimensionName.length() - 1);
            shortened = true;
        }
        this.drawRight(guiGraphics, Component.translatable((String)(dimensionName + (shortened ? "..." : ""))).withStyle(ChatFormatting.GRAY), this.guiTop + 55);
        this.drawLeft(guiGraphics, Component.translatable((String)"gui.corpse.death_history.location").append((Component)Component.literal((String)":")).withStyle(ChatFormatting.DARK_GRAY), this.guiTop + 70);
        this.drawRight(guiGraphics, Component.literal((String)(death.getBlockPos().getX() + " X")).withStyle(ChatFormatting.GRAY), this.guiTop + 70);
        this.drawRight(guiGraphics, Component.literal((String)(death.getBlockPos().getY() + " Y")).withStyle(ChatFormatting.GRAY), this.guiTop + 85);
        this.drawRight(guiGraphics, Component.literal((String)(death.getBlockPos().getZ() + " Z")).withStyle(ChatFormatting.GRAY), this.guiTop + 100);
        DummyPlayer dummyPlayer = this.players.get(death, () -> new DummyPlayer(this.minecraft.level, new GameProfile(death.getPlayerUUID(), death.getPlayerName()), death.getEquipment(), death.getModel()));
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)((int)((float)this.guiLeft + (float)this.xSize * 0.75f - 45.0f)), (int)(this.guiTop + 25), (int)((int)((float)this.guiLeft + (float)this.xSize * 0.75f + 45.0f)), (int)(this.guiTop + 140), (int)50, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)dummyPlayer);
        if (mouseX >= this.guiLeft + 7 && mouseX <= this.guiLeft + this.hSplit && mouseY >= this.guiTop + 70) {
            Objects.requireNonNull(this.font);
            if (mouseY <= this.guiTop + 100 + 9) {
                guiGraphics.setTooltipForNextFrame(this.font, TELEPORT, mouseX, mouseY);
                return;
            }
        }
        if (mouseX < this.guiLeft + 7) return;
        if (mouseX > this.guiLeft + this.hSplit) return;
        if (mouseY < this.guiTop + 55) return;
        Objects.requireNonNull(this.font);
        if (mouseY > this.guiTop + 55 + 9) return;
        guiGraphics.setTooltipForNextFrame(this.font, (List)Lists.newArrayList((Object[])new Component[]{DIMENSION, Component.literal((String)death.getDimension()).withStyle(ChatFormatting.GRAY)}), Optional.empty(), mouseX, mouseY);
    }

    public static Component getDate(long timestamp) {
        SimpleDateFormat dateFormat;
        try {
            dateFormat = new SimpleDateFormat(Component.translatable((String)"gui.corpse.death_history.date_format").getString());
        }
        catch (Exception e) {
            if (!errorShown) {
                CorpseMod.LOGGER.error("Failed to create date format. This indicates a broken translation: 'gui.corpse.death_history.date_format' translated to {}", (Object)Component.translatable((String)"gui.corpse.death_history.date_format").getString());
                errorShown = true;
            }
            dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
        return Component.literal((String)dateFormat.format(new Date(timestamp)));
    }

    private void checkButtons() {
        this.previous.active = this.index > 0;
        this.next.active = this.index < this.deaths.size() - 1;
    }

    public void drawLeft(GuiGraphics guiGraphics, MutableComponent text, int height) {
        guiGraphics.drawString(this.font, (Component)text, this.guiLeft + 7, height, FontColorUtils.getFontColor(ChatFormatting.BLACK), false);
    }

    public void drawRight(GuiGraphics guiGraphics, MutableComponent text, int height) {
        guiGraphics.drawString(this.font, (Component)text, this.guiLeft + this.hSplit - this.font.width((FormattedText)text), height, FontColorUtils.getFontColor(ChatFormatting.BLACK), false);
    }

    public Death getCurrentDeath() {
        return this.deaths.get(this.index);
    }
}

