/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.CorpseMod;
import de.maxhenkel.corpse.corelib.inventory.ItemListInventory;
import de.maxhenkel.corpse.corelib.inventory.LockedSlot;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import de.maxhenkel.corpse.gui.Guis;
import de.maxhenkel.corpse.gui.ITransferrable;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class CorpseInventoryContainer
extends CorpseContainerBase
implements ITransferrable {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private ItemListInventory mainInventory;
    private ItemListInventory armorInventory;
    private ItemListInventory offHandInventory;

    public CorpseInventoryContainer(int id, Inventory playerInventory, CorpseEntity corpse, boolean editable, boolean history) {
        super((MenuType)CorpseMod.CONTAINER_TYPE_CORPSE_INVENTORY.get(), id, playerInventory, corpse, editable, history);
        int k;
        this.mainInventory = new ItemListInventory(corpse.getDeath().getMainInventory());
        this.armorInventory = new ItemListInventory(corpse.getDeath().getArmorInventory());
        this.offHandInventory = new ItemListInventory(corpse.getDeath().getOffHandInventory());
        for (int i = 0; i < 4; ++i) {
            final int slotIndex = 3 - i;
            this.addSlot(new LockedSlot(this, this.armorInventory, slotIndex, 8 + i * 18, 18, true, !editable){

                public ResourceLocation getNoItemIcon() {
                    return ARMOR_SLOT_TEXTURES[slotIndex];
                }
            });
        }
        this.addSlot(new LockedSlot(this, this.offHandInventory, 0, 98, 18, true, !editable){

            public ResourceLocation getNoItemIcon() {
                return InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD;
            }
        });
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new LockedSlot(this.mainInventory, j + k * 9 + 9, 8 + j * 18, 40 + k * 18, true, !editable));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.addSlot(new LockedSlot(this.mainInventory, k, 8 + k * 18, 98, true, !editable));
        }
        this.addPlayerInventorySlots();
    }

    @Override
    public void transferItems() {
        if (!this.isEditable()) {
            return;
        }
        if (!(this.playerInventory.player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)this.playerInventory.player;
        NonNullList additionalItems = NonNullList.create();
        this.fillInventory((List<ItemStack>)additionalItems, this.mainInventory, (NonNullList<ItemStack>)this.playerInventory.getNonEquipmentItems());
        this.fillInventoryEquipment((Player)player, (List<ItemStack>)additionalItems, this.armorInventory, EquipmentSlot.FEET);
        this.fillInventoryEquipment((Player)player, (List<ItemStack>)additionalItems, this.armorInventory, EquipmentSlot.LEGS);
        this.fillInventoryEquipment((Player)player, (List<ItemStack>)additionalItems, this.armorInventory, EquipmentSlot.CHEST);
        this.fillInventoryEquipment((Player)player, (List<ItemStack>)additionalItems, this.armorInventory, EquipmentSlot.HEAD);
        this.fillInventoryEquipment((Player)player, (List<ItemStack>)additionalItems, this.offHandInventory, EquipmentSlot.OFFHAND, 0);
        additionalItems.addAll(this.corpse.getDeath().getAdditionalItems());
        NonNullList restItems = NonNullList.create();
        for (ItemStack stack : additionalItems) {
            if (player.getInventory().add(stack)) continue;
            restItems.add((Object)stack);
        }
        this.corpse.getDeath().getAdditionalItems().clear();
        this.corpse.getDeath().getAdditionalItems().addAll((Collection)restItems);
        if (!this.corpse.getDeath().getAdditionalItems().isEmpty()) {
            Guis.openAdditionalItems(player, this);
        }
    }

    public void fillInventoryEquipment(Player player, List<ItemStack> additionalItems, ItemListInventory inventory, EquipmentSlot slot) {
        this.fillInventoryEquipment(player, additionalItems, inventory, slot, -1);
    }

    public void fillInventoryEquipment(Player player, List<ItemStack> additionalItems, ItemListInventory inventory, EquipmentSlot slot, int overrideIndex) {
        ItemStack item = inventory.getItem(overrideIndex < 0 ? slot.getIndex() : overrideIndex);
        if (item.isEmpty()) {
            return;
        }
        ItemStack oldPlayerItem = player.getItemBySlot(slot);
        if (!oldPlayerItem.isEmpty()) {
            additionalItems.add(oldPlayerItem);
        }
        inventory.setItem(overrideIndex < 0 ? slot.getIndex() : overrideIndex, ItemStack.EMPTY);
        player.setItemSlot(slot, item);
    }

    private void fillInventory(List<ItemStack> additionalItems, Container inventory, NonNullList<ItemStack> playerInv) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            ItemStack playerStack = (ItemStack)playerInv.get(i);
            if (!playerStack.isEmpty()) {
                additionalItems.add(playerStack);
            }
            inventory.setItem(i, ItemStack.EMPTY);
            playerInv.set(i, (Object)stack);
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.corpse.isMainInventoryEmpty() && !this.corpse.isAdditionalInventoryEmpty() && this.playerInventory.player instanceof ServerPlayer) {
            Guis.openAdditionalItems((ServerPlayer)this.playerInventory.player, this);
        }
    }

    @Override
    public int getInvOffset() {
        return 79;
    }

    @Override
    public int getInventorySize() {
        return 41;
    }
}

