/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import de.maxhenkel.corpse.CorpseMod;
import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.entities.CorpseBoundingBoxBase;
import de.maxhenkel.corpse.gui.Guis;
import de.maxhenkel.corpse.net.MessageSpawnDeathParticles;
import java.util.EnumMap;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class CorpseEntity
extends CorpseBoundingBoxBase {
    private static final EntityDataAccessor<UUID> ID = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)((EntityDataSerializer)CorpseMod.UUID_SERIALIZER.get()));
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> SKELETON = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> MODEL = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<EnumMap<EquipmentSlot, ItemStack>> EQUIPMENT = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)((EntityDataSerializer)CorpseMod.EQUIPMENT_SERIALIZER.get()));
    private int age;
    private int emptyAge;
    protected Death death;

    public CorpseEntity(EntityType type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
        this.emptyAge = -1;
        this.death = new Death.Builder(new UUID(0L, 0L), new UUID(0L, 0L)).build();
    }

    public CorpseEntity(Level world) {
        this((EntityType)CorpseMod.CORPSE_ENTITY_TYPE.get(), world);
    }

    public static CorpseEntity createFromDeath(Player player, Death death) {
        CorpseEntity corpse = new CorpseEntity(player.level());
        corpse.death = death;
        corpse.setPlayerUuid(death.getPlayerUUID());
        corpse.setCorpseName(death.getPlayerName());
        corpse.setEquipment(death.getEquipment());
        corpse.setPos(death.getPosX(), Math.max(death.getPosY(), (double)player.level().getMinY()), death.getPosZ());
        corpse.setYRot(player.getYRot());
        corpse.setCorpseModel(death.getModel());
        return corpse;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            double yMotion = 0.0;
            Vec3 motion = this.getDeltaMovement();
            if (this.isEyeInFluid(FluidTags.WATER) || this.isEyeInFluid(FluidTags.LAVA)) {
                yMotion = motion.y < 0.0 ? motion.y + (motion.y < 0.03 ? 0.01 : 0.0) : motion.y + (motion.y < 0.03 ? 5.0E-4 : 0.0);
            } else if (((Boolean)CorpseMod.SERVER_CONFIG.fallIntoVoid.get()).booleanValue() || this.getY() > (double)this.level().getMinY()) {
                yMotion = Math.max(-2.0, motion.y - 0.0625);
            }
            this.setDeltaMovement(this.getDeltaMovement().x * 0.75, yMotion, this.getDeltaMovement().z * 0.75);
            if (!((Boolean)CorpseMod.SERVER_CONFIG.fallIntoVoid.get()).booleanValue() && this.getY() < (double)this.level().getMinY()) {
                this.teleportTo(this.getX(), this.level().getMinY(), this.getZ());
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        if (this.level().isClientSide) {
            return;
        }
        ++this.age;
        this.setIsSkeleton(this.age >= (Integer)CorpseMod.SERVER_CONFIG.corpseSkeletonTime.get());
        if ((Integer)CorpseMod.SERVER_CONFIG.corpseForceDespawnTime.get() > 0 && this.age > (Integer)CorpseMod.SERVER_CONFIG.corpseForceDespawnTime.get()) {
            this.discard();
            return;
        }
        boolean empty = this.isEmpty();
        if (empty && this.emptyAge < 0) {
            this.emptyAge = this.age;
        } else if (empty && this.age - this.emptyAge >= (Integer)CorpseMod.SERVER_CONFIG.corpseDespawnTime.get()) {
            this.discard();
        }
    }

    public boolean isMainInventoryEmpty() {
        return this.death.getMainInventory().stream().allMatch(ItemStack::isEmpty) && this.death.getArmorInventory().stream().allMatch(ItemStack::isEmpty) && this.death.getOffHandInventory().stream().allMatch(ItemStack::isEmpty);
    }

    public boolean isAdditionalInventoryEmpty() {
        return this.death.getAdditionalItems().stream().allMatch(ItemStack::isEmpty);
    }

    public boolean isEmpty() {
        return this.isMainInventoryEmpty() && this.isAdditionalInventoryEmpty();
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        if (((Boolean)CorpseMod.SERVER_CONFIG.lavaDamage.get()).booleanValue() && source.is(DamageTypeTags.IS_FIRE) && amount >= 2.0f) {
            this.discard();
            return true;
        }
        return false;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.level().isClientSide && player instanceof ServerPlayer) {
            ServerPlayer playerMP = (ServerPlayer)player;
            if (((Boolean)CorpseMod.SERVER_CONFIG.onlyOwnerAccess.get()).booleanValue()) {
                boolean isOp = playerMP.hasPermissions(playerMP.getServer().getOperatorUserPermissionLevel());
                if (isOp || playerMP.getUUID().equals(this.getPlayerUuid())) {
                    Guis.openCorpseGUI((ServerPlayer)player, this);
                } else if (((Boolean)CorpseMod.SERVER_CONFIG.skeletonAccess.get()).booleanValue() && this.isSkeleton()) {
                    Guis.openCorpseGUI((ServerPlayer)player, this);
                }
            } else {
                Guis.openCorpseGUI((ServerPlayer)player, this);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Component getDisplayName() {
        String name = this.getCorpseName();
        if (name == null || name.trim().isEmpty()) {
            return super.getDisplayName();
        }
        return Component.translatable((String)"entity.corpse.corpse_of", (Object[])new Object[]{this.getCorpseName()});
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public UUID getPlayerUuid() {
        return (UUID)this.entityData.get(ID);
    }

    public void setPlayerUuid(UUID uuid) {
        this.entityData.set(ID, (Object)uuid);
    }

    public Death getDeath() {
        return this.death;
    }

    public void setDeath(Death death) {
        this.death = death;
    }

    public String getCorpseName() {
        return (String)this.entityData.get(NAME);
    }

    public void setCorpseName(String name) {
        this.entityData.set(NAME, (Object)name);
    }

    public boolean isSkeleton() {
        return (Boolean)this.entityData.get(SKELETON);
    }

    public void setIsSkeleton(boolean skeleton) {
        this.entityData.set(SKELETON, (Object)skeleton);
    }

    public byte getCorpseModel() {
        return (Byte)this.entityData.get(MODEL);
    }

    public void setCorpseModel(byte model) {
        this.entityData.set(MODEL, (Object)model);
    }

    public void setEquipment(EnumMap<EquipmentSlot, ItemStack> equipment) {
        this.entityData.set(EQUIPMENT, equipment);
    }

    public EnumMap<EquipmentSlot, ItemStack> getEquipment() {
        return (EnumMap)this.entityData.get(EQUIPMENT);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ID, (Object)Util.NIL_UUID);
        builder.define(NAME, (Object)"");
        builder.define(SKELETON, (Object)false);
        builder.define(MODEL, (Object)0);
        builder.define(EQUIPMENT, new EnumMap(EquipmentSlot.class));
    }

    public void remove(Entity.RemovalReason reason) {
        for (ItemStack item : this.death.getAllItems()) {
            Containers.dropItemStack((Level)this.level(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)item);
        }
        super.remove(reason);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getPlayers(player -> player.distanceToSqr(this.getX(), this.getY(), this.getZ()) <= 4096.0).forEach(playerEntity -> PacketDistributor.sendToPlayer((ServerPlayer)playerEntity, (CustomPacketPayload)new MessageSpawnDeathParticles(this.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    public void spawnDeathParticles() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Vec3 lookVec = this.getLookAngle().normalize();
        for (int i = 0; i <= 10; ++i) {
            double d = ((double)i / 10.0 - 0.5) * 2.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x + lookVec.x * d + (this.level().random.nextDouble() - 0.5), y + 0.25, z + lookVec.z * d + (this.level().random.nextDouble() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        this.death = Death.read(valueInput, "Death");
        this.setEquipment(this.death.getEquipment());
        this.setPlayerUuid(this.death.getPlayerUUID());
        this.setCorpseName(this.death.getPlayerName());
        this.setCorpseModel(this.death.getModel());
        this.age = valueInput.getIntOr("Age", 0);
        this.emptyAge = valueInput.getIntOr("EmptyAge", -1);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        this.death.write(valueOutput, "Death");
        valueOutput.putInt("Age", this.age);
        if (this.emptyAge >= 0) {
            valueOutput.putInt("EmptyAge", this.emptyAge);
        }
    }
}

