/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.salju.kobolds.block.KoboldSkull;
import net.salju.kobolds.block.KoboldWallSkull;
import net.salju.kobolds.block.KoboldWitherSkull;
import net.salju.kobolds.block.KoboldWitherWallSkull;

@EventBusSubscriber
public class KoboldsBlocks {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.createBlocks((String)"kobolds");
    public static final DeferredHolder<Block, Block> KOBOLD_SKULL = REGISTRY.register("kobold_skull", () -> new KoboldSkull(KoboldSkull.Types.SKELEBOLD, KoboldsBlocks.createBaseProps("kobold_skull").instrument(NoteBlockInstrument.SKELETON).mapColor(MapColor.NONE).sound(SoundType.BONE_BLOCK).strength(1.0f).pushReaction(PushReaction.DESTROY).randomTicks()));
    public static final DeferredHolder<Block, Block> KOBOLD_SKULL_WALL = REGISTRY.register("kobold_skull_wall", () -> new KoboldWallSkull(KoboldSkull.Types.SKELEBOLD, KoboldsBlocks.createBaseProps("kobold_skull_wall").mapColor(MapColor.NONE).sound(SoundType.BONE_BLOCK).strength(1.0f).pushReaction(PushReaction.DESTROY).randomTicks()));
    public static final DeferredHolder<Block, Block> KOBOLD_WITHER_SKULL = REGISTRY.register("kobold_wither_skull", () -> new KoboldWitherSkull(KoboldWitherSkull.Types.WITHERBOLD, KoboldsBlocks.createBaseProps("kobold_wither_skull").instrument(NoteBlockInstrument.WITHER_SKELETON).mapColor(MapColor.NONE).sound(SoundType.BONE_BLOCK).strength(1.0f).pushReaction(PushReaction.DESTROY).randomTicks()));
    public static final DeferredHolder<Block, Block> KOBOLD_WITHER_SKULL_WALL = REGISTRY.register("kobold_wither_skull_wall", () -> new KoboldWitherWallSkull(KoboldWitherSkull.Types.WITHERBOLD, KoboldsBlocks.createBaseProps("kobold_wither_skull_wall").mapColor(MapColor.NONE).sound(SoundType.BONE_BLOCK).strength(1.0f).pushReaction(PushReaction.DESTROY).randomTicks()));

    public static BlockBehaviour.Properties createBaseProps(String name) {
        return BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)name)));
    }

    @SubscribeEvent
    public static void onBlockEntityValidBlocks(BlockEntityTypeAddBlocksEvent event) {
        event.modify(BlockEntityType.SKULL, new Block[]{(Block)KOBOLD_SKULL.get()});
        event.modify(BlockEntityType.SKULL, new Block[]{(Block)KOBOLD_SKULL_WALL.get()});
        event.modify(BlockEntityType.SKULL, new Block[]{(Block)KOBOLD_WITHER_SKULL.get()});
        event.modify(BlockEntityType.SKULL, new Block[]{(Block)KOBOLD_WITHER_SKULL_WALL.get()});
    }
}

