/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.salju.kobolds.Kobolds;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsMobs;

public class KoboldWarriorGoal
extends Goal {
    public final AbstractKoboldEntity kobold;

    public KoboldWarriorGoal(AbstractKoboldEntity kobold) {
        this.kobold = kobold;
    }

    public boolean canUse() {
        return this.isHoldingAxe();
    }

    public void start() {
        this.kobold.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 600, 10, false, false));
        Kobolds.queueServerWork(600, () -> {
            InteractionHand hand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.kobold, item -> item instanceof AxeItem);
            ItemStack weapon = hand.equals((Object)InteractionHand.MAIN_HAND) ? this.kobold.getOffhandItem() : this.kobold.getMainHandItem();
            ItemStack axe = this.kobold.getItemInHand(hand);
            Level patt0$temp = this.kobold.level();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)patt0$temp;
                ItemEntity drop = new ItemEntity((Level)lvl, this.kobold.getX(), this.kobold.getY(), this.kobold.getZ(), weapon);
                drop.setPickUpDelay(10);
                lvl.addFreshEntity((Entity)drop);
                if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                    ItemEntity primary = new ItemEntity((Level)lvl, this.kobold.getX(), this.kobold.getY(), this.kobold.getZ(), this.kobold.getPrimary());
                    drop.setPickUpDelay(10);
                    lvl.addFreshEntity((Entity)primary);
                }
                this.kobold.setItemSlot(EquipmentSlot.MAINHAND, axe);
                this.kobold.setDropChance(EquipmentSlot.MAINHAND, 1.0f);
                this.kobold.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
                this.kobold.updateItemData();
                this.kobold.convertTo((EntityType)KoboldsMobs.KOBOLD_WARRIOR.get(), ConversionParams.single((Mob)this.kobold, (boolean)true, (boolean)true), newbie -> EventHooks.onLivingConvert((LivingEntity)this.kobold, (LivingEntity)newbie));
            }
        });
    }

    private boolean isHoldingAxe() {
        return this.kobold.isHolding(stack -> stack.getItem() instanceof AxeItem);
    }
}

