/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.salju.kobolds.entity.AbstractKoboldSkeleton;
import net.salju.kobolds.entity.ai.WitherboldAttackSelector;
import net.salju.kobolds.events.KoboldsManager;
import net.salju.kobolds.init.KoboldsTags;

public class KoboldWither
extends AbstractKoboldSkeleton {
    public KoboldWither(EntityType<KoboldWither> type, Level world) {
        super(type, world);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.getNavigation().setCanOpenDoors(true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new OpenDoorGoal((Mob)this, false));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(1, (Goal)new RangedCrossbowAttackGoal((Monster)this, 1.0, 12.0f));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 12, true, true, (TargetingConditions.Selector)new WitherboldAttackSelector(this)));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive() && player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty()) {
            this.playSound(this.getAmbientSound(), 1.0f, 1.2f);
            if (!this.level().isClientSide()) {
                player.addEffect(new MobEffectInstance(MobEffects.WITHER, 200), (Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData data) {
        SpawnGroupData spawndata = super.finalizeSpawn(world, difficulty, reason, data);
        this.setCanPickUpLoot(true);
        return spawndata;
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource randy, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.NETHERITE_SWORD));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected void populateDefaultEquipmentEnchantments(ServerLevelAccessor lvl, RandomSource randy, DifficultyInstance difficulty) {
        this.getMainHandItem().enchant(KoboldsManager.getEnchantment(lvl, "minecraft", "smite"), 5);
    }

    protected boolean canReplaceCurrentItem(ItemStack drop, ItemStack hand, EquipmentSlot slot) {
        if (drop.is(KoboldsTags.ARMOR)) {
            return hand.isEmpty() || this.canReplaceEqualItem(drop, hand);
        }
        return false;
    }

    public boolean canReplaceEqualItem(ItemStack drop, ItemStack hand) {
        if (drop.isEnchanted()) {
            if (hand.isEnchanted()) {
                int id = 0;
                ItemEnchantments.Mutable dropMap = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)drop));
                for (Holder e : dropMap.keySet()) {
                    if (e.is(KoboldsTags.ENCHS)) {
                        id += 5 * dropMap.getLevel(e);
                        continue;
                    }
                    id += dropMap.getLevel(e);
                }
                int ih = 0;
                ItemEnchantments.Mutable handMap = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)hand));
                for (Holder e : handMap.keySet()) {
                    if (e.is(KoboldsTags.ENCHS)) {
                        ih += 5 * handMap.getLevel(e);
                        continue;
                    }
                    ih += handMap.getLevel(e);
                }
                if (id > ih) {
                    return true;
                }
            }
            return !hand.isEnchanted();
        }
        return super.canReplaceEqualItem(drop, hand);
    }

    public boolean doHurtTarget(ServerLevel lvl, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, 200), (Entity)this);
        }
        return super.doHurtTarget(lvl, entity);
    }

    public boolean canBeLeashed() {
        return true;
    }

    public boolean shouldDespawnInPeaceful() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_SKELETON_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.WITHER_SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WITHER_SKELETON_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.WITHER_SKELETON_STEP;
    }

    protected AbstractArrow getArrow(ItemStack stack, float f, @Nullable ItemStack weapon) {
        AbstractArrow ammo = super.getArrow(stack, f, weapon);
        ammo.igniteForSeconds(100.0f);
        return ammo;
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return effect.is(MobEffects.WITHER) ? false : super.canBeAffected(effect);
    }
}

