/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.util.WindowPart;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class MosaicBlock
extends StainedGlassBlock
implements BeaconBeamBlock {
    public static final EnumProperty<WindowPart> PART = EnumProperty.create((String)"part", WindowPart.class);
    private DyeColor color;

    public DyeColor getColor() {
        return this.color;
    }

    public MosaicBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)WindowPart.BASE)));
    }

    private BlockState WindowState(BlockState state, LevelReader level, BlockPos pos) {
        boolean below;
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean bl = below = level.getBlockState(pos.below()).getBlock() == this;
        if (above && below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)WindowPart.MIDDLE));
        }
        if (!above && below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)WindowPart.TOP));
        }
        if (above && !below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)WindowPart.BOTTOM));
        }
        return (BlockState)state.setValue(PART, (Comparable)((Object)WindowPart.BASE));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            this.WindowState(state, (LevelReader)level, pos);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.WindowState(super.getStateForPlacement(context), (LevelReader)context.getLevel(), context.getClickedPos());
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.setBlock(pos, this.defaultBlockState(), num);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return this.WindowState(state, level, currentPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART});
    }
}

