/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen;

import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.screen.EmoteMenu;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.server.serializer.EmoteWriter;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import io.github.kosmx.emotes.server.serializer.type.ISerializer;
import io.github.kosmx.emotes.server.services.InstanceService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;

public class ExportMenu
extends class_437 {
    private static final class_2561 TITLE = class_2561.method_43471((String)"emotecraft.options.export");
    private final class_8132 layout = new class_8132((class_437)this);
    protected final class_437 parent;

    public ExportMenu(class_437 parent) {
        super(TITLE);
        this.parent = parent;
    }

    public void method_25426() {
        this.layout.method_57726(this.method_25440(), this.field_22793);
        class_7845 gridLayout = new class_7845();
        gridLayout.method_46458().method_46477(8).method_46475(4).method_46467();
        class_7845.class_7939 rowHelper = gridLayout.method_47610(2);
        for (ISerializer serializer : UniversalEmoteSerializer.getSerializers().toList()) {
            rowHelper.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43469((String)"emotecraft.export", (Object[])new Object[]{serializer.getExtension()}), button -> this.exportEmotesInFormat(serializer)).method_46432(200).method_46431());
        }
        this.layout.method_48999((class_8021)gridLayout);
        class_8667 footer = (class_8667)this.layout.method_48996((class_8021)class_8667.method_52742().method_52735(8));
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46431());
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)EmoteMenu.OPEN_FOLDER, button -> PlatformTools.openExternalEmotesDir()).method_46431());
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    private void exportEmotesInFormat(ISerializer format) {
        Path exportDir = InstanceService.INSTANCE.getExternalEmoteDir().resolve(format.getExtension() + "_export");
        try {
            Files.createDirectories(exportDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (EmoteHolder emoteHolder : EmoteHolder.list) {
            Animation emote = emoteHolder.getEmote();
            if (emote.data().has("isBuiltin")) continue;
            CommonData.LOGGER.debug("Saving {} into {}", (Object)emoteHolder.name.getString(), (Object)format.getExtension());
            try {
                EmoteWriter.writeAnimationInFormat(emote, exportDir, format);
            }
            catch (Exception e) {
                CommonData.LOGGER.warn("Failed to export!", (Throwable)e);
                PlatformTools.addToast((class_2561)class_2561.method_43469((String)"emotecraft.export.error", (Object[])new Object[]{format.getExtension()}), emoteHolder.name);
            }
        }
        String exportPath = InstanceService.INSTANCE.getGameDirectory().relativize(exportDir).normalize().toString().replace(File.separator, "/");
        PlatformTools.addToast((class_2561)class_2561.method_43469((String)"emotecraft.export.done", (Object[])new Object[]{format.getExtension()}), (class_2561)class_2561.method_43470((String)exportPath));
        CommonData.LOGGER.info("All emotes are saved in {} format!", (Object)format.getExtension());
    }

    protected void method_48640() {
        this.layout.method_48222();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }
}

