/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.nixieTube;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.redstone.nixieTube.DoubleFaceAttachedBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.utility.DyeHelper;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Random;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class NixieTubeRenderer
extends SafeBlockEntityRenderer<NixieTubeBlockEntity> {
    private static Random r = new Random();

    public NixieTubeRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(NixieTubeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ms.m_85836_();
        BlockState blockState = be.m_58900_();
        DoubleFaceAttachedBlock.DoubleAttachFace face = (DoubleFaceAttachedBlock.DoubleAttachFace)((Object)blockState.m_61143_((Property)NixieTubeBlock.FACE));
        float yRot = AngleHelper.horizontalAngle((Direction)((Direction)blockState.m_61143_((Property)NixieTubeBlock.f_54117_))) - 90.0f + (float)(face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 180 : 0);
        float xRot = face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL ? -90.0f : (face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 90.0f : 0.0f);
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)msr.center()).rotateYDegrees(yRot)).rotateZDegrees(xRot)).uncenter();
        if (be.signalState != null) {
            this.renderAsSignal(be, partialTicks, ms, buffer, light, overlay);
            ms.m_85849_();
            return;
        }
        msr.center();
        float height = face == DoubleFaceAttachedBlock.DoubleAttachFace.CEILING ? 5.0f : 3.0f;
        float scale = 0.05f;
        Couple<String> s = be.getDisplayedStrings();
        DyeColor color = NixieTubeBlock.colorOf(be.m_58900_());
        ms.m_85836_();
        ms.m_252880_(-0.25f, 0.0f, 0.0f);
        ms.m_85841_(scale, -scale, scale);
        NixieTubeRenderer.drawTube(ms, buffer, (String)s.getFirst(), height, color);
        ms.m_85849_();
        ms.m_85836_();
        ms.m_252880_(0.25f, 0.0f, 0.0f);
        ms.m_85841_(scale, -scale, scale);
        NixieTubeRenderer.drawTube(ms, buffer, (String)s.getSecond(), height, color);
        ms.m_85849_();
        ms.m_85849_();
    }

    public static void drawTube(PoseStack ms, MultiBufferSource buffer, String c, float height, DyeColor color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        float charWidth = fontRenderer.m_92895_(c);
        float shadowOffset = 0.5f;
        float flicker = r.nextFloat();
        Couple<Integer> couple = DyeHelper.getDyeColors(color);
        int brightColor = (Integer)couple.getFirst();
        int darkColor = (Integer)couple.getSecond();
        int flickeringBrightColor = Color.mixColors((int)brightColor, (int)darkColor, (float)(flicker / 4.0f));
        ms.m_85836_();
        ms.m_252880_((charWidth - shadowOffset) / -2.0f, -height, 0.0f);
        NixieTubeRenderer.drawInWorldString(ms, buffer, c, flickeringBrightColor);
        ms.m_85836_();
        ms.m_252880_(shadowOffset, shadowOffset, -0.0625f);
        NixieTubeRenderer.drawInWorldString(ms, buffer, c, darkColor);
        ms.m_85849_();
        ms.m_85849_();
        ms.m_85836_();
        ms.m_85841_(-1.0f, 1.0f, 1.0f);
        ms.m_252880_((charWidth - shadowOffset) / -2.0f, -height, 0.0f);
        NixieTubeRenderer.drawInWorldString(ms, buffer, c, darkColor);
        ms.m_85836_();
        ms.m_252880_(-shadowOffset, shadowOffset, -0.0625f);
        NixieTubeRenderer.drawInWorldString(ms, buffer, c, Color.mixColors((int)darkColor, (int)0, (float)0.35f));
        ms.m_85849_();
        ms.m_85849_();
    }

    public static void drawInWorldString(PoseStack ms, MultiBufferSource buffer, String c, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        fontRenderer.m_271703_(c, 0.0f, 0.0f, color, false, ms.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            BakedGlyph texturedglyph = fontRenderer.m_92863_(Style.f_131100_).m_95064_();
            ((MultiBufferSource.BufferSource)buffer).m_109912_(texturedglyph.m_181387_(Font.DisplayMode.NORMAL));
        }
    }

    private void renderAsSignal(NixieTubeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        Direction facing = NixieTubeBlock.getFacing(blockState);
        Vec3 observerVec = Minecraft.m_91087_().f_91075_.m_20299_(partialTicks);
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        if (facing == Direction.DOWN) {
            ((PoseTransformStack)((PoseTransformStack)msr.center()).rotateZDegrees(180.0f)).uncenter();
        }
        boolean invertTubes = facing == Direction.DOWN || blockState.m_61143_((Property)NixieTubeBlock.FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED;
        CachedBuffers.partial((PartialModel)AllPartialModels.SIGNAL_PANEL, (BlockState)blockState).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        ms.m_85836_();
        ms.m_252880_(0.5f, 0.46875f, 0.5f);
        float renderTime = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        for (boolean first : Iterate.trueAndFalse) {
            Vec3 lampVec = Vec3.m_82512_((Vec3i)be.m_58899_());
            Vec3 diff = lampVec.m_82546_(observerVec);
            if (first && !be.signalState.isRedLight(renderTime) || !first && !be.signalState.isGreenLight(renderTime) && !be.signalState.isYellowLight(renderTime)) continue;
            boolean flip = first == invertTubes;
            boolean yellow = be.signalState.isYellowLight(renderTime);
            ms.m_85836_();
            ms.m_252880_(flip ? 0.25f : -0.25f, 0.0f, 0.0f);
            if (diff.m_82556_() < 9216.0) {
                boolean vert = first ^ facing.m_122434_().m_122479_();
                float longSide = yellow ? 1.0f : 4.0f;
                float longSideGlow = yellow ? 2.0f : 5.125f;
                ((SuperByteBuffer)CachedBuffers.partial((PartialModel)AllPartialModels.SIGNAL_WHITE_CUBE, (BlockState)blockState).light(0xF000F0).disableDiffuse().scale(vert ? longSide : 1.0f, vert ? 1.0f : longSide, 1.0f)).renderInto(ms, buffer.m_6299_(RenderType.m_110466_()));
                ((SuperByteBuffer)CachedBuffers.partial((PartialModel)(first ? AllPartialModels.SIGNAL_RED_GLOW : (yellow ? AllPartialModels.SIGNAL_YELLOW_GLOW : AllPartialModels.SIGNAL_WHITE_GLOW)), (BlockState)blockState).light(0xF000F0).disableDiffuse().scale(vert ? longSideGlow : 2.0f, vert ? 2.0f : longSideGlow, 2.0f)).renderInto(ms, buffer.m_6299_(RenderTypes.additive()));
            }
            ((SuperByteBuffer)CachedBuffers.partial((PartialModel)(first ? AllPartialModels.SIGNAL_RED : (yellow ? AllPartialModels.SIGNAL_YELLOW : AllPartialModels.SIGNAL_WHITE)), (BlockState)blockState).light(0xF000F0).disableDiffuse().scale(1.0625f)).renderInto(ms, buffer.m_6299_(RenderTypes.additive()));
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    public int m_142163_() {
        return 128;
    }
}

