/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools.tag;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.worldgen.trimmable.tools.TrimmableTools;
import dev.worldgen.trimmable.tools.platform.Services;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import org.jetbrains.annotations.Nullable;

public final class ClientTags {
    private static final Map<TagKey<?>, LoadedTag> LOCAL_TAG_HIERARCHY = new ConcurrentHashMap();

    public static Set<ResourceLocation> getOrCreateLocalTag(TagKey<?> tagKey) {
        return ClientTags.getOrCreatePartiallySyncedTag(tagKey).completeIds();
    }

    public static LoadedTag getOrCreatePartiallySyncedTag(TagKey<?> tagKey) {
        LoadedTag loadedTag = LOCAL_TAG_HIERARCHY.get(tagKey);
        if (loadedTag == null) {
            loadedTag = ClientTags.loadTag(tagKey);
            LOCAL_TAG_HIERARCHY.put(tagKey, loadedTag);
        }
        return loadedTag;
    }

    public static LoadedTag loadTag(final TagKey<?> tagKey) {
        HashSet tags = new HashSet();
        HashSet<Path> tagFiles = ClientTags.getDataFiles(tagKey.f_203867_(), tagKey.f_203868_());
        for (Path tagPath : tagFiles) {
            try {
                BufferedReader tagReader = Files.newBufferedReader(tagPath);
                try {
                    JsonElement jsonElement = JsonParser.parseReader((Reader)tagReader);
                    TagFile maybeTagFile = TagFile.f_215958_.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement)).result().orElse(null);
                    if (maybeTagFile == null) continue;
                    if (maybeTagFile.f_215960_()) {
                        tags.clear();
                    }
                    tags.addAll(maybeTagFile.f_215959_());
                }
                finally {
                    if (tagReader == null) continue;
                    tagReader.close();
                }
            }
            catch (FileNotFoundException | NoSuchFileException tagReader) {
            }
            catch (IOException e) {
                TrimmableTools.LOGGER.error("Error loading tag: " + String.valueOf(tagKey), (Throwable)e);
            }
        }
        HashSet completeIds = new HashSet();
        final HashSet immediateChildIds = new HashSet();
        final HashSet immediateChildTags = new HashSet();
        for (TagEntry tagEntry : tags) {
            tagEntry.m_215927_((TagEntry.Lookup)new TagEntry.Lookup<ResourceLocation>(){

                @Nullable
                public ResourceLocation element(ResourceLocation id) {
                    immediateChildIds.add(id);
                    return id;
                }

                @Nullable
                public Collection<ResourceLocation> m_214048_(ResourceLocation id) {
                    TagKey tag = TagKey.m_203882_((ResourceKey)tagKey.f_203867_(), (ResourceLocation)id);
                    immediateChildTags.add(tag);
                    return ClientTags.getOrCreatePartiallySyncedTag(tag).completeIds;
                }
            }, completeIds::add);
        }
        immediateChildTags.remove(tagKey);
        return new LoadedTag(Collections.unmodifiableSet(completeIds), Collections.unmodifiableSet(immediateChildTags), Collections.unmodifiableSet(immediateChildIds));
    }

    private static HashSet<Path> getDataFiles(ResourceKey<? extends Registry<?>> registryKey, ResourceLocation identifier) {
        return ClientTags.getDataFiles(TagManager.m_203918_(registryKey), identifier);
    }

    private static HashSet<Path> getDataFiles(String folder, ResourceLocation identifier) {
        String tagFile = "data/%s/%s/%s.json".formatted(identifier.m_135827_(), folder, identifier.m_135815_());
        return new HashSet<Path>(Services.PLATFORM.findPaths(tagFile));
    }

    public record LoadedTag(Set<ResourceLocation> completeIds, Set<TagKey<?>> immediateChildTags, Set<ResourceLocation> immediateChildIds) {
    }
}

