/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools.resource;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.worldgen.trimmable.tools.TrimmableTools;
import dev.worldgen.trimmable.tools.TrimmableToolsClient;
import dev.worldgen.trimmable.tools.config.ConfigHandler;
import dev.worldgen.trimmable.tools.config.ToolTags;
import dev.worldgen.trimmable.tools.config.TrimData;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;

public class TrimmableToolsResourceHelper {
    private static final Gson GSON = new Gson();

    public static void addAllTrimOverrides(Map<ResourceLocation, Resource> models) {
        for (Map.Entry<ResourceLocation, Resource> entry : new HashSet<Map.Entry<ResourceLocation, Resource>>(models.entrySet())) {
            ResourceLocation key = entry.getKey();
            if (!ToolTags.EVERYTHING_TRIMMABLE.contains(TrimmableToolsResourceHelper.stripModelAffixes(key))) continue;
            try {
                BufferedReader reader = entry.getValue().m_215508_();
                try {
                    JsonObject json = GsonHelper.m_13859_((Reader)reader);
                    ResourceLocation toolType = ToolTags.getToolType(key);
                    if (toolType.equals((Object)ToolTags.UNKNOWN)) continue;
                    String toolMaterial = ConfigHandler.getDarkerMaterial(key);
                    String parent = TrimmableToolsResourceHelper.getParent(json);
                    String layer0 = TrimmableToolsResourceHelper.getLayer0(json);
                    JsonArray overrides = TrimmableToolsResourceHelper.getOverrides(json);
                    List<ResourceLocation> patterns = TrimData.PATTERNS;
                    for (int i = 0; i < patterns.size(); ++i) {
                        String pattern = patterns.get(i).m_135815_();
                        List<ResourceLocation> materials = TrimData.MATERIALS;
                        for (int j = 0; j < materials.size(); ++j) {
                            Object material = materials.get(j).m_135815_();
                            if (((String)material).equals(toolMaterial)) {
                                material = (String)material + "_darker";
                            }
                            ResourceLocation rawModelId = TrimmableToolsResourceHelper.createTrimmedToolId(key, pattern, (String)material);
                            models.put(rawModelId, TrimmableToolsResourceHelper.createTrimOverrideResource(entry.getValue().m_247173_(), parent, layer0, toolType, pattern, (String)material));
                            JsonObject override = new JsonObject();
                            override.addProperty("model", TrimmableToolsResourceHelper.createModelId(rawModelId));
                            JsonObject predicate = new JsonObject();
                            predicate.addProperty(TrimmableToolsClient.TRIM_PATTERN.toString(), (Number)Float.valueOf((float)(i + 1) / 1000.0f));
                            predicate.addProperty(TrimmableToolsClient.TRIM_MATERIAL.toString(), (Number)Float.valueOf((float)(j + 1) / 1000.0f));
                            override.add("predicate", (JsonElement)predicate);
                            overrides.add((JsonElement)override);
                        }
                        json.add("overrides", (JsonElement)overrides);
                        models.put(entry.getKey(), new Resource(entry.getValue().m_247173_(), TrimmableToolsResourceHelper.createSupplier(json)));
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonSyntaxException reader) {
            }
            catch (Exception e) {
                TrimmableTools.LOGGER.error("Couldn't load trimmable tool data from model {}", (Object)key, (Object)e);
            }
        }
    }

    public static ResourceLocation stripModelAffixes(ResourceLocation id) {
        String path = id.m_135815_();
        return new ResourceLocation(id.m_135827_(), path.substring(path.lastIndexOf("/") + 1, path.length() - 5));
    }

    private static ResourceLocation createTrimmedToolId(ResourceLocation id, String pattern, String material) {
        return new ResourceLocation(id.m_135827_(), id.m_135815_().replace(".json", String.format("_%s_%s.json", pattern, material)));
    }

    private static String createModelId(ResourceLocation id) {
        String path = id.m_135815_();
        return new ResourceLocation(id.m_135827_(), path.substring(7, path.length() - 5)).toString();
    }

    private static Resource createTrimOverrideResource(PackResources pack, String parent, String layer0, ResourceLocation toolType, String pattern, String material) {
        JsonObject textures = new JsonObject();
        textures.addProperty("layer0", layer0);
        textures.addProperty("layer1", String.format("%s:trims/items/%s/%s_%s", toolType.m_135827_(), toolType.m_135815_(), pattern, material));
        JsonObject json = new JsonObject();
        json.addProperty("parent", parent);
        json.add("textures", (JsonElement)textures);
        return new Resource(pack, TrimmableToolsResourceHelper.createSupplier(json));
    }

    private static String getParent(JsonObject json) {
        return GsonHelper.m_13906_((JsonObject)json, (String)"parent");
    }

    private static String getLayer0(JsonObject json) {
        JsonObject textures = GsonHelper.m_13930_((JsonObject)json, (String)"textures");
        return GsonHelper.m_13906_((JsonObject)textures, (String)"layer0");
    }

    private static JsonArray getOverrides(JsonObject json) {
        try {
            return GsonHelper.m_13933_((JsonObject)json, (String)"overrides");
        }
        catch (Exception e) {
            return new JsonArray();
        }
    }

    private static IoSupplier<InputStream> createSupplier(JsonObject json) {
        return () -> IOUtils.toInputStream((String)GSON.toJson((JsonElement)json), (String)"UTF-8");
    }
}

