/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools.resource;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.trimmable.tools.TrimmableTools;
import dev.worldgen.trimmable.tools.config.ConfigHandler;
import dev.worldgen.trimmable.tools.config.TrimData;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;

public record TrimPalettedPermutations(List<ResourceLocation> textures, ResourceLocation paletteKey, Map<String, ResourceLocation> permutations) implements SpriteSource
{
    public static final Codec<TrimPalettedPermutations> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)ResourceLocation.f_135803_.fieldOf("palette_key").forGetter(TrimPalettedPermutations::paletteKey)).apply((Applicative)instance, TrimPalettedPermutations::create));

    public static TrimPalettedPermutations create(ResourceLocation paletteKey) {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        for (ResourceLocation toolType : ConfigHandler.config().toolTypes().keySet()) {
            for (ResourceLocation pattern : TrimData.PATTERNS) {
                textures.add(toolType.m_246208_("trims/items/").m_266382_("/" + pattern.m_135815_()));
            }
        }
        HashMap<String, ResourceLocation> permutations = new HashMap<String, ResourceLocation>();
        for (ResourceLocation id : TrimData.MATERIALS) {
            String key = id.m_135815_();
            ResourceLocation entry = id.m_246208_("trims/color_palettes/");
            permutations.put(key, entry);
            if (!ConfigHandler.hasDarkerVariant(key)) continue;
            permutations.put(key + "_darker", entry.m_266382_("_darker"));
        }
        return new TrimPalettedPermutations(textures, paletteKey, permutations);
    }

    public void m_260891_(@NotNull ResourceManager manager, @NotNull SpriteSource.Output output) {
        Supplier supplier = Suppliers.memoize(() -> TrimPalettedPermutations.loadPaletteEntryFromImage(manager, this.paletteKey));
        HashMap map = new HashMap();
        this.permutations.forEach((arg_0, arg_1) -> TrimPalettedPermutations.lambda$run$3(map, (java.util.function.Supplier)supplier, manager, arg_0, arg_1));
        for (ResourceLocation textureId : this.textures) {
            ResourceLocation textureFileId = f_266012_.m_245698_(textureId);
            Optional optional = manager.m_213713_(textureFileId);
            if (optional.isEmpty()) {
                TrimmableTools.LOGGER.warn("Unable to find texture {}", (Object)textureFileId);
                continue;
            }
            LazyLoadedImage lazyloadedimage = new LazyLoadedImage(textureFileId, (Resource)optional.get(), map.size());
            for (Map.Entry entry : map.entrySet()) {
                ResourceLocation palettedId = textureId.m_266382_("_" + (String)entry.getKey());
                output.m_260840_(palettedId, (SpriteSource.SpriteSupplier)new PalettedSpriteSupplier(lazyloadedimage, (java.util.function.Supplier)entry.getValue(), palettedId));
            }
        }
    }

    private static IntUnaryOperator createPaletteMapping(int[] p_266839_, int[] p_266776_) {
        if (p_266776_.length != p_266839_.length) {
            TrimmableTools.LOGGER.warn("Palette mapping has different sizes: {} and {}", (Object)p_266839_.length, (Object)p_266776_.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap int2intmap = new Int2IntOpenHashMap(p_266776_.length);
        for (int i = 0; i < p_266839_.length; ++i) {
            int j = p_266839_[i];
            if (FastColor.ABGR32.m_266503_((int)j) == 0) continue;
            int2intmap.put(FastColor.ABGR32.m_266533_((int)j), p_266776_[i]);
        }
        return arg_0 -> TrimPalettedPermutations.lambda$createPaletteMapping$4((Int2IntMap)int2intmap, arg_0);
    }

    public static int[] loadPaletteEntryFromImage(ResourceManager manager, ResourceLocation palette) {
        Optional optional = manager.m_213713_(f_266012_.m_245698_(palette));
        if (optional.isEmpty()) {
            TrimmableTools.LOGGER.error("Failed to load palette image {}", (Object)palette);
            throw new IllegalArgumentException();
        }
        try {
            int[] pixels;
            try (InputStream inputstream = ((Resource)optional.get()).m_215507_();
                 NativeImage nativeimage = NativeImage.m_85058_((InputStream)inputstream);){
                pixels = nativeimage.m_266370_();
            }
            return pixels;
        }
        catch (Exception var12) {
            TrimmableTools.LOGGER.error("Couldn't load texture {}", (Object)palette, (Object)var12);
            throw new IllegalArgumentException();
        }
    }

    @NotNull
    public SpriteSourceType m_260850_() {
        return SpriteSources.f_266099_;
    }

    private static /* synthetic */ int lambda$createPaletteMapping$4(Int2IntMap int2intmap, int p_267899_) {
        int k = FastColor.ABGR32.m_266503_((int)p_267899_);
        if (k == 0) {
            return p_267899_;
        }
        int l = FastColor.ABGR32.m_266533_((int)p_267899_);
        int i1 = int2intmap.getOrDefault(l, FastColor.ABGR32.m_267818_((int)l));
        int j1 = FastColor.ABGR32.m_266503_((int)i1);
        return FastColor.ABGR32.m_266498_((int)(k * j1 / 255), (int)i1);
    }

    private static /* synthetic */ void lambda$run$3(Map map, java.util.function.Supplier supplier, ResourceManager manager, String p_267108_, ResourceLocation p_266969_) {
        map.put(p_267108_, Suppliers.memoize(() -> TrimPalettedPermutations.lambda$run$2((java.util.function.Supplier)supplier, manager, p_266969_)));
    }

    private static /* synthetic */ IntUnaryOperator lambda$run$2(java.util.function.Supplier supplier, ResourceManager manager, ResourceLocation p_266969_) {
        return TrimPalettedPermutations.createPaletteMapping((int[])supplier.get(), TrimPalettedPermutations.loadPaletteEntryFromImage(manager, p_266969_));
    }

    record PalettedSpriteSupplier(LazyLoadedImage baseImage, java.util.function.Supplier<IntUnaryOperator> palette, ResourceLocation permutationLocation) implements SpriteSource.SpriteSupplier
    {
        public SpriteContents get() {
            try {
                NativeImage nativeimage = this.baseImage.m_266167_().m_266528_(this.palette.get());
                SpriteContents spriteContents = new SpriteContents(this.permutationLocation, new FrameSize(nativeimage.m_84982_(), nativeimage.m_85084_()), nativeimage, AnimationMetadataSection.f_119012_);
                return spriteContents;
            }
            catch (IOException | IllegalArgumentException var8) {
                TrimmableTools.LOGGER.error("Unable to apply palette to {}", (Object)this.permutationLocation, (Object)var8);
            }
            finally {
                this.baseImage.m_266458_();
            }
            return null;
        }

        public void m_260986_() {
            this.baseImage.m_266458_();
        }
    }
}

