/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools.forge;

import dev.worldgen.trimmable.tools.TrimmableToolsClient;
import dev.worldgen.trimmable.tools.config.TrimData;
import java.util.Optional;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod(value="trimmable_tools")
public class TrimmableToolsForge {

    @Mod.EventBusSubscriber(modid="trimmable_tools", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            TrimmableToolsClient.init();
            ItemProperties.registerGeneric((ResourceLocation)TrimmableToolsClient.TRIM_PATTERN, (stack, world, entity, seed) -> {
                if (world == null) {
                    return Float.NEGATIVE_INFINITY;
                }
                Optional trim = ArmorTrim.m_266285_((RegistryAccess)world.m_9598_(), (ItemStack)stack);
                if (trim.isEmpty()) {
                    return Float.NEGATIVE_INFINITY;
                }
                ResourceLocation id = ((ArmorTrim)trim.get()).m_266429_().m_203543_().orElse(TrimPatterns.f_265901_).m_135782_();
                return ((float)TrimData.PATTERNS.indexOf(id) + 1.0f) / 1000.0f;
            });
            ItemProperties.registerGeneric((ResourceLocation)TrimmableToolsClient.TRIM_MATERIAL, (stack, world, entity, seed) -> {
                if (world == null) {
                    return Float.NEGATIVE_INFINITY;
                }
                Optional trim = ArmorTrim.m_266285_((RegistryAccess)world.m_9598_(), (ItemStack)stack);
                if (trim.isEmpty()) {
                    return Float.NEGATIVE_INFINITY;
                }
                ResourceLocation id = ((ArmorTrim)trim.get()).m_266210_().m_203543_().orElse(TrimMaterials.f_265870_).m_135782_();
                return ((float)TrimData.MATERIALS.indexOf(id) + 1.0f) / 1000.0f;
            });
        }
    }
}

