/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.trimmable.tools.TrimmableTools;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public record TrimDataConfig(Map<ResourceLocation, TagKey<Item>> toolTypes, Map<String, List<ResourceLocation>> darkerMaterials, List<ResourceLocation> extraPatterns, List<ResourceLocation> extraMaterials) {
    public static final Codec<TrimDataConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)TagKey.m_203886_((ResourceKey)Registries.f_256913_)).fieldOf("tool_types").forGetter(TrimDataConfig::toolTypes), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.f_135803_.listOf()).fieldOf("darker_materials").forGetter(TrimDataConfig::darkerMaterials), (App)ResourceLocation.f_135803_.listOf().fieldOf("extra_patterns").forGetter(TrimDataConfig::extraPatterns), (App)ResourceLocation.f_135803_.listOf().fieldOf("extra_materials").forGetter(TrimDataConfig::extraMaterials)).apply((Applicative)instance, TrimDataConfig::new));
    public static final TrimDataConfig DEFAULT = new TrimDataConfig(Map.of(TrimmableTools.id("axe"), ItemTags.f_271207_, TrimmableTools.id("hoe"), ItemTags.f_271298_, TrimmableTools.id("pickaxe"), ItemTags.f_271360_, TrimmableTools.id("shovel"), ItemTags.f_271138_, TrimmableTools.id("sword"), ItemTags.f_271388_), Map.ofEntries(TrimDataConfig.darkerMaterial("iron"), TrimDataConfig.darkerMaterial("golden"), TrimDataConfig.darkerMaterial("diamond"), TrimDataConfig.darkerMaterial("netherite")), List.of(), List.of());

    private static Map.Entry<String, List<ResourceLocation>> darkerMaterial(String prefix) {
        ResourceLocation base = TrimDataConfig.vanilla(prefix);
        if (prefix.equals("golden")) {
            prefix = "gold";
        }
        return Map.entry(prefix, List.of(base.m_266382_("_axe"), base.m_266382_("_hoe"), base.m_266382_("_pickaxe"), base.m_266382_("_shovel"), base.m_266382_("_sword")));
    }

    private static ResourceLocation vanilla(String name) {
        return new ResourceLocation(name);
    }
}

