/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.worldgen.trimmable.tools.TrimmableTools;
import dev.worldgen.trimmable.tools.config.TrimDataConfig;
import dev.worldgen.trimmable.tools.platform.Services;
import dev.worldgen.trimmable.tools.resource.TrimmableToolsResourceHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ConfigHandler {
    private static final Path CONFIG_PATH = Services.PLATFORM.getConfigFolder().resolve("trimmable_tools.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static TrimDataConfig config = TrimDataConfig.DEFAULT;

    public static void load() {
        if (!Files.isRegularFile(CONFIG_PATH, new LinkOption[0])) {
            ConfigHandler.writeDefault();
        }
        try {
            JsonElement json = JsonParser.parseString((String)new String(Files.readAllBytes(CONFIG_PATH)));
            DataResult dataResult = TrimDataConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            dataResult.error().ifPresent(error -> {
                TrimmableTools.LOGGER.error("Config file has missing or invalid data: " + error.message());
                ConfigHandler.writeDefault();
            });
            if (dataResult.result().isPresent()) {
                config = (TrimDataConfig)dataResult.result().get();
            }
        }
        catch (IOException e) {
            TrimmableTools.LOGGER.error("Malformed json in config file found, default config will be used");
            ConfigHandler.writeDefault();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static TrimDataConfig config() {
        return config;
    }

    public static String getDarkerMaterial(ResourceLocation modelId) {
        ResourceLocation id = TrimmableToolsResourceHelper.stripModelAffixes(modelId);
        for (Map.Entry<String, List<ResourceLocation>> entry : config.darkerMaterials().entrySet()) {
            if (!entry.getValue().contains(id)) continue;
            return entry.getKey();
        }
        return "";
    }

    public static boolean hasDarkerVariant(String name) {
        return config.darkerMaterials().keySet().stream().anyMatch(key -> key.equals(name));
    }

    private static void writeDefault() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            JsonElement json = (JsonElement)TrimDataConfig.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)TrimDataConfig.DEFAULT).get().orThrow();
            writer.write(GSON.toJson(json));
        }
        catch (Exception e) {
            TrimmableTools.LOGGER.error("Couldn't write default config to file");
        }
    }
}

